/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestTemplate;

@Service
public class FileService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    protected static final String METADATA_TMP_PREFIX = "KylinMetadataBackupTmp-";
    @Autowired
    @Qualifier(value="normalRestTemplate")
    private RestTemplate restTemplate;

    public static String getSafeAbsolutePath(String filePath) {
        java.nio.file.Path basePath = Paths.get("/tmp", new String[0]).toAbsolutePath().normalize();
        java.nio.file.Path targetPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
        if (!targetPath.startsWith(basePath)) {
            throw new SecurityException("Path outside base directory: " + filePath);
        }
        java.nio.file.Path metadataTmpPrefix = Paths.get(basePath.toString(), METADATA_TMP_PREFIX).toAbsolutePath().normalize();
        if (!StringUtils.startsWith((CharSequence)targetPath.toString(), (CharSequence)metadataTmpPrefix.toString())) {
            throw new SecurityException("Path not kylin metadata tmp directory: " + filePath);
        }
        return targetPath.toString();
    }

    public InputStream getMetadataBackupFromTmpPath(String tmpFilePath, Long fileSize) throws IOException {
        String realTempPath = FileService.getSafeAbsolutePath(tmpFilePath);
        File metadataBackupTmp = new File(realTempPath);
        if (metadataBackupTmp.isFile()) {
            if (metadataBackupTmp.length() != fileSize.longValue()) {
                throw new FileNotFoundException("Metadata backup temp file length does not right: " + tmpFilePath + ", length :" + metadataBackupTmp.length());
            }
            return Files.newInputStream(metadataBackupTmp.toPath(), new OpenOption[0]);
        }
        throw new FileNotFoundException("Metadata backup temp file is not a file: " + tmpFilePath);
    }

    public Pair<String, Long> saveMetadataBackupInTmpPath(String path) throws IOException {
        Path filePath;
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        if (fileSystem.isFile(filePath = new Path(path))) {
            FileStatus fileStatus = fileSystem.getFileStatus(filePath);
            File tempDirectory = Files.createTempDirectory(Paths.get("/tmp", new String[0]), METADATA_TMP_PREFIX, new FileAttribute[0]).toFile();
            fileSystem.copyToLocalFile(false, filePath, new Path(tempDirectory.getAbsolutePath()), true);
            File tmpFile = new File(tempDirectory, "metadata.zip");
            if (fileStatus.getLen() != tmpFile.length()) {
                throw new FileNotFoundException("Metadata backup temp file length does not right.\n File: " + tmpFile.getAbsolutePath() + ", length :" + tmpFile.length() + ";\n HDFS backup file:" + path + ", len: " + fileStatus.getLen());
            }
            log.info("Metadata backup temp file path is [{}]", (Object)tmpFile.getAbsolutePath());
            return Pair.newPair((Object)tmpFile.getAbsolutePath(), (Object)tmpFile.length());
        }
        throw new FileNotFoundException("Metadata backup file is not a file: " + path);
    }

    public String saveMetadataBackupTmpFromRequest(Long fileSize, InputStream inputStream) throws IOException {
        File tmpDirectory = Files.createTempDirectory(METADATA_TMP_PREFIX, new FileAttribute[0]).toFile();
        File tmpFile = new File(tmpDirectory, "metadata.zip");
        try (FileOutputStream os = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
            long actualFileSize = tmpFile.length();
            if (actualFileSize != fileSize) {
                throw new FileNotFoundException("Metadata backup temp file length does not right: " + tmpFile.getAbsolutePath() + " length :" + actualFileSize);
            }
            String string = tmpFile.getAbsolutePath();
            return string;
        }
    }

    public void saveMetadataBackupInHDFS(String path, String tmpFilePath, Long fileSize) throws IOException {
        Path filePath;
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        if (fileSystem.isFile(filePath = new Path(path))) {
            return;
        }
        if (fileSystem.isDirectory(filePath)) {
            fileSystem.delete(filePath, true);
        }
        fileSystem.copyFromLocalFile(new Path(tmpFilePath), filePath);
        FileStatus fileStatus = fileSystem.getFileStatus(filePath);
        if (fileStatus.getLen() != fileSize.longValue()) {
            throw new FileNotFoundException("Metadata backup temp file length does not right.\n Tmp file: " + tmpFilePath + " length: " + fileSize + "\n DFS file: " + path + " length: " + fileStatus.getLen());
        }
    }

    public void deleteTmpDir(String fileTmpPath) {
        File tmpFile = new File(fileTmpPath);
        File tmpDir = tmpFile.getParentFile();
        try {
            FileUtils.deleteDirectory((File)tmpDir);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String downloadMetadataBackTmpFile(String tmpFilePath, Long tmpFileSize, String resourceGroupId, String fromHost) throws JsonProcessingException {
        String url = String.format(Locale.ROOT, "http://%s/kylin/api/system/metadata_backup_tmp_file", fromHost);
        HashMap req = Maps.newHashMap();
        req.put("resource_group_id", resourceGroupId);
        req.put("tmp_file_path", tmpFilePath);
        req.put("tmp_file_size", tmpFileSize);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/vnd.apache.kylin-v4-public+json");
        httpHeaders.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL));
        HttpEntity httpEntity = new HttpEntity((Object)JsonUtil.writeValueAsBytes((Object)req), (MultiValueMap)httpHeaders);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)httpEntity);
        return (String)this.restTemplate.execute(url, HttpMethod.POST, requestCallback, clientResponse -> {
            try (InputStream ins = clientResponse.getBody();){
                String string = this.saveMetadataBackupTmpFromRequest(tmpFileSize, ins);
                return string;
            }
        }, new Object[0]);
    }

    public void saveBroadcastMetadataBackup(String backupDir, String filePath, Long fileSize, String resourceGroupId, String fromHost) {
        String tmpFilePath = "";
        try {
            tmpFilePath = this.downloadMetadataBackTmpFile(filePath, fileSize, resourceGroupId, fromHost);
            log.info("tmpFilePath is [{}]", (Object)tmpFilePath);
            String path = StringUtils.appendIfMissing((String)HadoopUtil.getBackupFolder((KylinConfig)KylinConfig.getInstanceFromEnv()), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + backupDir + "/" + "metadata.zip";
            this.saveMetadataBackupInHDFS(path, tmpFilePath, fileSize);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KylinRuntimeException((Throwable)e);
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)tmpFilePath)) {
                this.deleteTmpDir(tmpFilePath);
            }
        }
    }
}

