/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.security;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.security.AbstractIdentityAssertionBase;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.principal.PrincipalMapper;
import org.apache.knox.gateway.security.principal.PrincipalMappingException;
import org.apache.knox.gateway.security.principal.SimplePrincipalMapper;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.TokenUtils;

public abstract class AbstractIdentityAssertionFilter
extends AbstractIdentityAssertionBase
implements Filter {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final String PARAM_NAME_SIGNATURE_ALG = "signature.algorithm";
    protected PrincipalMapper mapper = new SimplePrincipalMapper();
    protected String signatureAlgorithm;

    protected void loadPrincipalMappings(FilterConfig filterConfig) {
        String principalMapping = filterConfig.getServletContext().getInitParameter("principal.mapping");
        String groupMapping = filterConfig.getServletContext().getInitParameter("group.principal.mapping");
        if (principalMapping != null && !principalMapping.isEmpty() || groupMapping != null && !groupMapping.isEmpty()) {
            try {
                this.mapper.loadMappingTable(principalMapping, groupMapping);
            }
            catch (PrincipalMappingException pme) {
                LOG.failedToLoadPrincipalMappingTable(pme);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.loadPrincipalMappings(filterConfig);
        this.setSignatureAlgorithm(filterConfig);
    }

    private void setSignatureAlgorithm(FilterConfig filterConfig) throws ServletException {
        try {
            String configuredSignatureAlgorithm = filterConfig.getInitParameter(PARAM_NAME_SIGNATURE_ALG);
            GatewayServices services = (GatewayServices)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
            GatewayConfig gatewayConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
            AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
            this.signatureAlgorithm = TokenUtils.getSignatureAlgorithm(configuredSignatureAlgorithm, aliasService, gatewayConfig.getSigningKeystoreName());
        }
        catch (AliasServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }
}

