/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;

public abstract class AbstractGatewayServices
implements GatewayServices {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final Map<ServiceType, Service> services = new EnumMap<ServiceType, Service>(ServiceType.class);
    private final List<Service> orderedServices = new ArrayList<Service>();
    private final String role;
    private final String name;

    AbstractGatewayServices(String role, String name) {
        this.role = role;
        this.name = name;
    }

    public void start() throws ServiceLifecycleException {
        for (Service service : this.orderedServices) {
            LOG.startingService(service.getClass().getName());
            service.start();
        }
    }

    public void stop() throws ServiceLifecycleException {
        ArrayList<Service> copy = new ArrayList<Service>(this.orderedServices);
        Collections.reverse(copy);
        for (Service service : copy) {
            LOG.stoppingService(service.getClass().getName());
            service.stop();
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public Set<ServiceType> getServiceTypes() {
        return this.services.keySet();
    }

    public <T> T getService(ServiceType serviceType) {
        return (T)this.services.get(serviceType);
    }

    protected void addService(ServiceType serviceType, Service service) {
        if (service == null) {
            throw new NullPointerException("A null service may not be added.");
        }
        this.orderedServices.add(service);
        this.services.put(serviceType, service);
    }
}

