/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.engine.DefaultProducerCache;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.SynchronousExecutorService;

public class DefaultProducerTemplate
extends ServiceSupport
implements ProducerTemplate {
    private final CamelContext camelContext;
    private volatile ProducerCache producerCache;
    private volatile ExecutorService executor;
    private Endpoint defaultEndpoint;
    private int maximumCacheSize;
    private boolean eventNotifierEnabled = true;
    private volatile boolean threadedAsyncMode = true;

    public DefaultProducerTemplate(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public DefaultProducerTemplate(CamelContext camelContext, ExecutorService executor) {
        this.camelContext = camelContext;
        this.executor = executor;
    }

    public DefaultProducerTemplate(CamelContext camelContext, Endpoint defaultEndpoint) {
        this(camelContext);
        this.defaultEndpoint = defaultEndpoint;
    }

    public static DefaultProducerTemplate newInstance(CamelContext camelContext, String defaultEndpointUri) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)camelContext, (String)defaultEndpointUri);
        return new DefaultProducerTemplate(camelContext, endpoint);
    }

    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    public boolean isThreadedAsyncMode() {
        return this.threadedAsyncMode;
    }

    public void setThreadedAsyncMode(boolean useExecutor) {
        this.threadedAsyncMode = useExecutor;
    }

    public int getCurrentCacheSize() {
        if (this.producerCache == null) {
            return 0;
        }
        return this.producerCache.size();
    }

    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    public void cleanUp() {
        if (this.producerCache != null) {
            this.producerCache.cleanUp();
        }
    }

    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
        if (this.producerCache != null) {
            this.producerCache.setEventNotifierEnabled(eventNotifierEnabled);
        }
    }

    public Exchange send(String endpointUri, Exchange exchange) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, exchange);
    }

    public Exchange send(String endpointUri, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, null, processor, null);
    }

    public Exchange send(String endpointUri, ExchangePattern pattern, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, pattern, processor, null);
    }

    public Exchange send(Endpoint endpoint, Exchange exchange) {
        return this.send(endpoint, exchange, null);
    }

    public Exchange send(Endpoint endpoint, Processor processor) {
        return this.send(endpoint, null, processor, null);
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        return this.send(endpoint, pattern, processor, null);
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor) {
        Exchange exchange;
        Exchange exchange2 = exchange = pattern != null ? endpoint.createExchange(pattern) : endpoint.createExchange();
        if (processor != null) {
            try {
                processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                return exchange;
            }
        }
        return this.send(endpoint, exchange, resultProcessor);
    }

    public Exchange send(Endpoint endpoint, Exchange exchange, Processor resultProcessor) {
        return this.getProducerCache().send(endpoint, exchange, resultProcessor);
    }

    public Object sendBody(Endpoint endpoint, ExchangePattern pattern, Object body) {
        Exchange result = this.send(endpoint, pattern, this.createSetBodyProcessor(body));
        return this.extractResultBody(result, pattern);
    }

    public void sendBody(Endpoint endpoint, Object body) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createSetBodyProcessor(body));
        this.extractResultBody(result);
    }

    public void sendBody(String endpointUri, Object body) throws CamelExecutionException {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        this.sendBody(endpoint, body);
    }

    public Object sendBody(String endpointUri, ExchangePattern pattern, Object body) throws CamelExecutionException {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Object result = this.sendBody(endpoint, pattern, body);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    public void sendBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) throws CamelExecutionException {
        this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue);
    }

    public void sendBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createBodyAndHeaderProcessor(body, header, headerValue));
        this.extractResultBody(result);
    }

    public Object sendBodyAndHeader(Endpoint endpoint, ExchangePattern pattern, Object body, String header, Object headerValue) throws CamelExecutionException {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body, header, headerValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    public Object sendBodyAndHeader(String endpoint, ExchangePattern pattern, Object body, String header, Object headerValue) throws CamelExecutionException {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body, header, headerValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    public void sendBodyAndProperty(String endpointUri, Object body, String property, Object propertyValue) throws CamelExecutionException {
        this.sendBodyAndProperty(this.resolveMandatoryEndpoint(endpointUri), body, property, propertyValue);
    }

    public void sendBodyAndProperty(Endpoint endpoint, Object body, String property, Object propertyValue) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createBodyAndPropertyProcessor(body, property, propertyValue));
        this.extractResultBody(result);
    }

    public Object sendBodyAndProperty(Endpoint endpoint, ExchangePattern pattern, Object body, String property, Object propertyValue) throws CamelExecutionException {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndPropertyProcessor(body, property, propertyValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    public Object sendBodyAndProperty(String endpoint, ExchangePattern pattern, Object body, String property, Object propertyValue) throws CamelExecutionException {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndPropertyProcessor(body, property, propertyValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws CamelExecutionException {
        this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    public void sendBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers) throws CamelExecutionException {
        Exchange result = this.send(endpoint, this.createBodyAndHeaders(body, headers));
        this.extractResultBody(result);
    }

    public Object sendBodyAndHeaders(String endpointUri, ExchangePattern pattern, Object body, Map<String, Object> headers) throws CamelExecutionException {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), pattern, body, headers);
    }

    public Object sendBodyAndHeaders(Endpoint endpoint, ExchangePattern pattern, Object body, Map<String, Object> headers) throws CamelExecutionException {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndHeaders(body, headers));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern == ExchangePattern.InOnly) {
            return null;
        }
        return result;
    }

    public Exchange request(Endpoint endpoint, Processor processor) {
        return this.send(endpoint, ExchangePattern.InOut, processor);
    }

    public Object requestBody(Object body) throws CamelExecutionException {
        return this.sendBody(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body);
    }

    public Object requestBody(Endpoint endpoint, Object body) throws CamelExecutionException {
        return this.sendBody(endpoint, ExchangePattern.InOut, body);
    }

    public Object requestBodyAndHeader(Object body, String header, Object headerValue) throws CamelExecutionException {
        return this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body, header, headerValue);
    }

    public Object requestBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue) throws CamelExecutionException {
        return this.sendBodyAndHeader(endpoint, ExchangePattern.InOut, body, header, headerValue);
    }

    public Exchange request(String endpointUri, Processor processor) throws CamelExecutionException {
        return this.send(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, processor, null);
    }

    public Object requestBody(String endpointUri, Object body) throws CamelExecutionException {
        return this.sendBody(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, body);
    }

    public Object requestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) throws CamelExecutionException {
        return this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, body, header, headerValue);
    }

    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), ExchangePattern.InOut, body, headers);
    }

    public Object requestBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(endpoint, ExchangePattern.InOut, body, headers);
    }

    public Object requestBodyAndHeaders(Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body, headers);
    }

    public <T> T requestBody(Object body, Class<T> type) {
        return this.requestBody(this.getMandatoryDefaultEndpoint(), body, type);
    }

    public <T> T requestBody(Endpoint endpoint, Object body, Class<T> type) {
        Exchange exchange = this.send(endpoint, ExchangePattern.InOut, this.createSetBodyProcessor(body), this.createConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange);
        return (T)this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    public <T> T requestBody(String endpointUri, Object body, Class<T> type) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Exchange exchange = this.send(endpoint, ExchangePattern.InOut, this.createSetBodyProcessor(body), this.createConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange);
        return (T)this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    public <T> T requestBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue, Class<T> type) {
        Exchange exchange = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaderProcessor(body, header, headerValue), this.createConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange);
        return (T)this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    public <T> T requestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue, Class<T> type) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Exchange exchange = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaderProcessor(body, header, headerValue), this.createConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange);
        return (T)this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    public <T> T requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers, Class<T> type) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Exchange exchange = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaders(body, headers), this.createConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange);
        return (T)this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    public <T> T requestBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers, Class<T> type) {
        Exchange exchange = this.send(endpoint, ExchangePattern.InOut, this.createBodyAndHeaders(body, headers), this.createConvertBodyProcessor(type));
        Object answer = this.extractResultBody(exchange);
        return (T)this.camelContext.getTypeConverter().convertTo(type, answer);
    }

    public void sendBody(Object body) {
        this.sendBody(this.getMandatoryDefaultEndpoint(), body);
    }

    public Exchange send(Exchange exchange) {
        return this.send(this.getMandatoryDefaultEndpoint(), exchange);
    }

    public Exchange send(Processor processor) {
        return this.send(this.getMandatoryDefaultEndpoint(), processor);
    }

    public void sendBodyAndHeader(Object body, String header, Object headerValue) {
        this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), body, header, headerValue);
    }

    public void sendBodyAndProperty(Object body, String property, Object propertyValue) {
        this.sendBodyAndProperty(this.getMandatoryDefaultEndpoint(), body, property, propertyValue);
    }

    public void sendBodyAndHeaders(Object body, Map<String, Object> headers) {
        this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), body, headers);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getCamelContext().getEndpoint(endpointUri));
    }

    protected Processor createBodyAndHeaderProcessor(final Object body, final String header, final Object headerValue) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setHeader(header, headerValue);
                in.setBody(body);
            }
        };
    }

    protected Processor createBodyAndHeaders(final Object body, final Map<String, Object> headers) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                if (headers != null) {
                    for (Map.Entry header : headers.entrySet()) {
                        in.setHeader((String)header.getKey(), header.getValue());
                    }
                }
                in.setBody(body);
            }
        };
    }

    protected Processor createBodyAndPropertyProcessor(final Object body, final String property, final Object propertyValue) {
        return new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty(property, propertyValue);
                Message in = exchange.getIn();
                in.setBody(body);
            }
        };
    }

    protected Processor createSetBodyProcessor(final Object body) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        };
    }

    protected Processor createConvertBodyProcessor(Class<?> type) {
        return new ConvertBodyProcessor(type);
    }

    protected Function<Exchange, Exchange> createCompletionFunction(Synchronization onCompletion) {
        return answer -> {
            if (answer.isFailed()) {
                onCompletion.onFailure(answer);
            } else {
                onCompletion.onComplete(answer);
            }
            return answer;
        };
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        Endpoint endpoint = this.camelContext.getEndpoint(endpointUri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(endpointUri);
        }
        return endpoint;
    }

    protected Endpoint getMandatoryDefaultEndpoint() {
        Endpoint answer = this.getDefaultEndpoint();
        ObjectHelper.notNull((Object)answer, (String)"defaultEndpoint");
        return answer;
    }

    protected Object extractResultBody(Exchange result) {
        return this.extractResultBody(result, null);
    }

    protected Object extractResultBody(Exchange result, ExchangePattern pattern) {
        return ExchangeHelper.extractResultBody((Exchange)result, (ExchangePattern)pattern);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executor = executorService;
    }

    public CompletableFuture<Exchange> asyncSend(String uri, Exchange exchange) {
        return this.asyncSend(this.resolveMandatoryEndpoint(uri), exchange);
    }

    public CompletableFuture<Exchange> asyncSend(String uri, Processor processor) {
        return this.asyncSend(this.resolveMandatoryEndpoint(uri), processor);
    }

    public CompletableFuture<Object> asyncSendBody(String uri, Object body) {
        return this.asyncSendBody(this.resolveMandatoryEndpoint(uri), body);
    }

    public CompletableFuture<Object> asyncRequestBody(String uri, Object body) {
        return this.asyncRequestBody(this.resolveMandatoryEndpoint(uri), body);
    }

    public <T> CompletableFuture<T> asyncRequestBody(String uri, Object body, Class<T> type) {
        return this.asyncRequestBody(this.resolveMandatoryEndpoint(uri), this.createSetBodyProcessor(body), type);
    }

    public CompletableFuture<Object> asyncRequestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) {
        return this.asyncRequestBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue);
    }

    public <T> CompletableFuture<T> asyncRequestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue, Class<T> type) {
        return this.asyncRequestBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue, type);
    }

    public CompletableFuture<Object> asyncRequestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        return this.asyncRequestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    public <T> CompletableFuture<T> asyncRequestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers, Class<T> type) {
        return this.asyncRequestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers, type);
    }

    public <T> T extractFutureBody(Future<?> future, Class<T> type) {
        return (T)ExchangeHelper.extractFutureBody((CamelContext)this.camelContext, future, type);
    }

    public <T> T extractFutureBody(Future<?> future, long timeout, TimeUnit unit, Class<T> type) throws TimeoutException {
        return (T)ExchangeHelper.extractFutureBody((CamelContext)this.camelContext, future, (long)timeout, (TimeUnit)unit, type);
    }

    public CompletableFuture<Object> asyncCallbackSendBody(String uri, Object body, Synchronization onCompletion) {
        return this.asyncCallbackSendBody(this.resolveMandatoryEndpoint(uri), body, onCompletion);
    }

    public CompletableFuture<Object> asyncCallbackSendBody(Endpoint endpoint, Object body, Synchronization onCompletion) {
        return this.asyncCallback(endpoint, ExchangePattern.InOnly, body, onCompletion);
    }

    public CompletableFuture<Object> asyncCallbackRequestBody(String uri, Object body, Synchronization onCompletion) {
        return this.asyncCallbackRequestBody(this.resolveMandatoryEndpoint(uri), body, onCompletion);
    }

    public CompletableFuture<Object> asyncCallbackRequestBody(Endpoint endpoint, Object body, Synchronization onCompletion) {
        return this.asyncCallback(endpoint, ExchangePattern.InOut, body, onCompletion);
    }

    public CompletableFuture<Exchange> asyncCallback(String uri, Exchange exchange, Synchronization onCompletion) {
        return this.asyncCallback(this.resolveMandatoryEndpoint(uri), exchange, onCompletion);
    }

    public CompletableFuture<Exchange> asyncCallback(String uri, Processor processor, Synchronization onCompletion) {
        return this.asyncCallback(this.resolveMandatoryEndpoint(uri), processor, onCompletion);
    }

    public CompletableFuture<Object> asyncRequestBody(Endpoint endpoint, Object body) {
        return this.asyncRequestBody(endpoint, this.createSetBodyProcessor(body));
    }

    public <T> CompletableFuture<T> asyncRequestBody(Endpoint endpoint, Object body, Class<T> type) {
        return this.asyncRequestBody(endpoint, this.createSetBodyProcessor(body), type);
    }

    public CompletableFuture<Object> asyncRequestBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaderProcessor(body, header, headerValue));
    }

    protected <T> CompletableFuture<T> asyncRequestBody(Endpoint endpoint, Processor processor, Class<T> type) {
        return this.asyncRequestBody(endpoint, processor, this.createConvertBodyProcessor(type)).thenApply(answer -> this.camelContext.getTypeConverter().convertTo(type, answer));
    }

    public <T> CompletableFuture<T> asyncRequestBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue, Class<T> type) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaderProcessor(body, header, headerValue), type);
    }

    public CompletableFuture<Object> asyncRequestBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaders(body, headers));
    }

    public <T> CompletableFuture<T> asyncRequestBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers, Class<T> type) {
        return this.asyncRequestBody(endpoint, this.createBodyAndHeaders(body, headers), type);
    }

    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, Exchange exchange) {
        return this.asyncSendExchange(endpoint, null, null, null, exchange);
    }

    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, Processor processor) {
        return this.asyncSend(endpoint, null, processor, null);
    }

    public CompletableFuture<Object> asyncSendBody(Endpoint endpoint, Object body) {
        return this.asyncSend(endpoint, this.createSetBodyProcessor(body)).thenApply(this::extractResultBody);
    }

    public CompletableFuture<Exchange> asyncCallback(Endpoint endpoint, Exchange exchange, Synchronization onCompletion) {
        return this.asyncSend(endpoint, exchange).thenApply(this.createCompletionFunction(onCompletion));
    }

    public CompletableFuture<Exchange> asyncCallback(Endpoint endpoint, Processor processor, Synchronization onCompletion) {
        return this.asyncSend(endpoint, processor).thenApply(this.createCompletionFunction(onCompletion));
    }

    protected CompletableFuture<Object> asyncRequestBody(Endpoint endpoint, Processor processor) {
        return this.asyncRequestBody(endpoint, processor, (Processor)null);
    }

    protected CompletableFuture<Object> asyncRequestBody(Endpoint endpoint, Processor processor, Processor resultProcessor) {
        return this.asyncRequest(endpoint, processor, resultProcessor).thenApply(e -> this.extractResultBody((Exchange)e, ExchangePattern.InOut));
    }

    protected CompletableFuture<Exchange> asyncRequest(Endpoint endpoint, Processor processor, Processor resultProcessor) {
        return this.asyncSend(endpoint, ExchangePattern.InOut, processor, resultProcessor);
    }

    protected CompletableFuture<Exchange> asyncSend(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor) {
        return this.asyncSendExchange(endpoint, pattern, processor, resultProcessor, null);
    }

    protected CompletableFuture<Exchange> asyncSendExchange(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, Exchange inExchange) {
        CompletableFuture<Exchange> exchangeFuture = new CompletableFuture<Exchange>();
        this.getExecutorService().submit(() -> this.getProducerCache().asyncSendExchange(endpoint, pattern, processor, resultProcessor, inExchange, exchangeFuture));
        return exchangeFuture;
    }

    protected CompletableFuture<Object> asyncCallback(Endpoint endpoint, ExchangePattern pattern, Object body, Synchronization onCompletion) {
        return ((CompletableFuture)this.asyncSend(endpoint, pattern, this.createSetBodyProcessor(body), null).thenApply(this.createCompletionFunction(onCompletion))).thenApply(answer -> {
            Object result = this.extractResultBody((Exchange)answer, pattern);
            if (pattern == ExchangePattern.InOnly) {
                return null;
            }
            return result;
        });
    }

    private ProducerCache getProducerCache() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ProducerTemplate has not been started");
        }
        return this.producerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ProducerTemplate has not been started");
        }
        if (this.executor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executor == null) {
                    this.executor = this.threadedAsyncMode ? this.camelContext.getExecutorServiceManager().newDefaultThreadPool((Object)this, "ProducerTemplate") : new SynchronousExecutorService();
                }
            }
        }
        return this.executor;
    }

    protected void doInit() throws Exception {
        if (this.defaultEndpoint != null) {
            this.defaultEndpoint = this.camelContext.getEndpoint(this.defaultEndpoint.getEndpointUri());
        }
        this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, this.maximumCacheSize);
        this.producerCache.setEventNotifierEnabled(this.isEventNotifierEnabled());
        ServiceHelper.initService((Object)this.producerCache);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.producerCache);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.producerCache);
        this.producerCache = null;
    }
}

