/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.storage.log.FetchParams;

public class ShareFetch {
    private final CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> future;
    private final FetchParams fetchParams;
    private final String groupId;
    private final String memberId;
    private final Map<TopicIdPartition, Integer> partitionMaxBytes;
    private final int maxFetchRecords;
    private Map<TopicIdPartition, Throwable> erroneous;

    public ShareFetch(FetchParams fetchParams, String groupId, String memberId, CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> future, Map<TopicIdPartition, Integer> partitionMaxBytes, int maxFetchRecords) {
        this.fetchParams = fetchParams;
        this.groupId = groupId;
        this.memberId = memberId;
        this.future = future;
        this.partitionMaxBytes = partitionMaxBytes;
        this.maxFetchRecords = maxFetchRecords;
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public Map<TopicIdPartition, Integer> partitionMaxBytes() {
        return this.partitionMaxBytes;
    }

    public FetchParams fetchParams() {
        return this.fetchParams;
    }

    public int maxFetchRecords() {
        return this.maxFetchRecords;
    }

    public synchronized void addErroneous(TopicIdPartition topicIdPartition, Throwable throwable) {
        if (this.erroneous == null) {
            this.erroneous = new HashMap<TopicIdPartition, Throwable>();
        }
        this.erroneous.put(topicIdPartition, throwable);
    }

    public boolean isCompleted() {
        return this.future.isDone();
    }

    public synchronized boolean errorInAllPartitions() {
        return this.erroneous != null && this.erroneous.size() == this.partitionMaxBytes().size();
    }

    public void maybeComplete(Map<TopicIdPartition, ShareFetchResponseData.PartitionData> partitionData) {
        if (this.isCompleted()) {
            return;
        }
        HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> response = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>(partitionData);
        this.addErroneousToResponse(response);
        this.future.complete(response);
    }

    public void maybeCompleteWithException(Collection<TopicIdPartition> topicIdPartitions, Throwable throwable) {
        if (this.isCompleted()) {
            return;
        }
        Map<TopicIdPartition, ShareFetchResponseData.PartitionData> response = topicIdPartitions.stream().collect(Collectors.toMap(tp -> tp, tp -> new ShareFetchResponseData.PartitionData().setErrorCode(Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable.getMessage())));
        this.addErroneousToResponse(response);
        this.future.complete(response);
    }

    public synchronized Set<TopicIdPartition> filterErroneousTopicPartitions(Set<TopicIdPartition> topicIdPartitions) {
        if (this.erroneous != null) {
            LinkedHashSet<TopicIdPartition> retain = new LinkedHashSet<TopicIdPartition>(topicIdPartitions);
            retain.removeAll(this.erroneous.keySet());
            return retain;
        }
        return topicIdPartitions;
    }

    private synchronized void addErroneousToResponse(Map<TopicIdPartition, ShareFetchResponseData.PartitionData> response) {
        if (this.erroneous != null) {
            this.erroneous.forEach((topicIdPartition, throwable) -> response.put((TopicIdPartition)topicIdPartition, new ShareFetchResponseData.PartitionData().setErrorCode(Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable.getMessage())));
        }
    }
}

