/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.ServerConnectionId;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dqA\u0002-Z\u0011\u0003YVL\u0002\u0004`3\"\u00051\f\u0019\u0005\u0006O\u0006!\t!\u001b\u0005\bU\u0006\u0011\r\u0011\"\u0003l\u0011\u0019!\u0018\u0001)A\u0005Y\"9Q/\u0001b\u0001\n\u0003Y\u0007B\u0002<\u0002A\u0003%A\u000eC\u0004x\u0003\t\u0007I\u0011A6\t\ra\f\u0001\u0015!\u0003m\u0011\u001dI\u0018A1A\u0005\u0002iDaA`\u0001!\u0002\u0013Y\bbB@\u0002\t\u0003I\u0016\u0011\u0001\u0004\u0007?f\u00031,!\u0010\t\u0013\u0005]CB!b\u0001\n\u0003Q\b\"CA-\u0019\t\u0005\t\u0015!\u0003|\u0011)\tY\u0006\u0004B\u0001B\u0003%\u0011Q\f\u0005\n\u0003Ob!\u0011!Q\u0001\nmD!\"!\u001b\r\u0005\u0003\u0005\u000b\u0011BA6\u0011)\t\t\b\u0004B\u0001B\u0003%\u00111\u000f\u0005\u000b\u0003sb!\u0011!Q\u0001\n\u0005m\u0004\"CAA\u0019\t\u0005\t\u0015!\u0003|\u0011)\t\u0019\t\u0004B\u0001B\u0003%\u0011Q\u0011\u0005\u000b\u0003\u001fc!\u0011!Q\u0001\n\u0005E\u0005BCAQ\u0019\t\u0005\t\u0015!\u0003\u0002$\"Q\u0011\u0011\u0016\u0007\u0003\u0002\u0003\u0006I!a+\t\u0015\u0005UFB!A!\u0002\u0013\t9\f\u0003\u0006\u0002B2\u0011\t\u0011)A\u0005\u0003\u0007D!\"a4\r\u0005\u0003\u0005\u000b\u0011BAi\u0011%\t9\u000e\u0004B\u0001B\u0003%1\u0010\u0003\u0006\u0002Z2\u0011\t\u0011)A\u0005\u00037D!\"a\b\r\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011)\t\t\u000f\u0004B\u0001B\u0003%\u00111\u001d\u0005\u000b\u0003od!\u0011!Q\u0001\n\u0005e\bBB4\r\t\u0003\u0011\t\u0002C\u0005\u0003<1\u0011\r\u0011\"\u0003\u0003>!A!\u0011\n\u0007!\u0002\u0013\u0011y\u0004C\u0005\u0003L1\u0011\r\u0011\"\u0001\u0003N!A!1\r\u0007!\u0002\u0013\u0011y\u0005C\u0005\u0003f1\u0011\r\u0011\"\u0003\u0003N!A!q\r\u0007!\u0002\u0013\u0011y\u0005C\u0005\u0003j1\u0011\r\u0011\"\u0001\u0003l!A!1\u000f\u0007!\u0002\u0013\u0011i\u0007C\u0005\u0003v1\u0011\r\u0011\"\u0003\u0003x!A!Q\u0012\u0007!\u0002\u0013\u0011I\bC\u0005\u0003\u00102\u0011\r\u0011\"\u0003\u0003\u0012\"A!Q\u0016\u0007!\u0002\u0013\u0011\u0019\nC\u0005\u000302\u0011\r\u0011\"\u0003\u00032\"A!\u0011\u0018\u0007!\u0002\u0013\u0011\u0019\f\u0003\u0006\u0003<2\u0011\r\u0011\"\u0001\\\u0005{C\u0001B!2\rA\u0003%!q\u0018\u0005\n\u0005\u000fd!\u0019!C\u0005\u0005\u0013D\u0001Ba6\rA\u0003%!1\u001a\u0005\n\u00053d!\u0019!C\u0005\u00057D\u0001B!:\rA\u0003%!Q\u001c\u0005\u000b\u0005Od!\u0019!C\u00013\n%\b\u0002\u0003By\u0019\u0001\u0006IAa;\t\u0011\tMH\u0002\"\u0005Z\u0005kD\u0001b!\u0001\r\u0001\u0004%IA\u001f\u0005\n\u0007\u0007a\u0001\u0019!C\u0005\u0007\u000bAqa!\u0005\rA\u0003&1\u0010C\u0004\u0004\u00141!\te!\u0006\t\u0011\r]A\u0002\"\u0001Z\u00073Aqa!\u000e\r\t\u0013\u00199\u0004C\u0004\u0004B1!Ia!\u0006\t\u0011\r\rC\u0002\"\u0005Z\u0007\u000bBqa!\u0016\r\t\u0013\u0019)\u0002C\u0004\u0004X1!Ia!\u0006\t\u000f\reC\u0002\"\u0003\u0004\u0016!911\f\u0007\u0005\n\ru\u0003bBB1\u0019\u0011%1Q\u0003\u0005\b\u0007GbA\u0011BB\u000b\u0011\u001d\u0019)\u0007\u0004C\u0005\u0007OBqa!\u001c\r\t\u0003\u0019y\u0007C\u0004\u0004\u00142!Ia!\u0006\t\u000f\rUE\u0002\"\u0003\u0004\u0016!A11\u000e\u0007\u0005\u0012e\u001b9\n\u0003\u0005\u0004*2!\t!WBV\u0011\u001d\u0019y\u000b\u0004C\u0005\u0007cCqaa-\r\t\u0003I&\u0010C\u0004\u000462!\t!\u0017>\t\u0011\r]F\u0002\"\u0001Z\u0007sCqa!3\r\t\u0013\u0019Y\rC\u0004\u0004v2!Iaa>\t\u0011\rmH\u0002\"\u0001Z\u0007{Dq\u0001\"\u0001\r\t\u0003\u0019)\u0002C\u0004\u0005\u00041!\ta!\u0006\t\u000f\u0011\u0015A\u0002\"\u0001\u0004\u0016!91Q\r\u0007\u0005\u0002\rU\u0011!\u0003)s_\u000e,7o]8s\u0015\tQ6,A\u0004oKR<xN]6\u000b\u0003q\u000bQa[1gW\u0006\u0004\"AX\u0001\u000e\u0003e\u0013\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u0014\u0005\u0005\t\u0007C\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0016!F%eY\u0016\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0005Y\u0006twMC\u0001r\u0003\u0011Q\u0017M^1\n\u0005Mt'AB*ue&tw-\u0001\fJI2,\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0003eqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4\u000259+Go^8sWB\u0013xnY3tg>\u0014X*\u001a;sS\u000e$\u0016m\u001a\u0011\u0002#1K7\u000f^3oKJlU\r\u001e:jGR\u000bw-\u0001\nMSN$XM\\3s\u001b\u0016$(/[2UC\u001e\u0004\u0013aE\"p]:,7\r^5p]F+X-^3TSj,W#A>\u0011\u0005\td\u0018BA?d\u0005\rIe\u000e^\u0001\u0015\u0007>tg.Z2uS>t\u0017+^3vKNK'0\u001a\u0011\u0002%A\f'o]3SKF,Xm\u001d;IK\u0006$WM\u001d\u000b\u0007\u0003\u0007\ti\"!\f\u0011\t\u0005\u0015\u0011\u0011D\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005A!/Z9vKN$8O\u0003\u0003\u0002\u000e\u0005=\u0011AB2p[6|gNC\u0002]\u0003#QA!a\u0005\u0002\u0016\u00051\u0011\r]1dQ\u0016T!!a\u0006\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001c\u0005\u001d!!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0002 -\u0001\r!!\t\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9cW\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005-\u0012Q\u0005\u0002\u0012\u0003BLg+\u001a:tS>tW*\u00198bO\u0016\u0014\bbBA\u0018\u0017\u0001\u0007\u0011\u0011G\u0001\u0007EV4g-\u001a:\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000eq\u0003\rq\u0017n\\\u0005\u0005\u0003w\t)D\u0001\u0006CsR,')\u001e4gKJ\u001cr\u0001DA \u0003\u000b\nY\u0005E\u0002n\u0003\u0003J1!a\u0011o\u0005\u0019y%M[3diB\u0019Q.a\u0012\n\u0007\u0005%cN\u0001\u0005Sk:t\u0017M\u00197f!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)7\u0006)Q\u000f^5mg&!\u0011QKA(\u0005\u001daunZ4j]\u001e\f!!\u001b3\u0002\u0007%$\u0007%\u0001\u0003uS6,\u0007\u0003BA0\u0003Gj!!!\u0019\u000b\t\u0005E\u00131B\u0005\u0005\u0003K\n\tG\u0001\u0003US6,\u0017AD7bqJ+\u0017/^3tiNK'0Z\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\rq\u0016QN\u0005\u0004\u0003_J&A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN\u00042AXA;\u0013\r\t9(\u0017\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\fAcY8o]\u0016\u001cG/[8og6\u000b\u00070\u00133mK6\u001b\bc\u00012\u0002~%\u0019\u0011qP2\u0003\t1{gnZ\u0001\u001cM\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8EK2\f\u00170T:\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005\u001d\u00151R\u0007\u0003\u0003\u0013S1AWA\u0006\u0013\u0011\ti)!#\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005CV$\bN\u0003\u0003\u0002\u001c\u0006-\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005}\u0015Q\u0013\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\faaY8oM&<\u0007\u0003BA\u0012\u0003KKA!a*\u0002&\tY1*\u00194lC\u000e{gNZ5h\u0003\u001diW\r\u001e:jGN\u0004B!!,\u000226\u0011\u0011q\u0016\u0006\u0005\u0003S\u000bY!\u0003\u0003\u00024\u0006=&aB'fiJL7m]\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0003\u0002:\u0006uVBAA^\u0015\u0011\tY*a\u0004\n\t\u0005}\u00161\u0018\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0006nK6|'/\u001f)p_2\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY!\u0001\u0004nK6|'/_\u0005\u0005\u0003\u001b\f9M\u0001\u0006NK6|'/\u001f)p_2\f!\u0002\\8h\u0007>tG/\u001a=u!\u0011\ty&a5\n\t\u0005U\u0017\u0011\r\u0002\u000b\u0019><7i\u001c8uKb$\u0018aE2p]:,7\r^5p]F+X-^3TSj,\u0017\u0001F5t!JLg/\u001b7fO\u0016$G*[:uK:,'\u000fE\u0002c\u0003;L1!a8d\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001e5sK\u0006$g*Y7f!\u0011\t)/a=\u000f\t\u0005\u001d\u0018q\u001e\t\u0004\u0003S\u001cWBAAv\u0015\r\ti\u000f[\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E8-\u0001\u0004Qe\u0016$WMZ\u0005\u0004g\u0006U(bAAyG\u0006i2m\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u00148\u000f\u0005\u0004\u0002|\n\u0005!QA\u0007\u0003\u0003{T1!a@d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0007\tiPA\u0002TKF\u0004BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u00045\n-!\u0002BA\u0014\u0003\u001fIAAa\u0004\u0003\n\ta2i\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u0014H\u0003\u000bB\n\u0005+\u00119B!\u0007\u0003\u001c\tu!q\u0004B\u0011\u0005G\u0011)Ca\n\u0003*\t-\"Q\u0006B\u0018\u0005c\u0011\u0019D!\u000e\u00038\te\u0002C\u00010\r\u0011\u0019\t9&\ta\u0001w\"9\u00111L\u0011A\u0002\u0005u\u0003BBA4C\u0001\u00071\u0010C\u0004\u0002j\u0005\u0002\r!a\u001b\t\u000f\u0005E\u0014\u00051\u0001\u0002t!9\u0011\u0011P\u0011A\u0002\u0005m\u0004BBAAC\u0001\u00071\u0010C\u0004\u0002\u0004\u0006\u0002\r!!\"\t\u000f\u0005=\u0015\u00051\u0001\u0002\u0012\"9\u0011\u0011U\u0011A\u0002\u0005\r\u0006bBAUC\u0001\u0007\u00111\u0016\u0005\b\u0003k\u000b\u0003\u0019AA\\\u0011\u001d\t\t-\ta\u0001\u0003\u0007Dq!a4\"\u0001\u0004\t\t\u000e\u0003\u0004\u0002X\u0006\u0002\ra\u001f\u0005\b\u00033\f\u0003\u0019AAn\u0011\u001d\ty\"\ta\u0001\u0003CAq!!9\"\u0001\u0004\t\u0019\u000fC\u0004\u0002x\u0006\u0002\r!!?\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\t}\u0002\u0003\u0002B!\u0005\u000bj!Aa\u0011\u000b\t\u0005%&1B\u0005\u0005\u0005\u000f\u0012\u0019EA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013!C:i_VdGMU;o+\t\u0011y\u0005\u0005\u0003\u0003R\t}SB\u0001B*\u0015\u0011\u0011)Fa\u0016\u0002\r\u0005$x.\\5d\u0015\u0011\u0011IFa\u0017\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0003^A\fA!\u001e;jY&!!\u0011\rB*\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006Q1\u000f[8vY\u0012\u0014VO\u001c\u0011\u0002\u000fM$\u0018M\u001d;fI\u0006A1\u000f^1si\u0016$\u0007%\u0001\u0004uQJ,\u0017\rZ\u000b\u0003\u0005[\u0002B!a\u0018\u0003p%!!\u0011OA1\u0005-Y\u0015MZ6b)\"\u0014X-\u00193\u0002\u000fQD'/Z1eA\u0005qa.Z<D_:tWm\u0019;j_:\u001cXC\u0001B=!\u0019\u0011YH! \u0003\u00026\u0011!qK\u0005\u0005\u0005\u007f\u00129F\u0001\nBeJ\f\u0017P\u00117pG.LgnZ)vKV,\u0007\u0003\u0002BB\u0005\u0013k!A!\"\u000b\t\t\u001d\u0015QG\u0001\tG\"\fgN\\3mg&!!1\u0012BC\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fY\u0006ya.Z<D_:tWm\u0019;j_:\u001c\b%A\tj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tKN,\"Aa%\u0011\u0011\tU%1TAr\u0005?k!Aa&\u000b\t\te\u0015Q`\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iJa&\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003\"\n\u001dfb\u00010\u0003$&\u0019!QU-\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!!\u0011\u0016BV\u0005!\u0011Vm\u001d9p]N,'b\u0001BS3\u0006\u0011\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:!\u00035\u0011Xm\u001d9p]N,\u0017+^3vKV\u0011!1\u0017\t\u0007\u0005w\u0012)La(\n\t\t]&q\u000b\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h\t\u0016\fX/Z\u0001\u000fe\u0016\u001c\bo\u001c8tKF+X-^3!\u0003)iW\r\u001e:jGR\u000bwm]\u000b\u0003\u0005\u007f\u0003bA!1\u0003D2dWB\u0001B.\u0013\u0011\u0011iJa\u0017\u0002\u00175,GO]5d)\u0006<7\u000fI\u0001\u001eKb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oiV\u0011!1\u001a\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*!!\u0011[AX\u0003\u0015\u0019H/\u0019;t\u0013\u0011\u0011)Na4\u0003\u001b\r+X.\u001e7bi&4XmU;n\u0003y)\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$\b%A\u0014fqBL'/\u001a3D_:tWm\u0019;j_:\u001c8*\u001b7mK\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,WC\u0001Bo!\u0011\u0011yN!9\u000e\u0005\u0005-\u0011\u0002\u0002Br\u0003\u0017\u0011!\"T3ue&\u001cg*Y7f\u0003!*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003!\u0019X\r\\3di>\u0014XC\u0001Bv!\u0011\t9I!<\n\t\t=\u0018\u0011\u0012\u0002\t'\u0016dWm\u0019;pe\u0006I1/\u001a7fGR|'\u000fI\u0001\u000fGJ,\u0017\r^3TK2,7\r^8s)\u0011\u0011YOa>\t\u000f\te\b\b1\u0001\u0003|\u0006q1\r[1o]\u0016d')^5mI\u0016\u0014\b\u0003BAD\u0005{LAAa@\u0002\n\nq1\t[1o]\u0016d')^5mI\u0016\u0014\u0018a\u00058fqR\u001cuN\u001c8fGRLwN\\%oI\u0016D\u0018a\u00068fqR\u001cuN\u001c8fGRLwN\\%oI\u0016Dx\fJ3r)\u0011\u00199a!\u0004\u0011\u0007\t\u001cI!C\u0002\u0004\f\r\u0014A!\u00168ji\"A1q\u0002\u001e\u0002\u0002\u0003\u000710A\u0002yIE\nAC\\3yi\u000e{gN\\3di&|g.\u00138eKb\u0004\u0013a\u0001:v]R\u00111qA\u0001\u0011aJ|7-Z:t\u000bb\u001cW\r\u001d;j_:$baa\u0002\u0004\u001c\r}\u0001bBB\u000f{\u0001\u0007\u00111]\u0001\rKJ\u0014xN]'fgN\fw-\u001a\u0005\b\u0007Ci\u0004\u0019AB\u0012\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0004&\r=b\u0002BB\u0014\u0007WqA!!;\u0004*%\tA-C\u0002\u0004.\r\fq\u0001]1dW\u0006<W-\u0003\u0003\u00042\rM\"!\u0003+ie><\u0018M\u00197f\u0015\r\u0019icY\u0001\u0018aJ|7-Z:t\u0007\"\fgN\\3m\u000bb\u001cW\r\u001d;j_:$\u0002ba\u0002\u0004:\ru2q\b\u0005\b\u0007wq\u0004\u0019AAr\u0003%\u0019\u0007.\u00198oK2LE\rC\u0004\u0004\u001ey\u0002\r!a9\t\u000f\r\u0005b\b1\u0001\u0004$\u0005\u0019\u0002O]8dKN\u001ch*Z<SKN\u0004xN\\:fg\u0006a1/\u001a8e%\u0016\u001c\bo\u001c8tKR11qAB$\u0007\u0017Bqa!\u0013A\u0001\u0004\u0011y*\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\u0019i\u0005\u0011a\u0001\u0007\u001f\nAB]3ta>t7/Z*f]\u0012\u0004B!a\"\u0004R%!11KAE\u0005\u0011\u0019VM\u001c3\u0002\tA|G\u000e\\\u0001\u0019aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u0014VmY3jm\u0016\u001c\u0018!\u00069s_\u000e,7o]\"p[BdW\r^3e'\u0016tGm]\u0001\u0015kB$\u0017\r^3SKF,Xm\u001d;NKR\u0014\u0018nY:\u0015\t\r\u001d1q\f\u0005\b\u0007\u0013\"\u0005\u0019\u0001BP\u0003M\u0001(o\\2fgN$\u0015n]2p]:,7\r^3e\u0003Y\u0019Gn\\:f\u000bb\u001cWm]:D_:tWm\u0019;j_:\u001c\u0018!B2m_N,G\u0003BB\u0004\u0007SBqaa\u001bH\u0001\u0004\t\u0019/\u0001\u0007d_:tWm\u0019;j_:LE-\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\t\u00037\u001c\th!\u001e\u0004z!911\u000f%A\u0002\t\u0005\u0015!D:pG.,Go\u00115b]:,G\u000eC\u0004\u0004x!\u0003\r!a7\u0002\u00115\f\u0017P\u00117pG.Dqaa\u001fI\u0001\u0004\u0019i(\u0001\rbG\u000e,\u0007\u000f^8s\u0013\u0012dW\rU3sG\u0016tG/T3uKJ\u0004Baa \u0004\u00106\u00111\u0011\u0011\u0006\u0005\u0007\u0007\u001b))\u0001\u0003d_J,'\u0002BAU\u0007\u000fSAa!#\u0004\f\u00061\u00110Y7nKJT!a!$\u0002\u0007\r|W.\u0003\u0003\u0004\u0012\u000e\u0005%!B'fi\u0016\u0014\u0018aF2p]\u001aLw-\u001e:f\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0003!\u0019Gn\\:f\u00032dG\u0003BAr\u00073Cqaa'L\u0001\u0004\u0019i*\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\u0007?\u001b)+\u0004\u0002\u0004\"*\u001911\u00159\u0002\u00079,G/\u0003\u0003\u0004(\u000e\u0005&AB*pG.,G/A\bf]F,X-^3SKN\u0004xN\\:f)\u0011\u00199a!,\t\u000f\r%C\n1\u0001\u0003 \u0006yA-Z9vKV,'+Z:q_:\u001cX\r\u0006\u0002\u0003 \u0006\t\"/Z:q_:\u001cX-U;fk\u0016\u001c\u0016N_3\u0002+%tg\r\\5hQR\u0014Vm\u001d9p]N,7i\\;oi\u0006!r\u000e]3o\u001fJ\u001cEn\\:j]\u001e\u001c\u0005.\u00198oK2$Baa/\u0004HB)!m!0\u0004B&\u00191qX2\u0003\r=\u0003H/[8o!\u0011\t9ia1\n\t\r\u0015\u0017\u0011\u0012\u0002\r\u0017\u000647.Y\"iC:tW\r\u001c\u0005\b\u0007W\u0002\u0006\u0019AAr\u0003YA\u0017M\u001c3mK\u000eC\u0017M\u001c8fY6+H/Z#wK:$HCBB\u0004\u0007\u001b\u001cy\rC\u0004\u0004lE\u0003\r!a9\t\u000f\rE\u0017\u000b1\u0001\u0004T\u0006)QM^3oiB!1Q[Bx\u001d\u0011\u00199na;\u000f\t\re7\u0011\u001e\b\u0005\u00077\u001c9O\u0004\u0003\u0004^\u000e\u0015h\u0002BBp\u0007GtA!!;\u0004b&\u0011\u0011qC\u0005\u0005\u0003'\t)\"C\u0002]\u0003#IA!!\u0004\u0002\u0010%\u0019!,a\u0003\n\t\r5\u0018\u0011R\u0001\r\u0017\u000647.Y\"iC:tW\r\\\u0005\u0005\u0007c\u001c\u0019P\u0001\tDQ\u0006tg.\u001a7NkR,WI^3oi*!1Q^AE\u0003A!(/_+o[V$Xm\u00115b]:,G\u000e\u0006\u0003\u0004\b\re\bbBB6%\u0002\u0007\u00111]\u0001\bG\"\fgN\\3m)\u0011\u0019Yla@\t\u000f\r-4\u000b1\u0001\u0002d\u0006)1\u000f^1si\u00061q/Y6fkB\fQBY3hS:\u001c\u0006.\u001e;e_^t\u0007")
public class Processor
implements Runnable,
Logging {
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final boolean isPrivilegedListener;
    private final ApiVersionManager apiVersionManager;
    private final Seq<ConnectionDisconnectListener> connectionDisconnectListeners;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final AtomicBoolean started;
    private final KafkaThread thread;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    private CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    public Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        try {
            while (this.shouldRun().get()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing selector - processor " + this.id());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (ControlThrowable)throwable;
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Closing socket for " + channelId + " because of error", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Socket server received empty response to send, registering for read: " + noOpResponse);
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException("Unknown response type: " + currentResponse.getClass());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, "Exception while processing response for " + channelId, e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Socket server received response to send to " + connectionId + ", registering for write and sending data: " + response);
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to send response via channel for which there is no open connection, connection id " + connectionId);
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            this.selector().send(new NetworkSend(connectionId, responseSend));
            this.inflightResponses().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
            return;
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof IllegalStateException ? true : throwable instanceof IOException) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Processor " + this.id() + " poll failed", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = Processor$.MODULE$.parseRequestHeader($this.apiVersionManager, receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String>)(Function0 & Serializable)() -> "Begin re-authentication: " + channel);
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> "Disconnecting expired channel: " + channel + " : " + header);
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), Optional.of(Predef$.MODULE$.int2Integer(channel.socketPort())), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.isPrivilegedListener, channel.principalSerde());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics(), (Option<RequestChannel.Request>)None$.MODULE$);
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException("Channel " + receive.source() + " removed from selector before processing completed receive");
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), "Exception while processing request from " + receive.source(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                RequestChannel.Response response = (RequestChannel.Response)this.inflightResponses().remove((Object)send.destinationId()).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException("Send for " + send.destinationId() + " completed, but not in `inflightResponses`");
                });
                response.onComplete().foreach((Function1 & Serializable)onComplete -> {
                    onComplete.apply((Object)send);
                    return BoxedUnit.UNIT;
                });
                this.updateRequestMetrics(response);
                this.handleChannelMuteEvent(send.destinationId(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destinationId());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destinationId(), "Exception while processing completed send to " + send.destinationId(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                String remoteHost = ((ServerConnectionId)ServerConnectionId.fromString((String)connectionId).orElseThrow(() -> {
                    throw new IllegalStateException("connectionId has unexpected format: " + connectionId);
                })).remoteHost();
                this.inflightResponses().remove(connectionId).foreach((Function1 & Serializable)response -> {
                    this.updateRequestMetrics(response);
                    return BoxedUnit.UNIT;
                });
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                $this.connectionDisconnectListeners.foreach((Function1 & Serializable)listener -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
                        listener.onDisconnect(connectionId$2);
                        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxedUnit.UNIT);
                    }, this, Level.ERROR);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable e) {
                this.processException("Exception while processing disconnection of " + connectionId, e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName)) {
            KafkaChannel channel = this.selector().lowestPriorityChannel();
            if (channel != null) {
                this.close(channel.id());
                return;
            }
            return;
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)channel -> {
            Processor.$anonfun$close$2(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        if (this.newConnections().offer(socketChannel)) {
            v0 = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            v0 = true;
        } else {
            v0 = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Processor " + this.id() + " listening to new connection from " + channel.socket().getRemoteSocketAddress());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.connectionQuotas.closeChannel(this, this.listenerName, channel);
                this.processException("Processor " + this.id() + " closed connection from " + remoteAddress, e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        this.metricsGroup().removeMetric(Processor$.MODULE$.kafka$network$Processor$$IdlePercentMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(this.id()))}))).asJava());
    }

    public String connectionId(Socket socket) {
        String connId = ServerConnectionId.generateConnectionId((Socket)socket, (int)this.id(), (int)this.nextConnectionIndex());
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    private RequestChannel.Response dequeueResponse() {
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return response;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public void start() {
        if (!this.started().getAndSet(true)) {
            this.thread().start();
            return;
        }
    }

    public void wakeup() {
        this.selector().wakeup();
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            return;
        }
    }

    public void close() {
        try {
            this.beginShutdown();
            this.thread().join();
            if (!this.started().get()) {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
            }
        }
        catch (Throwable throwable) {
            this.metricsGroup().removeMetric("IdlePercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))).asJava());
            this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
            throw throwable;
        }
        this.metricsGroup().removeMetric("IdlePercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))).asJava());
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    public static final /* synthetic */ double $anonfun$new$19(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double $anonfun$new$17(Processor $this) {
        void metricName_tags;
        void metricName_group;
        void metricName_name;
        Metrics metrics = $this.metrics;
        java.util.Map<String, String> map = $this.metricTags();
        String string = SocketServer$.MODULE$.MetricsGroup();
        String string2 = "io-wait-ratio";
        if (metrics == null) {
            throw null;
        }
        string2 = null;
        string = null;
        map = null;
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics.metric(metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags))).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$19(m))));
    }

    public static final /* synthetic */ void $anonfun$close$2(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing selector connection " + connectionId$3);
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.connectionDisconnectListeners.foreach((Function1 & Serializable)listener -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
                listener.onDisconnect(connectionId$3);
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxedUnit.UNIT);
            }, $this, Level.ERROR);
            return BoxedUnit.UNIT;
        });
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize, boolean isPrivilegedListener, ApiVersionManager apiVersionManager, String threadName, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        void addMetric_measurable;
        void metricName_tags;
        void metricName_group;
        void metricName_name;
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        this.isPrivilegedListener = isPrivilegedListener;
        this.apiVersionManager = apiVersionManager;
        this.connectionDisconnectListeners = connectionDisconnectListeners;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.started = new AtomicBoolean();
        this.thread = new KafkaThread(threadName, (Runnable)this, false);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava();
        this.metricsGroup().newGauge(Processor$.MODULE$.kafka$network$Processor$$IdlePercentMetricName(), () -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$17(this)), CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava());
        this.expiredConnectionsKilledCount = new CumulativeSum();
        java.util.Map<String, String> map = this.metricTags();
        String string = SocketServer$.MODULE$.MetricsGroup();
        String string2 = "expired-connections-killed-count";
        if (metrics == null) {
            throw null;
        }
        string2 = null;
        string = null;
        map = null;
        this.expiredConnectionsKilledCountMetricName = metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
        CumulativeSum cumulativeSum = this.expiredConnectionsKilledCount();
        MetricName addMetric_metricName = this.expiredConnectionsKilledCountMetricName();
        metrics.addMetric(addMetric_metricName, null, (MetricValueProvider)addMetric_measurable);
        Object var24_24 = null;
        cumulativeSum = null;
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache, (DelegationTokenCache)credentialProvider.tokenCache, (Time)time, (LogContext)logContext, version -> $this.apiVersionManager.apiVersionResponse(0, Predef$.MODULE$.Short2short(version) < 4)));
        this.nextConnectionIndex = 0;
    }
}

