/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;

public class InConstraint
extends ConstraintTerm {
    private final List<Node> values = new ArrayList<Node>();

    public InConstraint(List<Node> list) {
        this.values.addAll(list);
    }

    public List<Node> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Node getComponent() {
        return SHACL.InConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (this.values.contains(n)) {
            return null;
        }
        String errMsg = this.toString() + " : RDF term " + ShLib.displayStr(n) + " not in expected values";
        return new ReportItem(errMsg, n);
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compactArrayNodes(out, nodeFmt, "in", this.values);
    }

    public String toString() {
        return "InConstraint" + String.valueOf(this.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InConstraint)) {
            return false;
        }
        InConstraint other = (InConstraint)obj;
        return Objects.equals(this.values, other.values);
    }
}

