/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;

public class AggCountVarDistinct
extends AggregatorBase {
    public AggCountVarDistinct(Expr expr) {
        super("COUNT", true, expr);
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggCountVarDistinct(exprs.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountDistinctVar(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.exprList.hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggCountVarDistinct)) {
            return false;
        }
        AggCountVarDistinct agg = (AggCountVarDistinct)other;
        return agg.getExpr().equals(this.getExpr(), bySyntax);
    }

    private static class AccCountDistinctVar
    extends AccumulatorExpr {
        private Set<NodeValue> seen = new HashSet<NodeValue>();

        public AccCountDistinctVar(Expr expr) {
            super(expr, false);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            this.seen.add(nv);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.seen.size());
        }
    }
}

