/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeUsage;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AttributeTypeDefinition
extends SchemaElement {
    private static final long serialVersionUID = -6688185196734362719L;
    @NotNull
    private final AttributeUsage usage;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObsolete;
    private final boolean isSingleValued;
    @NotNull
    private final Map<String, String[]> extensions;
    @NotNull
    private final String attributeTypeString;
    @Nullable
    private final String description;
    @Nullable
    private final String equalityMatchingRule;
    @NotNull
    private final String oid;
    @Nullable
    private final String orderingMatchingRule;
    @Nullable
    private final String substringMatchingRule;
    @Nullable
    private final String superiorType;
    @Nullable
    private final String syntaxOID;
    @NotNull
    private final String[] names;

    public AttributeTypeDefinition(@NotNull String s) throws LDAPException {
        String synOID;
        String supType;
        String subRule;
        String ordRule;
        String eqRule;
        String descr;
        LinkedHashMap<String, String[]> exts;
        Boolean singleValue;
        Boolean obsolete;
        Boolean noUserMod;
        Boolean collective;
        AttributeUsage attrUsage;
        ArrayList<String> nameList;
        block36: {
            String token;
            Validator.ensureNotNull(s);
            this.attributeTypeString = s.trim();
            int length = this.attributeTypeString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_EMPTY.get());
            }
            if (this.attributeTypeString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_NO_OPENING_PAREN.get(this.attributeTypeString));
            }
            int pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            attrUsage = null;
            collective = null;
            noUserMod = null;
            obsolete = null;
            singleValue = null;
            exts = new LinkedHashMap<String, String[]>(StaticUtils.computeMapCapacity(5));
            descr = null;
            eqRule = null;
            ordRule = null;
            subRule = null;
            supType = null;
            synOID = null;
            while (true) {
                String lowerToken;
                int tokenStartPos = pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                while (pos < length && this.attributeTypeString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.attributeTypeString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_CLOSE_NOT_AT_END.get(this.attributeTypeString));
                    }
                    break block36;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        pos = AttributeTypeDefinition.readQDStrings(this.attributeTypeString, pos, length, token, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readQDString(this.attributeTypeString, pos, length, token, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "OBSOLETE"));
                }
                if (lowerToken.equals("sup")) {
                    if (supType == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
                        supType = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SUP"));
                }
                if (lowerToken.equals("equality")) {
                    if (eqRule == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
                        eqRule = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "EQUALITY"));
                }
                if (lowerToken.equals("ordering")) {
                    if (ordRule == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
                        ordRule = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "ORDERING"));
                }
                if (lowerToken.equals("substr")) {
                    if (subRule == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
                        subRule = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SUBSTR"));
                }
                if (lowerToken.equals("syntax")) {
                    if (synOID == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
                        synOID = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SYNTAX"));
                }
                if (lowerToken.equals("single-value")) {
                    if (singleValue == null) {
                        singleValue = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SINGLE-VALUE"));
                }
                if (lowerToken.equals("collective")) {
                    if (collective == null) {
                        collective = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "COLLECTIVE"));
                }
                if (lowerToken.equals("no-user-modification")) {
                    if (noUserMod == null) {
                        noUserMod = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "NO-USER-MODIFICATION"));
                }
                if (lowerToken.equals("usage")) {
                    if (attrUsage == null) {
                        pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeTypeDefinition.readOID(this.attributeTypeString, pos, length, buffer);
                        String usageStr = StaticUtils.toLowerCase(buffer.toString());
                        if (usageStr.equals("userapplications")) {
                            attrUsage = AttributeUsage.USER_APPLICATIONS;
                            continue;
                        }
                        if (usageStr.equals("directoryoperation")) {
                            attrUsage = AttributeUsage.DIRECTORY_OPERATION;
                            continue;
                        }
                        if (usageStr.equals("distributedoperation")) {
                            attrUsage = AttributeUsage.DISTRIBUTED_OPERATION;
                            continue;
                        }
                        if (usageStr.equals("dsaoperation")) {
                            attrUsage = AttributeUsage.DSA_OPERATION;
                            continue;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_INVALID_USAGE.get(this.attributeTypeString, usageStr));
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "USAGE"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = AttributeTypeDefinition.readQDStrings(this.attributeTypeString, pos, length, token, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_DUP_EXT.get(this.attributeTypeString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_UNEXPECTED_TOKEN.get(this.attributeTypeString, token));
        }
        this.description = descr;
        this.equalityMatchingRule = eqRule;
        this.orderingMatchingRule = ordRule;
        this.substringMatchingRule = subRule;
        this.superiorType = supType;
        this.syntaxOID = synOID;
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.isObsolete = obsolete != null;
        this.isSingleValued = singleValue != null;
        this.isCollective = collective != null;
        this.isNoUserModification = noUserMod != null;
        this.usage = attrUsage == null ? AttributeUsage.USER_APPLICATIONS : attrUsage;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public AttributeTypeDefinition(@NotNull String oid, @Nullable String name, @Nullable String description, @Nullable String equalityMatchingRule, @Nullable String orderingMatchingRule, @Nullable String substringMatchingRule, @Nullable String syntaxOID, boolean isSingleValued, @Nullable Map<String, String[]> extensions) {
        String[] stringArray;
        if (name == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this(oid, stringArray, description, false, null, equalityMatchingRule, orderingMatchingRule, substringMatchingRule, syntaxOID, isSingleValued, false, false, AttributeUsage.USER_APPLICATIONS, extensions);
    }

    public AttributeTypeDefinition(@NotNull String oid, @Nullable String[] names, @Nullable String description, boolean isObsolete, @Nullable String superiorType, @Nullable String equalityMatchingRule, @Nullable String orderingMatchingRule, @Nullable String substringMatchingRule, @Nullable String syntaxOID, boolean isSingleValued, boolean isCollective, boolean isNoUserModification, @Nullable AttributeUsage usage, @Nullable Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.description = description;
        this.isObsolete = isObsolete;
        this.superiorType = superiorType;
        this.equalityMatchingRule = equalityMatchingRule;
        this.orderingMatchingRule = orderingMatchingRule;
        this.substringMatchingRule = substringMatchingRule;
        this.syntaxOID = syntaxOID;
        this.isSingleValued = isSingleValued;
        this.isCollective = isCollective;
        this.isNoUserModification = isNoUserModification;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.usage = usage == null ? AttributeUsage.USER_APPLICATIONS : usage;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.attributeTypeString = buffer.toString();
    }

    private void createDefinitionString(@NotNull StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            AttributeTypeDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.superiorType != null) {
            buffer.append(" SUP ");
            buffer.append(this.superiorType);
        }
        if (this.equalityMatchingRule != null) {
            buffer.append(" EQUALITY ");
            buffer.append(this.equalityMatchingRule);
        }
        if (this.orderingMatchingRule != null) {
            buffer.append(" ORDERING ");
            buffer.append(this.orderingMatchingRule);
        }
        if (this.substringMatchingRule != null) {
            buffer.append(" SUBSTR ");
            buffer.append(this.substringMatchingRule);
        }
        if (this.syntaxOID != null) {
            buffer.append(" SYNTAX ");
            buffer.append(this.syntaxOID);
        }
        if (this.isSingleValued) {
            buffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective) {
            buffer.append(" COLLECTIVE");
        }
        if (this.isNoUserModification) {
            buffer.append(" NO-USER-MODIFICATION");
        }
        buffer.append(" USAGE ");
        buffer.append(this.usage.getName());
        for (Map.Entry entry : this.extensions.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                AttributeTypeDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                AttributeTypeDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    @NotNull
    public String[] getNames() {
        return this.names;
    }

    @NotNull
    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(@NotNull String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Nullable
    public String getSuperiorType() {
        return this.superiorType;
    }

    @Nullable
    public AttributeTypeDefinition getSuperiorType(@NotNull Schema schema) {
        if (this.superiorType != null) {
            return schema.getAttributeType(this.superiorType);
        }
        return null;
    }

    @Nullable
    public String getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    @Nullable
    public String getEqualityMatchingRule(@NotNull Schema schema) {
        AttributeTypeDefinition sup;
        if (this.equalityMatchingRule == null && (sup = this.getSuperiorType(schema)) != null) {
            return sup.getEqualityMatchingRule(schema);
        }
        return this.equalityMatchingRule;
    }

    @Nullable
    public String getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    @Nullable
    public String getOrderingMatchingRule(@NotNull Schema schema) {
        AttributeTypeDefinition sup;
        if (this.orderingMatchingRule == null && (sup = this.getSuperiorType(schema)) != null) {
            return sup.getOrderingMatchingRule(schema);
        }
        return this.orderingMatchingRule;
    }

    @Nullable
    public String getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    @Nullable
    public String getSubstringMatchingRule(@NotNull Schema schema) {
        AttributeTypeDefinition sup;
        if (this.substringMatchingRule == null && (sup = this.getSuperiorType(schema)) != null) {
            return sup.getSubstringMatchingRule(schema);
        }
        return this.substringMatchingRule;
    }

    @Nullable
    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    @Nullable
    public String getSyntaxOID(@NotNull Schema schema) {
        AttributeTypeDefinition sup;
        if (this.syntaxOID == null && (sup = this.getSuperiorType(schema)) != null) {
            return sup.getSyntaxOID(schema);
        }
        return this.syntaxOID;
    }

    @Nullable
    public String getBaseSyntaxOID() {
        return AttributeTypeDefinition.getBaseSyntaxOID(this.syntaxOID);
    }

    @Nullable
    public String getBaseSyntaxOID(@NotNull Schema schema) {
        return AttributeTypeDefinition.getBaseSyntaxOID(this.getSyntaxOID(schema));
    }

    @Nullable
    public static String getBaseSyntaxOID(@Nullable String syntaxOID) {
        if (syntaxOID == null) {
            return null;
        }
        int curlyPos = syntaxOID.indexOf(123);
        if (curlyPos > 0) {
            return syntaxOID.substring(0, curlyPos);
        }
        return syntaxOID;
    }

    public int getSyntaxMinimumUpperBound() {
        return AttributeTypeDefinition.getSyntaxMinimumUpperBound(this.syntaxOID);
    }

    public int getSyntaxMinimumUpperBound(@NotNull Schema schema) {
        return AttributeTypeDefinition.getSyntaxMinimumUpperBound(this.getSyntaxOID(schema));
    }

    public static int getSyntaxMinimumUpperBound(@Nullable String syntaxOID) {
        if (syntaxOID == null) {
            return -1;
        }
        int curlyPos = syntaxOID.indexOf(123);
        if (curlyPos > 0 && syntaxOID.endsWith("}")) {
            try {
                return Integer.parseInt(syntaxOID.substring(curlyPos + 1, syntaxOID.length() - 1));
            }
            catch (Exception e) {
                Debug.debugException(e);
                return -1;
            }
        }
        return -1;
    }

    public boolean isSingleValued() {
        return this.isSingleValued;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        return this.isNoUserModification;
    }

    @NotNull
    public AttributeUsage getUsage() {
        return this.usage;
    }

    public boolean isOperational() {
        return this.usage.isOperational();
    }

    @NotNull
    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    @NotNull
    public SchemaElementType getSchemaElementType() {
        return SchemaElementType.ATTRIBUTE_TYPE;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeTypeDefinition)) {
            return false;
        }
        AttributeTypeDefinition d = (AttributeTypeDefinition)o;
        return this.oid.equals(d.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && StaticUtils.bothNullOrEqual((Object)this.usage, (Object)d.usage) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && StaticUtils.bothNullOrEqualIgnoreCase(this.equalityMatchingRule, d.equalityMatchingRule) && StaticUtils.bothNullOrEqualIgnoreCase(this.orderingMatchingRule, d.orderingMatchingRule) && StaticUtils.bothNullOrEqualIgnoreCase(this.substringMatchingRule, d.substringMatchingRule) && StaticUtils.bothNullOrEqualIgnoreCase(this.superiorType, d.superiorType) && StaticUtils.bothNullOrEqualIgnoreCase(this.syntaxOID, d.syntaxOID) && this.isCollective == d.isCollective && this.isNoUserModification == d.isNoUserModification && this.isObsolete == d.isObsolete && this.isSingleValued == d.isSingleValued && AttributeTypeDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    @NotNull
    public String toString() {
        return this.attributeTypeString;
    }
}

