/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.MinimalEmailBodyPart;
import org.apache.james.jmap.mail.MinimalEmailBodyPart$;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.jmap.routes.Applicable;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolutionResult;
import org.apache.james.jmap.routes.BlobResolver;
import org.apache.james.jmap.routes.EmailBodyPartBlob;
import org.apache.james.jmap.routes.NonApplicable$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u0006\r\u0001]A\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\ta\u0001\u0011\t\u0011)A\u0005I!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00034\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000bA\u0003A\u0011B)\t\u000bI\u0004A\u0011B:\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\t9R*Z:tC\u001e,\u0007+\u0019:u\u00052|'MU3t_24XM\u001d\u0006\u0003\u001b9\taA]8vi\u0016\u001c(BA\b\u0011\u0003\u0011QW.\u00199\u000b\u0005E\u0011\u0012!\u00026b[\u0016\u001c(BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010!\u001b\u0005a\u0011BA\u0011\r\u00051\u0011En\u001c2SKN|GN^3s\u0003AiWm]:bO\u0016LEMR1di>\u0014\u00180F\u0001%!\t)SF\u0004\u0002'W5\tqE\u0003\u0002)S\u0005)Qn\u001c3fY*\u0011!\u0006E\u0001\b[\u0006LGNY8y\u0013\tas%A\u0005NKN\u001c\u0018mZ3JI&\u0011af\f\u0002\b\r\u0006\u001cGo\u001c:z\u0015\tas%A\tnKN\u001c\u0018mZ3JI\u001a\u000b7\r^8ss\u0002\n\u0001#\\3tg\u0006<W-\u00133NC:\fw-\u001a:\u0016\u0003M\u0002\"\u0001N\u001b\u000e\u0003%J!AN\u0015\u0003!5+7o]1hK&#W*\u00198bO\u0016\u0014\u0018!E7fgN\fw-Z%e\u001b\u0006t\u0017mZ3sA\u0005q!p\u001c8f\u0013\u0012\u001cV\u000f\u001d9mS\u0016\u0014X#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0011AB7fi\"|G-\u0003\u0002@y\tq!l\u001c8f\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\u0018a\u0004>p]\u0016LEmU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u0005}\u0001\u0001\"\u0002\u0012\b\u0001\u0004!\u0003\"B\u0019\b\u0001\u0004\u0019\u0004\"\u0002\u001d\b\u0001\u0004Q\u0004FA\u0004I!\tIe*D\u0001K\u0015\tYE*\u0001\u0004j]*,7\r\u001e\u0006\u0002\u001b\u00069!.Y6beR\f\u0017BA(K\u0005\u0019IeN[3di\u0006\u0019\u0012m]'fgN\fw-Z!oIB\u000b'\u000f^%egR\u0011!\u000b\u001d\t\u0004'ZCV\"\u0001+\u000b\u0005US\u0012\u0001B;uS2L!a\u0016+\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u001a3ns\u0016B\u0001.\u001b\u0005\u0019!V\u000f\u001d7feA\u0011a\u0005X\u0005\u0003;\u001e\u0012\u0011\"T3tg\u0006<W-\u00133\u0011\u0007};'N\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111MF\u0001\u0007yI|w\u000e\u001e \n\u0003mI!A\u001a\u000e\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002g5A\u00111N\\\u0007\u0002Y*\u0011QND\u0001\u0005[\u0006LG.\u0003\u0002pY\n1!\t\\8c\u0013\u0012DQ!\u001d\u0005A\u0002)\faA\u00197pE&#\u0017\u0001\u00069beR\u001cHk\u001c'jgR|eM\u00117pE&#7\u000fF\u0002_izDQ!^\u0005A\u0002Y\fq\"\\3tg\u0006<W-\u00133TiJLgn\u001a\t\u0003ont!\u0001_=\u0011\u0005\u0005T\u0012B\u0001>\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iT\u0002BB@\n\u0001\u0004\t\t!A\u0003qCJ$8\u000fE\u0002`OZ\fqA]3t_24X\r\u0006\u0004\u0002\b\u0005\r\u0012Q\u0005\t\u0007\u0003\u0013\tI\"!\b\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007m\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001B2pe\u0016T!!a\u0006\u0002\u000fI,\u0017m\u0019;pe&!\u00111DA\u0006\u0005\u0015\u0019Vj\u001c8p!\ry\u0012qD\u0005\u0004\u0003Ca!\u0001\u0006\"m_\n\u0014Vm]8mkRLwN\u001c*fgVdG\u000fC\u0003r\u0015\u0001\u0007!\u000eC\u0004\u0002()\u0001\r!!\u000b\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B\u0019A'a\u000b\n\u0007\u00055\u0012F\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8")
public class MessagePartBlobResolver
implements BlobResolver {
    private final MessageId.Factory messageIdFactory;
    private final MessageIdManager messageIdManager;
    private final ZoneIdProvider zoneIdSupplier;

    public MessageId.Factory messageIdFactory() {
        return this.messageIdFactory;
    }

    public MessageIdManager messageIdManager() {
        return this.messageIdManager;
    }

    public ZoneIdProvider zoneIdSupplier() {
        return this.zoneIdSupplier;
    }

    private Try<Tuple2<MessageId, List<BlobId>>> asMessageAndPartIds(BlobId blobId) {
        List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(blobId.value()), '_')).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String messageIdString = (String)colon2.head();
            List tail = colon2.next$access$1();
            if (tail.nonEmpty()) {
                return Try$.MODULE$.apply((Function0 & Serializable)() -> this.messageIdFactory().fromString(messageIdString)).map((Function1 & Serializable)messageId -> new Tuple2(messageId, this.partsToListOfBlobIds(messageIdString, (List<String>)tail)));
            }
        }
        return new Failure((Throwable)new BlobNotFoundException(blobId));
    }

    private List<BlobId> partsToListOfBlobIds(String messageIdString, List<String> parts) {
        return ((List)parts.foldLeft((Object)new .colon.colon((Object)messageIdString, (List)Nil$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                List acc = (List)tuple2._1();
                String idPart = (String)tuple2._2();
                String string2 = (String)acc.headOption().map((Function1 & Serializable)prefix -> prefix + "_" + idPart).getOrElse((Function0 & Serializable)() -> idPart);
                return acc.$colon$colon((Object)string2);
            }
            throw new MatchError((Object)tuple2);
        })).flatMap((Function1 & Serializable)s -> BlobId$.MODULE$.of((String)s).toOption()).take(parts.size()).reverse();
    }

    public SMono<BlobResolutionResult> resolve(BlobId blobId, MailboxSession mailboxSession) {
        Success success;
        Tuple2 tuple2;
        Try<Tuple2<MessageId, List<BlobId>>> try_ = this.asMessageAndPartIds(blobId);
        if (try_ instanceof Failure) {
            return SMono$.MODULE$.just((Object)NonApplicable$.MODULE$);
        }
        if (try_ instanceof Success && (tuple2 = (Tuple2)(success = (Success)try_).value()) != null) {
            MessageId messageId = (MessageId)tuple2._1();
            List blobIds = (List)tuple2._2();
            return SMono$.MODULE$.fromPublisher(this.messageIdManager().getMessagesReactive((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)messageId, (List)Nil$.MODULE$)).asJava(), FetchGroup.FULL_CONTENT, mailboxSession)).handle((Function2 & Serializable)(x0$1, x1$1) -> {
                MessagePartBlobResolver.$anonfun$resolve$10(this, messageId, x0$1, x1$1);
                return BoxedUnit.UNIT;
            }).handle((Function2 & Serializable)(x0$2, x1$2) -> {
                MessagePartBlobResolver.$anonfun$resolve$13(this, blobIds, blobId, x0$2, x1$2);
                return BoxedUnit.UNIT;
            }).map((Function1 & Serializable)blob -> new Applicable((SMono<Blob>)SMono$.MODULE$.just((Object)new EmailBodyPartBlob(blobId, (MinimalEmailBodyPart)blob)))).switchIfEmpty(SMono$.MODULE$.just((Object)NonApplicable$.MODULE$));
        }
        throw new MatchError(try_);
    }

    public static final /* synthetic */ void $anonfun$resolve$10(MessagePartBlobResolver $this, MessageId messageId$1, MessageResult x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            MessageResult message = (MessageResult)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)MinimalEmailBodyPart$.MODULE$.ofMessage((Option<Properties>)None$.MODULE$, $this.zoneIdSupplier().get(), (BlobId)BlobId$.MODULE$.of(messageId$1).get(), message).fold((Function1 & Serializable)x$1 -> {
                sink.error(x$1);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$1 -> {
                sink.next((Object)x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$resolve$13(MessagePartBlobResolver $this, List blobIds$1, BlobId blobId$5, MinimalEmailBodyPart x0$2, SynchronousSink x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 != null) {
            MinimalEmailBodyPart bodyStructure = (MinimalEmailBodyPart)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Option)blobIds$1.foldLeft((Object)new Some((Object)bodyStructure), (Function2 & Serializable)(x0$3, x1$3) -> {
                Option option;
                Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
                if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._1())) {
                    return None$.MODULE$;
                }
                if (tuple2 != null) {
                    Option option2 = (Option)tuple2._1();
                    BlobId blobId = (BlobId)tuple2._2();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        MinimalEmailBodyPart nestedBodyStructure = (MinimalEmailBodyPart)some.value();
                        return nestedBodyStructure.partWithBlobId(blobId).orElse((Function0 & Serializable)() -> nestedBodyStructure.nested($this.zoneIdSupplier().get()).flatMap((Function1 & Serializable)x$1 -> x$1.partWithBlobId(blobId)));
                    }
                }
                throw new MatchError((Object)tuple2);
            })).fold((Function0)(JFunction0.mcV.sp & Serializable)() -> sink.error((Throwable)new BlobNotFoundException(blobId$5)), (Function1 & Serializable)part -> {
                sink.next((Object)part);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public MessagePartBlobResolver(MessageId.Factory messageIdFactory, MessageIdManager messageIdManager, ZoneIdProvider zoneIdSupplier) {
        this.messageIdFactory = messageIdFactory;
        this.messageIdManager = messageIdManager;
        this.zoneIdSupplier = zoneIdSupplier;
    }
}

