/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.aggregates;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossing;
import org.apache.james.mailbox.quota.mailing.events.QuotaThresholdChangedEvent;
import org.apache.james.mailbox.quota.model.HistoryEvolution;
import org.apache.james.mailbox.quota.model.QuotaThresholdChange;
import org.apache.james.mailbox.quota.model.QuotaThresholdHistory;
import org.apache.james.mailbox.quota.model.QuotaThresholds;

public class UserQuotaThresholds {
    private final Id aggregateId;
    private final History history;
    private final List<QuotaThresholdChangedEvent> events;

    public static UserQuotaThresholds fromEvents(Id aggregateId, History history) {
        return new UserQuotaThresholds(aggregateId, history);
    }

    private UserQuotaThresholds(Id aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.history = history;
        this.events = history.getEventsJava().stream().map(QuotaThresholdChangedEvent.class::cast).collect(Collectors.toList());
    }

    public List<EventWithState> detectThresholdCrossing(QuotaMailingListenerConfiguration configuration, DetectThresholdCrossing command) {
        List<QuotaThresholdChangedEvent> events = this.generateEvents(configuration.getThresholds(), configuration.getGracePeriod(), command.getCountQuota(), command.getSizeQuota(), command.getInstant());
        events.forEach(this::apply);
        return (List)events.stream().map(EventWithState::noState).collect(ImmutableList.toImmutableList());
    }

    private List<QuotaThresholdChangedEvent> generateEvents(QuotaThresholds configuration, Duration gracePeriod, Quota<QuotaCountLimit, QuotaCountUsage> countQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Instant now) {
        QuotaThresholdChange countThresholdChange = new QuotaThresholdChange(configuration.highestExceededThreshold(countQuota), now);
        QuotaThresholdChange sizeThresholdChange = new QuotaThresholdChange(configuration.highestExceededThreshold(sizeQuota), now);
        HistoryEvolution countHistoryEvolution = this.computeCountHistory().compareWithCurrentThreshold(countThresholdChange, gracePeriod);
        HistoryEvolution sizeHistoryEvolution = this.computeSizeHistory().compareWithCurrentThreshold(sizeThresholdChange, gracePeriod);
        return this.generateEvents(countHistoryEvolution, sizeHistoryEvolution, countQuota, sizeQuota);
    }

    private QuotaThresholdHistory computeSizeHistory() {
        return new QuotaThresholdHistory((List)this.events.stream().map(QuotaThresholdChangedEvent::getSizeHistoryEvolution).map(HistoryEvolution::getThresholdChange).flatMap(Optional::stream).collect(ImmutableList.toImmutableList()));
    }

    private QuotaThresholdHistory computeCountHistory() {
        return new QuotaThresholdHistory((List)this.events.stream().map(QuotaThresholdChangedEvent::getCountHistoryEvolution).map(HistoryEvolution::getThresholdChange).flatMap(Optional::stream).collect(ImmutableList.toImmutableList()));
    }

    private List<QuotaThresholdChangedEvent> generateEvents(HistoryEvolution countHistoryEvolution, HistoryEvolution sizeHistoryEvolution, Quota<QuotaCountLimit, QuotaCountUsage> countQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota) {
        if (countHistoryEvolution.isChange() || sizeHistoryEvolution.isChange()) {
            return ImmutableList.of((Object)new QuotaThresholdChangedEvent(this.history.getNextEventId(), sizeHistoryEvolution, countHistoryEvolution, sizeQuota, countQuota, this.aggregateId));
        }
        return ImmutableList.of();
    }

    private void apply(QuotaThresholdChangedEvent event) {
        this.events.add(event);
    }

    public static class Id
    implements AggregateId {
        private static final int PREFIX_INDEX = 0;
        private static final int NAME_INDEX = 1;
        private static final int USER_INDEX = 2;
        private static final String SEPARATOR = "/";
        private static final String PREFIX = "QuotaThreasholdEvents";
        private final Username username;
        private final String name;

        public static Id fromKey(String key) {
            List keyParts = Splitter.on((String)SEPARATOR).splitToList((CharSequence)key);
            if (keyParts.size() != 3 || !((String)keyParts.get(0)).equals(PREFIX)) {
                throw new IllegalArgumentException();
            }
            return new Id(Username.of((String)((String)keyParts.get(2))), (String)keyParts.get(1));
        }

        public static Id from(Username username, String name) {
            return new Id(username, name);
        }

        private Id(Username username, String name) {
            Preconditions.checkArgument((!username.asString().contains(SEPARATOR) ? 1 : 0) != 0);
            Preconditions.checkArgument((!name.contains(SEPARATOR) ? 1 : 0) != 0);
            this.username = username;
            this.name = name;
        }

        public Username getUsername() {
            return this.username;
        }

        public String asAggregateKey() {
            return Joiner.on((String)SEPARATOR).join((Object)PREFIX, (Object)this.name, new Object[]{this.username.asString()});
        }

        public final boolean equals(Object o) {
            if (o instanceof Id) {
                Id id = (Id)o;
                return Objects.equals(this.username, id.username) && Objects.equals(this.name, id.name);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.username, this.name);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.username).add("name", (Object)this.name).toString();
        }
    }
}

