/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.examples.AuthRate;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ValuePattern;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class AuthRateThread
extends Thread {
    private static final int AUTH_TYPE_SIMPLE = 0;
    private static final int AUTH_TYPE_CRAM_MD5 = 1;
    private static final int AUTH_TYPE_DIGEST_MD5 = 2;
    private static final int AUTH_TYPE_PLAIN = 3;
    @NotNull
    private final AtomicBoolean stopRequested;
    @NotNull
    private final AtomicInteger runningThreads;
    @NotNull
    private final AtomicLong authCounter;
    @NotNull
    private final AtomicLong authDurations;
    @NotNull
    private final AtomicLong errorCounter;
    @NotNull
    private final AtomicReference<ResultCode> resultCode;
    @NotNull
    private final AtomicReference<Thread> authThread;
    @NotNull
    private final AuthRate authRate;
    private final boolean bindOnly;
    @NotNull
    private final Control[] bindControls;
    @NotNull
    private final CyclicBarrier startBarrier;
    @Nullable
    private final FixedRateBarrier fixedRateBarrier;
    private final int authType;
    @Nullable
    private LDAPConnection bindConnection;
    @Nullable
    private LDAPConnection searchConnection;
    @NotNull
    private final ResultCodeCounter rcCounter;
    @Nullable
    private final SearchRequest searchRequest;
    @NotNull
    private final String userPassword;
    @NotNull
    private final ValuePattern baseDN;
    @Nullable
    private final ValuePattern filter;

    AuthRateThread(@NotNull AuthRate authRate, int threadNumber, @NotNull LDAPConnection searchConnection, @NotNull LDAPConnection bindConnection, @NotNull ValuePattern baseDN, @NotNull SearchScope scope, @Nullable ValuePattern filter, @NotNull String[] attributes, @NotNull String userPassword, boolean bindOnly, @NotNull String authType, @NotNull List<Control> searchControls, @NotNull List<Control> bindControls, @NotNull AtomicInteger runningThreads, @NotNull CyclicBarrier startBarrier, @NotNull AtomicLong authCounter, @NotNull AtomicLong authDurations, @NotNull AtomicLong errorCounter, @NotNull ResultCodeCounter rcCounter, @Nullable FixedRateBarrier rateBarrier) {
        this.setName("AuthRate Thread " + threadNumber);
        this.setDaemon(true);
        this.authRate = authRate;
        this.searchConnection = searchConnection;
        this.bindConnection = bindConnection;
        this.baseDN = baseDN;
        this.filter = filter;
        this.userPassword = userPassword;
        this.bindOnly = bindOnly;
        this.authCounter = authCounter;
        this.authDurations = authDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.runningThreads = runningThreads;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        searchConnection.setConnectionName("search-" + threadNumber);
        bindConnection.setConnectionName("bind-" + threadNumber);
        this.authType = authType.equalsIgnoreCase("cram-md5") ? 1 : (authType.equalsIgnoreCase("digest-md5") ? 2 : (authType.equalsIgnoreCase("plain") ? 3 : 0));
        this.resultCode = new AtomicReference<Object>(null);
        this.authThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        if (bindOnly) {
            this.searchRequest = null;
        } else {
            this.searchRequest = new SearchRequest("", scope, Filter.createPresenceFilter("objectClass"), attributes);
            this.searchRequest.setControls(searchControls);
        }
        this.bindControls = bindControls.isEmpty() ? StaticUtils.NO_CONTROLS : bindControls.toArray(new Control[bindControls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.authThread.set(AuthRateThread.currentThread());
            this.runningThreads.incrementAndGet();
            try {
                this.startBarrier.await();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            block28: while (!this.stopRequested.get()) {
                ResultCode rc;
                if (this.searchConnection == null) {
                    try {
                        this.searchConnection = this.authRate.getConnection();
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        if (this.fixedRateBarrier == null) continue;
                        this.fixedRateBarrier.await();
                        continue;
                    }
                }
                if (this.bindConnection == null) {
                    try {
                        this.bindConnection = this.authRate.getConnection();
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        if (this.fixedRateBarrier == null) continue;
                        this.fixedRateBarrier.await();
                        continue;
                    }
                }
                if (!this.bindOnly) {
                    try {
                        this.searchRequest.setBaseDN(this.baseDN.nextValue());
                        this.searchRequest.setFilter(this.filter.nextValue());
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        continue;
                    }
                }
                if (this.fixedRateBarrier != null) {
                    this.fixedRateBarrier.await();
                }
                long startTime = System.nanoTime();
                try {
                    String bindDN;
                    if (this.bindOnly) {
                        bindDN = this.baseDN.nextValue();
                    } else {
                        SearchResult r = this.searchConnection.search(this.searchRequest);
                        switch (r.getEntryCount()) {
                            case 0: {
                                this.errorCounter.incrementAndGet();
                                this.rcCounter.increment(ResultCode.NO_RESULTS_RETURNED);
                                this.resultCode.compareAndSet(null, ResultCode.NO_RESULTS_RETURNED);
                                continue block28;
                            }
                            case 1: {
                                bindDN = r.getSearchEntries().get(0).getDN();
                                break;
                            }
                            default: {
                                this.errorCounter.incrementAndGet();
                                this.rcCounter.increment(ResultCode.MORE_RESULTS_TO_RETURN);
                                this.resultCode.compareAndSet(null, ResultCode.MORE_RESULTS_TO_RETURN);
                                continue block28;
                            }
                        }
                    }
                    BindRequest bindRequest = null;
                    switch (this.authType) {
                        case 0: {
                            bindRequest = new SimpleBindRequest(bindDN, this.userPassword, this.bindControls);
                            break;
                        }
                        case 1: {
                            bindRequest = new CRAMMD5BindRequest("dn:" + bindDN, this.userPassword, this.bindControls);
                            break;
                        }
                        case 2: {
                            bindRequest = new DIGESTMD5BindRequest("dn:" + bindDN, null, this.userPassword, null, this.bindControls);
                            break;
                        }
                        case 3: {
                            bindRequest = new PLAINBindRequest("dn:" + bindDN, this.userPassword, this.bindControls);
                        }
                    }
                    this.bindConnection.bind(bindRequest);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.errorCounter.incrementAndGet();
                    ResultCode rc2 = le.getResultCode();
                    this.rcCounter.increment(rc2);
                    this.resultCode.compareAndSet(null, rc2);
                    if (le.getResultCode().isConnectionUsable()) continue;
                    this.searchConnection.close();
                    this.searchConnection = null;
                    this.bindConnection.close();
                    this.bindConnection = null;
                }
                finally {
                    this.authCounter.incrementAndGet();
                    this.authDurations.addAndGet(System.nanoTime() - startTime);
                }
            }
        }
        finally {
            if (this.searchConnection != null) {
                this.searchConnection.close();
            }
            if (this.bindConnection != null) {
                this.bindConnection.close();
            }
            this.authThread.set(null);
            this.runningThreads.decrementAndGet();
        }
    }

    @NotNull
    public ResultCode stopRunning() {
        block4: {
            Thread t;
            this.stopRequested.set(true);
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.shutdownRequested();
            }
            if ((t = this.authThread.get()) != null) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) break block4;
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

