/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import org.apache.mailet.PerRecipientHeaders;

public class HeadersDto {
    private final Multimap<String, String> headers;

    static HeadersDto from(Collection<PerRecipientHeaders.Header> headers) {
        return new HeadersDto((Multimap<String, String>)((Multimap)headers.stream().collect(ImmutableListMultimap.toImmutableListMultimap(PerRecipientHeaders.Header::getName, PerRecipientHeaders.Header::getValue))));
    }

    @JsonCreator
    private HeadersDto(@JsonProperty(value="header") Multimap<String, String> headers) {
        this.headers = headers;
    }

    @JsonProperty(value="header")
    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    Collection<PerRecipientHeaders.Header> toHeaders() {
        return (Collection)this.headers.entries().stream().map(entry -> PerRecipientHeaders.Header.builder().name((String)entry.getKey()).value((String)entry.getValue()).build()).collect(ImmutableList.toImmutableList());
    }

    public final boolean equals(Object o) {
        if (o instanceof HeadersDto) {
            HeadersDto that = (HeadersDto)o;
            return Objects.equals(this.headers, that.headers);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.headers);
    }
}

