/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.storage.MemoryStorageProvider;
import org.apache.james.mime4j.storage.MultiReferenceStorage;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageBinaryBody;
import org.apache.james.mime4j.storage.StorageTextBody;
import org.apache.james.mime4j.storage.StringTextBody;
import org.junit.Assert;
import org.junit.Test;

public class SingleBodyCopyTest {
    @Test
    public void testCopyStorageBinaryBody() throws Exception {
        Storage storage = new MemoryStorageProvider().store((InputStream)new ByteArrayInputStream("test".getBytes()));
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage(storage);
        StorageBinaryBody body = new StorageBinaryBody(multiReferenceStorage);
        this.copyTest((SingleBody)body);
    }

    @Test
    public void testCopyStorageTextBody() throws Exception {
        Storage storage = new MemoryStorageProvider().store((InputStream)new ByteArrayInputStream("test".getBytes()));
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage(storage);
        StorageTextBody body = new StorageTextBody(multiReferenceStorage, Charsets.US_ASCII);
        this.copyTest((SingleBody)body);
    }

    @Test
    public void testCopyStringTextBody() throws Exception {
        StringTextBody body = new StringTextBody("test", Charsets.US_ASCII);
        this.copyTest((SingleBody)body);
    }

    @Test
    public void testDisposeStorageBinaryBody() throws Exception {
        Storage storage = new MemoryStorageProvider().store((InputStream)new ByteArrayInputStream("test".getBytes()));
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage(storage);
        StorageBinaryBody body = new StorageBinaryBody(multiReferenceStorage);
        this.disposeTest((SingleBody)body, storage);
    }

    @Test
    public void testDisposeStorageTextBody() throws Exception {
        Storage storage = new MemoryStorageProvider().store((InputStream)new ByteArrayInputStream("test".getBytes()));
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage(storage);
        StorageTextBody body = new StorageTextBody(multiReferenceStorage, Charsets.US_ASCII);
        this.disposeTest((SingleBody)body, storage);
    }

    private void copyTest(SingleBody body) throws Exception {
        MessageImpl parent = new MessageImpl();
        parent.setBody((Body)body);
        SingleBody copy = body.copy();
        Assert.assertNotNull((Object)copy);
        Assert.assertNotSame((Object)body, (Object)copy);
        Assert.assertSame((Object)parent, (Object)body.getParent());
        Assert.assertNull((Object)copy.getParent());
        this.sameContentTest(body, copy);
    }

    private void sameContentTest(SingleBody expectedBody, SingleBody actualBody) throws Exception {
        ByteArrayOutputStream expBaos = new ByteArrayOutputStream();
        expectedBody.writeTo((OutputStream)expBaos);
        byte[] expected = expBaos.toByteArray();
        ByteArrayOutputStream actBaos = new ByteArrayOutputStream();
        actualBody.writeTo((OutputStream)actBaos);
        byte[] actual = actBaos.toByteArray();
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)actual[i]);
        }
    }

    private void disposeTest(SingleBody body, Storage storage) throws Exception {
        Assert.assertTrue((boolean)this.storageIsReadable(storage));
        SingleBody copy = body.copy();
        Assert.assertTrue((boolean)this.storageIsReadable(storage));
        body.dispose();
        Assert.assertTrue((boolean)this.storageIsReadable(storage));
        copy.dispose();
        Assert.assertFalse((boolean)this.storageIsReadable(storage));
    }

    private boolean storageIsReadable(Storage storage) throws Exception {
        try {
            storage.getInputStream().close();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

