/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.util;

import java.util.Arrays;
import org.apache.iotdb.udf.api.exception.UDFException;

public class LinearRegression {
    double[] x;
    double[] y;
    double[] e;
    double[] yhead;
    int n;
    double sumx;
    double sumy;
    double xbar;
    double ybar;
    double xxbar;
    double yybar;
    double xybar;
    double beta1;
    double beta0;
    double rss;
    double ssr;
    double r2;
    double svar;
    double svar1;
    double svar0;

    public LinearRegression(double[] a, double[] b) throws UDFException {
        this.x = (double[])a.clone();
        this.y = (double[])b.clone();
        this.n = this.x.length;
        if (this.x.length == 0 || this.y.length == 0) {
            throw new UDFException("Empty input array(s).");
        }
        if (this.x.length != this.y.length) {
            throw new UDFException("Different input array length.");
        }
        if (this.x.length == 1) {
            throw new UDFException("Input series should be longer than 1.");
        }
        this.e = new double[this.n];
        this.yhead = new double[this.n];
        this.sumx = Arrays.stream(this.x).sum();
        this.sumy = Arrays.stream(this.y).sum();
        this.xbar = this.sumx / (double)this.n;
        this.ybar = this.sumy / (double)this.n;
        this.xxbar = 0.0;
        this.yybar = 0.0;
        this.xybar = 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.xxbar += (this.x[i] - this.xbar) * (this.x[i] - this.xbar);
            this.yybar += (this.y[i] - this.ybar) * (this.y[i] - this.ybar);
            this.xybar += (this.x[i] - this.xbar) * (this.y[i] - this.ybar);
        }
        if (this.xxbar == 0.0) {
            throw new UDFException("All input x are same.");
        }
        this.beta1 = this.xybar / this.xxbar;
        this.beta0 = this.ybar - this.beta1 * this.xbar;
        int df = this.n - 2;
        this.rss = 0.0;
        this.ssr = 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.yhead[i] = this.beta1 * this.x[i] + this.beta0;
            this.e[i] = this.yhead[i] - this.y[i];
            this.rss += (this.yhead[i] - this.y[i]) * (this.yhead[i] - this.y[i]);
            this.ssr += (this.yhead[i] - this.ybar) * (this.yhead[i] - this.ybar);
        }
        this.r2 = this.ssr / this.yybar;
        this.svar = this.rss / (double)df;
        this.svar1 = this.svar / this.xxbar;
        this.svar0 = this.svar / (double)this.n + this.xbar * this.xbar * this.svar1;
    }

    public double getMSE() {
        return this.rss / (double)this.n;
    }

    public double getMAbsE() {
        double sumAbsE = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sumAbsE += Math.abs(this.e[i]);
        }
        return sumAbsE / (double)this.n;
    }

    public double[] getYhead() {
        return this.yhead;
    }
}

