/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window.ainode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BottomInferenceWindowParameter
extends InferenceWindowParameter {
    long windowSize;

    public BottomInferenceWindowParameter(long windowSize) {
        this.windowSize = windowSize;
        this.windowType = InferenceWindowType.TAIL;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void serializeAttributes(ByteBuffer buffer) {
        ReadWriteIOUtils.write((long)this.windowSize, (ByteBuffer)buffer);
    }

    @Override
    public void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.windowSize, (OutputStream)stream);
    }

    public static BottomInferenceWindowParameter deserialize(ByteBuffer byteBuffer) {
        long windowSize = byteBuffer.getLong();
        return new BottomInferenceWindowParameter(windowSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BottomInferenceWindowParameter)) {
            return false;
        }
        BottomInferenceWindowParameter parameter = (BottomInferenceWindowParameter)obj;
        return this.windowSize == parameter.windowSize;
    }

    public int hashCode() {
        return Long.hashCode(this.windowSize);
    }
}

