/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.legacy;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.legacy.TsFilePipeData;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.thrift.TException;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBLegacyPipeConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBLegacyPipeConnector.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private String ipAddress;
    private int port;
    private boolean useSSL;
    private String trustStore;
    private String trustStorePwd;
    private String user;
    private String password;
    private String syncConnectorVersion;
    private String pipeName;
    private IoTDBSyncClient client;
    private SessionPool sessionPool;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        IoTDBConfig ioTDBConfig = IoTDBDescriptor.getInstance().getConfig();
        Set<TEndPoint> givenNodeUrls = this.parseNodeUrls(validator.getParameters());
        validator.validate(args -> (Boolean)args[0] != false && (Boolean)args[1] != false || (Boolean)args[2] != false && (Boolean)args[3] != false, String.format("Either %s:%s or %s:%s must be specified", "connector.ip", "connector.port", "sink.ip", "sink.port"), new Object[]{parameters.hasAttribute("connector.ip"), parameters.hasAttribute("connector.port"), parameters.hasAttribute("sink.ip"), parameters.hasAttribute("sink.port")}).validate(empty -> {
            try {
                return !NodeUrlUtils.containsLocalAddress(givenNodeUrls.stream().filter(tEndPoint -> tEndPoint.getPort() == ioTDBConfig.getRpcPort()).map(TEndPoint::getIp).collect(Collectors.toList()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Unknown host when checking pipe sink IP.", (Throwable)e);
                return false;
            }
        }, String.format("One of the endpoints %s of the receivers is pointing back to the legacy receiver %s on sender itself, or unknown host when checking pipe sink IP.", givenNodeUrls, new TEndPoint(ioTDBConfig.getRpcAddress(), ioTDBConfig.getRpcPort())), new Object[0]).validate(args -> (Boolean)args[0] == false || (Boolean)args[1] != false && (Boolean)args[2] != false, String.format("When %s is specified to true, %s and %s must be specified", "sink.ssl.enable", "sink.ssl.trust-store-path", "sink.ssl.trust-store-pwd"), new Object[]{parameters.getBooleanOrDefault("sink.ssl.enable", false), parameters.hasAttribute("sink.ssl.trust-store-path"), parameters.hasAttribute("sink.ssl.trust-store-pwd")});
    }

    private Set<TEndPoint> parseNodeUrls(PipeParameters parameters) {
        HashSet<TEndPoint> givenNodeUrls = new HashSet<TEndPoint>();
        if (parameters.hasAttribute("connector.ip") && parameters.hasAttribute("connector.port")) {
            givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"connector.ip"}), parameters.getIntByKeys(new String[]{"connector.port"}).intValue()));
        }
        if (parameters.hasAttribute("sink.ip") && parameters.hasAttribute("sink.port")) {
            givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"sink.ip"}), parameters.getIntByKeys(new String[]{"sink.port"}).intValue()));
        }
        return givenNodeUrls;
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.ipAddress = parameters.getStringByKeys(new String[]{"connector.ip", "sink.ip"});
        this.port = parameters.getIntByKeys(new String[]{"connector.port", "sink.port"});
        this.user = parameters.getStringOrDefault(Arrays.asList("connector.user", "sink.user", "connector.username", "sink.username"), "root");
        this.password = parameters.getStringOrDefault(Arrays.asList("connector.password", "sink.password"), "root");
        this.syncConnectorVersion = parameters.getStringOrDefault(Arrays.asList("connector.version", "sink.version"), "1.1");
        this.pipeName = configuration.getRuntimeEnvironment().getPipeName();
        this.useSSL = parameters.getBooleanOrDefault("sink.ssl.enable", false);
        this.trustStore = parameters.getString("sink.ssl.trust-store-path");
        this.trustStorePwd = parameters.getString("sink.ssl.trust-store-pwd");
    }

    public void handshake() throws Exception {
        this.close();
        try {
            this.client = new IoTDBSyncClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs(COMMON_CONFIG.getDnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(COMMON_CONFIG.isRpcThriftCompressionEnabled()).build(), this.ipAddress, this.port, this.useSSL, this.trustStore, this.trustStorePwd);
            TSyncIdentityInfo identityInfo = new TSyncIdentityInfo(this.pipeName, System.currentTimeMillis(), this.syncConnectorVersion, "root");
            TSStatus status = this.client.handshake(identityInfo);
            if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                String errorMsg = String.format("The receiver %s:%s rejected the pipe task because %s", this.ipAddress, this.port, status.message);
                LOGGER.warn(errorMsg);
                throw new PipeRuntimeCriticalException(errorMsg);
            }
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Error occurred while connecting to receiver %s:%s, please check network connectivity or SSL configurations when enable SSL transmission", this.ipAddress, this.port), (Throwable)e);
        }
        this.sessionPool = new SessionPool.Builder().host(this.ipAddress).port(this.port).user(this.user).password(this.password).maxSize(1).useSSL(this.useSSL).trustStore(this.trustStore).trustStorePwd(this.trustStorePwd).build();
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            this.doTransferWrapper((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
        } else if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            this.doTransferWrapper((PipeRawTabletInsertionEvent)tabletInsertionEvent);
        } else {
            throw new NotImplementedException("IoTDBLegacyPipeConnector only support PipeInsertNodeInsertionEvent and PipeTabletInsertionEvent.");
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            throw new NotImplementedException("IoTDBLegacyPipeConnector only support PipeTsFileInsertionEvent.");
        }
        if (!((PipeTsFileInsertionEvent)tsFileInsertionEvent).waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)((PipeTsFileInsertionEvent)tsFileInsertionEvent).getTsFile());
            return;
        }
        try {
            this.doTransferWrapper((PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Network error when transfer tsFile insertion event: %s.", ((PipeTsFileInsertionEvent)tsFileInsertionEvent).coreReportMessage()), (Throwable)e);
        }
    }

    public void transfer(Event event) throws Exception {
        if (!(event instanceof PipeHeartbeatEvent) && !(event instanceof PipeTerminateEvent)) {
            LOGGER.warn("IoTDBLegacyPipeConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransferWrapper(PipeInsertNodeTabletInsertionEvent pipeInsertNodeInsertionEvent) throws IoTDBConnectionException, StatementExecutionException {
        if (!pipeInsertNodeInsertionEvent.increaseReferenceCount(IoTDBLegacyPipeConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeInsertNodeInsertionEvent);
        }
        finally {
            pipeInsertNodeInsertionEvent.decreaseReferenceCount(IoTDBLegacyPipeConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeInsertionEvent) throws IoTDBConnectionException, StatementExecutionException {
        List<Tablet> tablets = pipeInsertNodeInsertionEvent.convertToTablets();
        for (int i = 0; i < tablets.size(); ++i) {
            Tablet tablet = tablets.get(i);
            if (Objects.isNull(tablet) || tablet.rowSize == 0) continue;
            if (pipeInsertNodeInsertionEvent.isAligned(i)) {
                this.sessionPool.insertAlignedTablet(tablet);
                continue;
            }
            this.sessionPool.insertTablet(tablet);
        }
    }

    private void doTransferWrapper(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException, IoTDBConnectionException, StatementExecutionException {
        if (!pipeRawTabletInsertionEvent.increaseReferenceCount(IoTDBLegacyPipeConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeRawTabletInsertionEvent);
        }
        finally {
            pipeRawTabletInsertionEvent.decreaseReferenceCount(IoTDBLegacyPipeConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeRawTabletInsertionEvent pipeTabletInsertionEvent) throws PipeException, IoTDBConnectionException, StatementExecutionException {
        Tablet tablet = pipeTabletInsertionEvent.convertToTablet();
        if (pipeTabletInsertionEvent.isAligned()) {
            this.sessionPool.insertAlignedTablet(tablet);
        } else {
            this.sessionPool.insertTablet(tablet);
        }
    }

    private void doTransferWrapper(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, TException, IOException {
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(IoTDBLegacyPipeConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeTsFileInsertionEvent);
        }
        finally {
            pipeTsFileInsertionEvent.decreaseReferenceCount(IoTDBLegacyPipeConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, TException, IOException {
        File tsFile = pipeTsFileInsertionEvent.getTsFile();
        this.transportSingleFilePieceByPiece(tsFile);
        this.client.sendPipeData(ByteBuffer.wrap(new TsFilePipeData("", tsFile.getName(), -1L).serialize()));
    }

    private void transportSingleFilePieceByPiece(File file) throws IOException {
        block11: {
            long position = 0L;
            byte[] buffer = new byte[PipeConfig.getInstance().getPipeConnectorReadFileBufferSize()];
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
                TSStatus status;
                while (true) {
                    int dataLength;
                    if ((dataLength = randomAccessFile.read(buffer)) == -1) {
                        break block11;
                    }
                    ByteBuffer buffToSend = ByteBuffer.wrap(buffer, 0, dataLength);
                    TSyncTransportMetaInfo metaInfo = new TSyncTransportMetaInfo(file.getName(), position);
                    status = this.client.sendFile(metaInfo, buffToSend);
                    if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        position += (long)dataLength;
                        continue;
                    }
                    if (status.code == TSStatusCode.SYNC_FILE_REDIRECTION_ERROR.getStatusCode()) {
                        position = Long.parseLong(status.message);
                        randomAccessFile.seek(position);
                        LOGGER.info("Redirect to position {} in transferring tsFile {}.", (Object)position, (Object)file);
                        continue;
                    }
                    if (status.code == TSStatusCode.SYNC_FILE_ERROR.getStatusCode()) break;
                }
                String errorMsg = String.format("Network failed to receive tsFile %s, status: %s", file, status);
                LOGGER.warn(errorMsg);
                throw new PipeConnectionException(errorMsg);
            }
            catch (TException e) {
                throw new PipeConnectionException(String.format("Cannot send pipe data to receiver %s:%s, because: %s.", this.ipAddress, this.port, e.getMessage()), (Throwable)e);
            }
        }
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.sessionPool != null) {
            this.sessionPool.close();
            this.sessionPool = null;
        }
    }
}

