/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.ainode.ModelException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.exception.TsFileRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlingUtils.class);
    private static final String INFO_PARSING_SQL_ERROR = "Error occurred while parsing SQL to physical plan: ";
    private static final String INFO_QUERY_PROCESS_ERROR = "Error occurred in read process: ";
    private static final String INFO_NOT_ALLOWED_IN_BATCH_ERROR = "The read statement is not allowed in batch: ";
    private static final String ERROR_OPERATION_LOG = "Status code: {}, operation: {} failed";

    private ErrorHandlingUtils() {
    }

    public static TSStatus onNpeOrUnexpectedException(Exception e, String operation, TSStatusCode statusCode) {
        String message = String.format("[%s] Exception occurred: %s failed. ", statusCode, operation);
        if (e instanceof IOException || e instanceof NullPointerException) {
            LOGGER.error(ERROR_OPERATION_LOG, new Object[]{statusCode, operation, e});
        } else {
            LOGGER.warn(ERROR_OPERATION_LOG, new Object[]{statusCode, operation, e});
        }
        if (e instanceof SemanticException) {
            Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
            if (e.getCause() instanceof IoTDBException) {
                return RpcUtils.getStatus((int)((IoTDBException)e.getCause()).getErrorCode(), (String)rootCause.getMessage());
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SEMANTIC_ERROR, (String)rootCause.getMessage());
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)statusCode, (String)(message + e.getMessage()));
        status.setNeedRetry(StatusUtils.needRetry((TSStatus)status));
        return status;
    }

    public static TSStatus onNpeOrUnexpectedException(Exception e, OperationType operation, TSStatusCode statusCode) {
        return ErrorHandlingUtils.onNpeOrUnexpectedException(e, operation.getName(), statusCode);
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static TSStatus onQueryException(Exception e, String operation, TSStatusCode statusCode) {
        TSStatus status = ErrorHandlingUtils.tryCatchQueryException(e);
        if (status != null) {
            if (status.getCode() != TSStatusCode.STORAGE_ENGINE_NOT_READY.getStatusCode()) {
                String message = String.format("Status code: %s, Query Statement: %s failed because %s", status.getCode(), operation, status.getMessage());
                if (status.getCode() == TSStatusCode.SQL_PARSE_ERROR.getStatusCode() || status.getCode() == TSStatusCode.SEMANTIC_ERROR.getStatusCode() || status.getCode() == TSStatusCode.NO_PERMISSION.getStatusCode() || status.getCode() == TSStatusCode.ILLEGAL_PATH.getStatusCode()) {
                    LOGGER.warn(message);
                } else {
                    LOGGER.warn(message, (Throwable)e);
                }
            }
            status.setNeedRetry(StatusUtils.needRetry((TSStatus)status));
            return status;
        }
        return ErrorHandlingUtils.onNpeOrUnexpectedException(e, operation, statusCode);
    }

    public static TSStatus onQueryException(Exception e, String operation) {
        return ErrorHandlingUtils.onQueryException(e, operation, TSStatusCode.INTERNAL_SERVER_ERROR);
    }

    public static TSStatus onQueryException(Exception e, OperationType operation) {
        return ErrorHandlingUtils.onQueryException(e, operation.getName());
    }

    private static TSStatus tryCatchQueryException(Exception e) {
        Throwable t;
        Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
        if (rootCause instanceof StorageGroupNotReadyException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.STORAGE_ENGINE_NOT_READY, (String)rootCause.getMessage());
        }
        Throwable throwable = t = e instanceof ExecutionException ? e.getCause() : e;
        if (t instanceof QueryTimeoutRuntimeException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_REQUEST_TIME_OUT, (String)rootCause.getMessage());
        }
        if (t instanceof ParseCancellationException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)(INFO_PARSING_SQL_ERROR + rootCause.getMessage()));
        }
        if (t instanceof QueryProcessException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)(INFO_QUERY_PROCESS_ERROR + rootCause.getMessage()));
        }
        if (t instanceof QueryInBatchStatementException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)(INFO_NOT_ALLOWED_IN_BATCH_ERROR + rootCause.getMessage()));
        }
        if (t instanceof IoTDBException) {
            return RpcUtils.getStatus((int)((IoTDBException)t).getErrorCode(), (String)rootCause.getMessage());
        }
        if (t instanceof TsFileRuntimeException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TSFILE_PROCESSOR_ERROR, (String)rootCause.getMessage());
        }
        if (t instanceof SemanticException) {
            if (t.getCause() instanceof IoTDBException) {
                return RpcUtils.getStatus((int)((IoTDBException)t.getCause()).getErrorCode(), (String)rootCause.getMessage());
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SEMANTIC_ERROR, (String)rootCause.getMessage());
        }
        if (t instanceof IoTDBRuntimeException) {
            return RpcUtils.getStatus((int)((IoTDBRuntimeException)t).getErrorCode(), (String)t.getMessage());
        }
        if (t instanceof ModelException) {
            return RpcUtils.getStatus((TSStatusCode)((ModelException)t).getStatusCode(), (String)rootCause.getMessage());
        }
        if (t instanceof MemoryNotEnoughException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUOTA_MEM_QUERY_NOT_ENOUGH, (String)rootCause.getMessage());
        }
        if (t instanceof RuntimeException && rootCause instanceof IoTDBException) {
            return RpcUtils.getStatus((int)((IoTDBException)rootCause).getErrorCode(), (String)rootCause.getMessage());
        }
        return null;
    }

    public static TSStatus onNonQueryException(Exception e, String operation) {
        TSStatus status = ErrorHandlingUtils.tryCatchNonQueryException(e);
        if (status != null) {
            status.setNeedRetry(StatusUtils.needRetry((TSStatus)status));
            return status;
        }
        return ErrorHandlingUtils.onNpeOrUnexpectedException(e, operation, TSStatusCode.INTERNAL_SERVER_ERROR);
    }

    public static TSStatus onNonQueryException(Exception e, OperationType operation) {
        return ErrorHandlingUtils.onNonQueryException(e, operation.getName());
    }

    private static TSStatus tryCatchNonQueryException(Exception e) {
        String message = "Exception occurred while processing non-read. ";
        if (e instanceof BatchProcessException) {
            BatchProcessException batchException = (BatchProcessException)e;
            for (TSStatus status : batchException.getFailingStatus()) {
                if (status.getCode() != TSStatusCode.STORAGE_ENGINE_NOT_READY.getStatusCode()) continue;
                return RpcUtils.getStatus(Arrays.asList(batchException.getFailingStatus()));
            }
            LOGGER.warn(message, (Throwable)e);
            return RpcUtils.getStatus(Arrays.asList(batchException.getFailingStatus()));
        }
        if (e instanceof IoTDBException) {
            Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
            if (!(rootCause instanceof StorageGroupNotReadyException)) {
                LOGGER.warn(message, (Throwable)e);
            }
            return RpcUtils.getStatus((int)((IoTDBException)e).getErrorCode(), (String)rootCause.getMessage());
        }
        return null;
    }

    public static TSStatus onIoTDBException(Exception e, String operation, int errorCode) {
        TSStatusCode statusCode = TSStatusCode.representOf((int)errorCode);
        String message = String.format("[%s] Exception occurred: %s failed. %s", statusCode, operation, e.getMessage());
        LOGGER.warn(ERROR_OPERATION_LOG, new Object[]{statusCode, operation, e});
        TSStatus status = RpcUtils.getStatus((int)errorCode, (String)message);
        status.setNeedRetry(StatusUtils.needRetry((TSStatus)status));
        return status;
    }

    public static TSStatus onIoTDBException(Exception e, OperationType operation, int errorCode) {
        return ErrorHandlingUtils.onIoTDBException(e, operation.getName(), errorCode);
    }
}

