/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedSeriesBatchCompactionUtils {
    private AlignedSeriesBatchCompactionUtils() {
    }

    public static void markAlignedChunkHasDeletion(LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList) {
        for (Pair pair : readerAndChunkMetadataList) {
            List alignedChunkMetadataList = (List)pair.getRight();
            AlignedSeriesBatchCompactionUtils.markAlignedChunkHasDeletion(alignedChunkMetadataList);
        }
    }

    public static void markAlignedChunkHasDeletion(List<AlignedChunkMetadata> alignedChunkMetadataList) {
        block0: for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
            IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
            for (IChunkMetadata iChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                if (iChunkMetadata == null || !iChunkMetadata.isModified()) continue;
                timeChunkMetadata.setModified(true);
                continue block0;
            }
        }
    }

    public static boolean isTimeChunk(ChunkMetadata chunkMetadata) {
        return chunkMetadata.getMeasurementUid().isEmpty();
    }

    public static AlignedChunkMetadata filterAlignedChunkMetadataByIndex(AlignedChunkMetadata alignedChunkMetadata, List<Integer> selectedMeasurements) {
        IChunkMetadata[] valueChunkMetadataArr = new IChunkMetadata[selectedMeasurements.size()];
        List originValueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        for (int i = 0; i < selectedMeasurements.size(); ++i) {
            int columnIndex = selectedMeasurements.get(i);
            valueChunkMetadataArr[i] = (IChunkMetadata)originValueChunkMetadataList.get(columnIndex);
        }
        return new AlignedChunkMetadata(alignedChunkMetadata.getTimeChunkMetadata(), Arrays.asList(valueChunkMetadataArr));
    }

    public static AlignedChunkMetadata fillAlignedChunkMetadataBySchemaList(AlignedChunkMetadata originAlignedChunkMetadata, List<IMeasurementSchema> schemaList) {
        List originValueChunkMetadataList = originAlignedChunkMetadata.getValueChunkMetadataList();
        IChunkMetadata[] newValueChunkMetadataArr = new IChunkMetadata[schemaList.size()];
        int currentValueChunkMetadataIndex = 0;
        for (int i = 0; i < schemaList.size(); ++i) {
            IMeasurementSchema currentSchema = schemaList.get(i);
            while (currentValueChunkMetadataIndex < originValueChunkMetadataList.size() && originValueChunkMetadataList.get(currentValueChunkMetadataIndex) == null) {
                ++currentValueChunkMetadataIndex;
            }
            if (currentValueChunkMetadataIndex >= originValueChunkMetadataList.size()) break;
            IChunkMetadata currentValueChunkMetadata = (IChunkMetadata)originValueChunkMetadataList.get(currentValueChunkMetadataIndex);
            if (currentValueChunkMetadata == null || !currentSchema.getMeasurementId().equals(currentValueChunkMetadata.getMeasurementUid())) continue;
            newValueChunkMetadataArr[i] = currentValueChunkMetadata;
            ++currentValueChunkMetadataIndex;
        }
        return new AlignedChunkMetadata(originAlignedChunkMetadata.getTimeChunkMetadata(), Arrays.asList(newValueChunkMetadataArr));
    }

    public static ModifiedStatus calculateAlignedPageModifiedStatus(long startTime, long endTime, AlignedChunkMetadata originAlignedChunkMetadata) {
        ModifiedStatus lastPageStatus = null;
        for (IChunkMetadata valueChunkMetadata : originAlignedChunkMetadata.getValueChunkMetadataList()) {
            ModifiedStatus currentPageStatus;
            ModifiedStatus modifiedStatus = currentPageStatus = valueChunkMetadata == null ? ModifiedStatus.ALL_DELETED : AlignedSeriesBatchCompactionUtils.checkIsModified(startTime, endTime, valueChunkMetadata.getDeleteIntervalList());
            if (currentPageStatus == ModifiedStatus.PARTIAL_DELETED) {
                return ModifiedStatus.PARTIAL_DELETED;
            }
            if (lastPageStatus == null) {
                lastPageStatus = currentPageStatus;
                continue;
            }
            if (lastPageStatus.equals((Object)currentPageStatus)) continue;
            lastPageStatus = ModifiedStatus.NONE_DELETED;
        }
        return lastPageStatus;
    }

    public static ModifiedStatus checkIsModified(long startTime, long endTime, Collection<TimeRange> deletions) {
        ModifiedStatus status = ModifiedStatus.NONE_DELETED;
        if (deletions != null) {
            for (TimeRange range : deletions) {
                if (range.contains(startTime, endTime)) {
                    return ModifiedStatus.ALL_DELETED;
                }
                if (!range.overlaps(new TimeRange(startTime, endTime))) continue;
                status = ModifiedStatus.PARTIAL_DELETED;
            }
        }
        return status;
    }

    public static class BatchColumnSelection {
        private final List<IMeasurementSchema> schemaList;
        private final Queue<Integer> normalTypeSortedColumnIndexList;
        private final Queue<Integer> binaryTypeSortedColumnIndexList;
        private final int batchSize;
        private int selectedColumnNum;
        private List<Integer> columnIndexList;
        private List<IMeasurementSchema> currentSelectedColumnSchemaList;

        public BatchColumnSelection(List<IMeasurementSchema> valueSchemas, int batchSize) {
            this.schemaList = valueSchemas;
            this.normalTypeSortedColumnIndexList = new ArrayDeque<Integer>(valueSchemas.size());
            this.binaryTypeSortedColumnIndexList = new ArrayDeque<Integer>();
            for (int i = 0; i < valueSchemas.size(); ++i) {
                IMeasurementSchema schema = valueSchemas.get(i);
                if (schema.getType().isBinary()) {
                    this.binaryTypeSortedColumnIndexList.add(i);
                    continue;
                }
                this.normalTypeSortedColumnIndexList.add(i);
            }
            this.batchSize = batchSize;
            this.selectedColumnNum = 0;
        }

        public boolean hasNext() {
            return this.selectedColumnNum < this.schemaList.size();
        }

        public void next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.selectColumnBatchToCompact();
        }

        public List<Integer> getSelectedColumnIndexList() {
            return this.columnIndexList;
        }

        public List<IMeasurementSchema> getCurrentSelectedColumnSchemaList() {
            return this.currentSelectedColumnSchemaList;
        }

        private void selectColumnBatchToCompact() {
            this.columnIndexList = new ArrayList<Integer>(this.batchSize);
            this.currentSelectedColumnSchemaList = new ArrayList<IMeasurementSchema>(this.batchSize);
            while (!this.normalTypeSortedColumnIndexList.isEmpty() || !this.binaryTypeSortedColumnIndexList.isEmpty()) {
                Queue<Integer> sourceTypeSortedList = this.binaryTypeSortedColumnIndexList.isEmpty() ? this.normalTypeSortedColumnIndexList : this.binaryTypeSortedColumnIndexList;
                Integer columnIndex = sourceTypeSortedList.poll();
                this.columnIndexList.add(columnIndex);
                this.currentSelectedColumnSchemaList.add(this.schemaList.get(columnIndex));
                ++this.selectedColumnNum;
                if (this.columnIndexList.size() < this.batchSize) continue;
                break;
            }
        }
    }
}

