/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryData;
import org.eclipse.milo.opcua.stack.core.types.structured.ModificationInfo;

public class HistoryModifiedData
extends HistoryData
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11217");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11227");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11219");
    private final ModificationInfo[] modificationInfos;

    public HistoryModifiedData(DataValue[] dataValues, ModificationInfo[] modificationInfos) {
        super(dataValues);
        this.modificationInfos = modificationInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ModificationInfo[] getModificationInfos() {
        return this.modificationInfos;
    }

    protected HistoryModifiedData(HistoryModifiedDataBuilder<?, ?> b) {
        super((HistoryData.HistoryDataBuilder<?, ?>)b);
        this.modificationInfos = ((HistoryModifiedDataBuilder)b).modificationInfos;
    }

    public static HistoryModifiedDataBuilder<?, ?> builder() {
        return new HistoryModifiedDataBuilderImpl();
    }

    public HistoryModifiedDataBuilder<?, ?> toBuilder() {
        return new HistoryModifiedDataBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryModifiedData)) {
            return false;
        }
        HistoryModifiedData other = (HistoryModifiedData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getModificationInfos(), other.getModificationInfos());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HistoryModifiedData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getModificationInfos());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryModifiedData(modificationInfos=" + Arrays.deepToString(this.getModificationInfos()) + ")";
    }

    private static final class HistoryModifiedDataBuilderImpl
    extends HistoryModifiedDataBuilder<HistoryModifiedData, HistoryModifiedDataBuilderImpl> {
        private HistoryModifiedDataBuilderImpl() {
        }

        @Override
        protected HistoryModifiedDataBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryModifiedData build() {
            return new HistoryModifiedData(this);
        }
    }

    public static abstract class HistoryModifiedDataBuilder<C extends HistoryModifiedData, B extends HistoryModifiedDataBuilder<C, B>>
    extends HistoryData.HistoryDataBuilder<C, B> {
        private ModificationInfo[] modificationInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryModifiedDataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryModifiedData instance, HistoryModifiedDataBuilder<?, ?> b) {
            b.modificationInfos(instance.modificationInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B modificationInfos(ModificationInfo[] modificationInfos) {
            this.modificationInfos = modificationInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryModifiedData.HistoryModifiedDataBuilder(super=" + super.toString() + ", modificationInfos=" + Arrays.deepToString(this.modificationInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryModifiedData> {
        @Override
        public Class<HistoryModifiedData> getType() {
            return HistoryModifiedData.class;
        }

        @Override
        public HistoryModifiedData decode(SerializationContext context, UaDecoder decoder) {
            DataValue[] dataValues = decoder.readDataValueArray("DataValues");
            ModificationInfo[] modificationInfos = (ModificationInfo[])decoder.readStructArray("ModificationInfos", ModificationInfo.TYPE_ID);
            return new HistoryModifiedData(dataValues, modificationInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryModifiedData value) {
            encoder.writeDataValueArray("DataValues", value.getDataValues());
            encoder.writeStructArray("ModificationInfos", (Object[])value.getModificationInfos(), ModificationInfo.TYPE_ID);
        }
    }
}

