/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.AbstractLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.GreedyLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.MinCostFlowLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.GreedyPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.IPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.LeaderPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.subscriber.ConsensusGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.NodeStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.RegionGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeResp;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBalancer
implements IClusterStatusSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteBalancer.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getSchemaRegionConsensusProtocolClass();
    private static final String DATA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getDataRegionConsensusProtocolClass();
    private static final boolean IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION = CONF.isEnableAutoLeaderBalanceForRatisConsensus() && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensusV2".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS) || "org.apache.iotdb.consensus.simple.SimpleConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private static final boolean IS_ENABLE_AUTO_LEADER_BALANCE_FOR_SCHEMA_REGION = CONF.isEnableAutoLeaderBalanceForRatisConsensus() && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS) || "org.apache.iotdb.consensus.simple.SimpleConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private static final long REGION_PRIORITY_WAITING_TIMEOUT = Math.max(ProcedureManager.PROCEDURE_WAIT_TIME_OUT - TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(10L));
    private static final long WAIT_PRIORITY_INTERVAL = 10L;
    private final IManager configManager;
    private final AbstractLeaderBalancer leaderBalancer;
    private final IPriorityBalancer priorityRouter;
    private final ReentrantReadWriteLock priorityMapLock;
    private final Map<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap;
    private static final long BALANCE_RATIS_LEADER_FAILED_INTERVAL_IN_NS = 20000000000L;
    private final Map<TConsensusGroupId, Long> lastFailedTimeForLeaderBalance;
    private final Map<Integer, List<String>> lastBalancedOldLeaderId2RegionMap;
    private Map<TConsensusGroupId, Integer> lastDataRegion2OldLeaderMap;
    private Set<TConsensusGroupId> lastBalancedDataRegionSet;

    public RouteBalancer(IManager configManager) {
        this.configManager = configManager;
        this.priorityMapLock = new ReentrantReadWriteLock();
        this.regionPriorityMap = new TreeMap<TConsensusGroupId, TRegionReplicaSet>();
        this.lastFailedTimeForLeaderBalance = new TreeMap<TConsensusGroupId, Long>();
        this.lastBalancedOldLeaderId2RegionMap = new ConcurrentHashMap<Integer, List<String>>();
        switch (CONF.getLeaderDistributionPolicy()) {
            case "GREEDY": {
                this.leaderBalancer = new GreedyLeaderBalancer();
                break;
            }
            default: {
                this.leaderBalancer = new MinCostFlowLeaderBalancer();
            }
        }
        switch (CONF.getRoutePriorityPolicy()) {
            case "GREEDY": {
                this.priorityRouter = new GreedyPriorityBalancer();
                break;
            }
            default: {
                this.priorityRouter = new LeaderPriorityBalancer();
            }
        }
    }

    private synchronized void balanceRegionLeader() {
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_SCHEMA_REGION) {
            this.balanceRegionLeader(TConsensusGroupType.SchemaRegion, SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS);
        }
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION) {
            this.balanceRegionLeader(TConsensusGroupType.DataRegion, DATA_REGION_CONSENSUS_PROTOCOL_CLASS);
        }
    }

    private void balanceRegionLeader(TConsensusGroupType regionGroupType, String consensusProtocolClass) {
        Map<TConsensusGroupId, Integer> currentLeaderMap = this.getLoadManager().getLoadCache().getRegionLeaderMap(regionGroupType);
        Map<TConsensusGroupId, Integer> optimalLeaderMap = this.leaderBalancer.generateOptimalLeaderDistribution(this.getLoadManager().getLoadCache().getCurrentDatabaseRegionGroupMap(regionGroupType), this.getLoadManager().getLoadCache().getCurrentRegionLocationMap(regionGroupType), currentLeaderMap, this.getLoadManager().getLoadCache().getCurrentDataNodeStatisticsMap(), this.getLoadManager().getLoadCache().getCurrentRegionStatisticsMap(regionGroupType));
        long currentTime = System.nanoTime();
        AtomicInteger requestId = new AtomicInteger(0);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.CHANGE_REGION_LEADER);
        TreeMap<TConsensusGroupId, ConsensusGroupHeartbeatSample> successTransferMap = new TreeMap<TConsensusGroupId, ConsensusGroupHeartbeatSample>();
        optimalLeaderMap.forEach((regionGroupId, newLeaderId) -> {
            if ("org.apache.iotdb.consensus.ratis.RatisConsensus".equals(consensusProtocolClass) && currentTime - this.lastFailedTimeForLeaderBalance.getOrDefault(regionGroupId, 0L) <= 20000000000L) {
                return;
            }
            int oldLeaderId = (Integer)currentLeaderMap.get(regionGroupId);
            if (newLeaderId != -1 && !newLeaderId.equals(oldLeaderId)) {
                LOGGER.info("[LeaderBalancer] Try to change the leader of Region: {} to DataNode: {} ", regionGroupId, newLeaderId);
                switch (consensusProtocolClass) {
                    case "org.apache.iotdb.consensus.iot.IoTConsensus": 
                    case "org.apache.iotdb.consensus.simple.SimpleConsensus": {
                        successTransferMap.put((TConsensusGroupId)regionGroupId, new ConsensusGroupHeartbeatSample(currentTime, (int)newLeaderId));
                        break;
                    }
                    case "org.apache.iotdb.consensus.iot.IoTConsensusV2": {
                        successTransferMap.put((TConsensusGroupId)regionGroupId, new ConsensusGroupHeartbeatSample(currentTime, (int)newLeaderId));
                        if (oldLeaderId == -1) break;
                        this.lastBalancedOldLeaderId2RegionMap.compute(oldLeaderId, (k, v) -> {
                            if (v == null) {
                                ArrayList<String> value = new ArrayList<String>();
                                value.add(String.valueOf(regionGroupId.getId()));
                                return value;
                            }
                            v.add(String.valueOf(regionGroupId.getId()));
                            return v;
                        });
                        break;
                    }
                    default: {
                        if (TConsensusGroupType.SchemaRegion.equals((Object)regionGroupType) && CONF.getSchemaReplicationFactor() == 1) {
                            successTransferMap.put((TConsensusGroupId)regionGroupId, new ConsensusGroupHeartbeatSample(0L, (int)newLeaderId));
                            break;
                        }
                        if (TConsensusGroupType.DataRegion.equals((Object)regionGroupType) && CONF.getDataReplicationFactor() == 1) {
                            successTransferMap.put((TConsensusGroupId)regionGroupId, new ConsensusGroupHeartbeatSample(0L, (int)newLeaderId));
                            break;
                        }
                        TDataNodeLocation newLeader = this.getNodeManager().getRegisteredDataNode((int)newLeaderId).getLocation();
                        TRegionLeaderChangeReq regionLeaderChangeReq = new TRegionLeaderChangeReq(regionGroupId, newLeader);
                        int requestIndex = requestId.getAndIncrement();
                        clientHandler.putRequest(requestIndex, regionLeaderChangeReq);
                        clientHandler.putNodeLocation(requestIndex, newLeader);
                    }
                }
            }
        });
        if (requestId.get() > 0) {
            CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequest(clientHandler);
            for (int i = 0; i < requestId.get(); ++i) {
                if (((TRegionLeaderChangeResp)clientHandler.getResponseMap().get(i)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    successTransferMap.put(((TRegionLeaderChangeReq)clientHandler.getRequest(i)).getRegionId(), new ConsensusGroupHeartbeatSample(((TRegionLeaderChangeResp)clientHandler.getResponseMap().get(i)).getConsensusLogicalTimestamp(), ((TRegionLeaderChangeReq)clientHandler.getRequest(i)).getNewLeaderNode().getDataNodeId()));
                    continue;
                }
                this.lastFailedTimeForLeaderBalance.put(((TRegionLeaderChangeReq)clientHandler.getRequest(i)).getRegionId(), currentTime);
                LOGGER.error("[LeaderBalancer] Failed to change the leader of Region: {} to DataNode: {}", (Object)((TRegionLeaderChangeReq)clientHandler.getRequest(i)).getRegionId(), (Object)((TRegionLeaderChangeReq)clientHandler.getRequest(i)).getNewLeaderNode().getDataNodeId());
            }
        }
        this.getLoadManager().forceUpdateConsensusGroupCache(successTransferMap);
        if (regionGroupType.equals((Object)TConsensusGroupType.DataRegion)) {
            this.lastBalancedDataRegionSet = successTransferMap.keySet();
            this.lastDataRegion2OldLeaderMap = currentLeaderMap;
        }
    }

    private void invalidateSchemaCacheOfOldLeaders() {
        BiConsumer<Map, Set> consumer = (oldLeaderMap, successTransferSet) -> {
            DataNodeAsyncRequestContext invalidateSchemaCacheRequestHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_LAST_CACHE);
            AtomicInteger requestIndex = new AtomicInteger(0);
            oldLeaderMap.entrySet().stream().filter(entry -> successTransferSet.contains(entry.getKey())).forEach(entry -> {
                Integer dataNodeId = (Integer)entry.getValue();
                if (dataNodeId == -1) {
                    return;
                }
                TDataNodeLocation dataNodeLocation = this.getNodeManager().getRegisteredDataNode(dataNodeId).getLocation();
                if (dataNodeLocation == null) {
                    LOGGER.warn("DataNodeLocation is null, datanodeId {}", (Object)dataNodeId);
                    return;
                }
                invalidateSchemaCacheRequestHandler.putNodeLocation(requestIndex.get(), dataNodeLocation);
                TConsensusGroupId consensusGroupId = (TConsensusGroupId)entry.getKey();
                String database = this.getPartitionManager().getRegionDatabase(consensusGroupId);
                invalidateSchemaCacheRequestHandler.putRequest(requestIndex.get(), database);
                requestIndex.incrementAndGet();
            });
            CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequest(invalidateSchemaCacheRequestHandler);
        };
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION) {
            consumer.accept(this.lastDataRegion2OldLeaderMap, this.lastBalancedDataRegionSet);
        }
    }

    private void flushOldLeaderIfIoTV2() {
        if (!IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION || !Objects.equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS, "org.apache.iotdb.consensus.iot.IoTConsensusV2")) {
            return;
        }
        BiConsumer<Integer, List> consumer = (oldLeaderId, regionGroupIds) -> {
            TDataNodeConfiguration configuration = this.getNodeManager().getRegisteredDataNode((int)oldLeaderId);
            HashMap<Integer, TDataNodeLocation> oldLeaderDataNodeLocation = new HashMap<Integer, TDataNodeLocation>();
            oldLeaderDataNodeLocation.put(configuration.getLocation().dataNodeId, configuration.getLocation());
            TFlushReq flushReq = new TFlushReq();
            flushReq.setRegionIds(regionGroupIds);
            TSStatus result = this.configManager.flushOnSpecificDN(flushReq, oldLeaderDataNodeLocation);
            if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("[IoTConsensusV2 Leader Changed] Successfully flush old leader {} for region {}", oldLeaderId, regionGroupIds);
            } else {
                LOGGER.info("[IoTConsensusV2 Leader Changed] Failed to flush old leader {} for region {}", oldLeaderId, regionGroupIds);
            }
        };
        this.lastBalancedOldLeaderId2RegionMap.forEach(consumer);
        this.lastBalancedOldLeaderId2RegionMap.clear();
    }

    private synchronized void handleBalanceAction() {
        this.invalidateSchemaCacheOfOldLeaders();
        this.flushOldLeaderIfIoTV2();
    }

    public synchronized void balanceRegionLeaderAndPriority() {
        this.balanceRegionLeader();
        this.balanceRegionPriority();
        this.handleBalanceAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void balanceRegionPriority() {
        this.priorityMapLock.writeLock().lock();
        AtomicBoolean needBroadcast = new AtomicBoolean(false);
        TreeMap<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> differentPriorityMap = new TreeMap<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>>();
        try {
            Map<TConsensusGroupId, Integer> regionLeaderMap = this.getLoadManager().getRegionLeaderMap();
            Map<TConsensusGroupId, TRegionReplicaSet> optimalRegionPriorityMap = this.priorityRouter.generateOptimalRoutePriority(this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.SchemaRegion), regionLeaderMap);
            optimalRegionPriorityMap.putAll(this.priorityRouter.generateOptimalRoutePriority(this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.DataRegion), regionLeaderMap));
            optimalRegionPriorityMap.forEach((regionGroupId, optimalRegionPriority) -> {
                TRegionReplicaSet currentRegionPriority = this.regionPriorityMap.get(regionGroupId);
                if (!optimalRegionPriority.equals(currentRegionPriority)) {
                    differentPriorityMap.put((TConsensusGroupId)regionGroupId, (Pair<TRegionReplicaSet, TRegionReplicaSet>)new Pair((Object)currentRegionPriority, optimalRegionPriority));
                    this.regionPriorityMap.put((TConsensusGroupId)regionGroupId, (TRegionReplicaSet)optimalRegionPriority);
                    needBroadcast.set(true);
                }
            });
        }
        finally {
            this.priorityMapLock.writeLock().unlock();
        }
        if (needBroadcast.get()) {
            this.recordRegionPriorityMap(differentPriorityMap);
            this.broadcastLatestRegionPriorityMap();
        }
    }

    private void broadcastLatestRegionPriorityMap() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toMap(TDataNodeLocation::getDataNodeId, location -> location));
        long broadcastTime = System.currentTimeMillis();
        Map<TConsensusGroupId, TRegionReplicaSet> tmpPriorityMap = this.getRegionPriorityMap();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_REGION_ROUTE_MAP, new TRegionRouteReq(broadcastTime, tmpPriorityMap), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
    }

    private void recordRegionPriorityMap(Map<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> differentPriorityMap) {
        LOGGER.info("[RegionPriority] RegionPriorityMap: ");
        for (Map.Entry<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> regionPriorityEntry : differentPriorityMap.entrySet()) {
            if (Objects.equals(regionPriorityEntry.getValue().getRight(), regionPriorityEntry.getValue().getLeft())) continue;
            LOGGER.info("[RegionPriority]\t {}: {}->{}", new Object[]{regionPriorityEntry.getKey(), regionPriorityEntry.getValue().getLeft() == null ? "null" : ((TRegionReplicaSet)regionPriorityEntry.getValue().getLeft()).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()), ((TRegionReplicaSet)regionPriorityEntry.getValue().getRight()).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList())});
        }
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRegionPriorityMap() {
        this.priorityMapLock.readLock().lock();
        try {
            TreeMap<TConsensusGroupId, TRegionReplicaSet> treeMap = new TreeMap<TConsensusGroupId, TRegionReplicaSet>(this.regionPriorityMap);
            return treeMap;
        }
        finally {
            this.priorityMapLock.readLock().unlock();
        }
    }

    public void removeRegionPriority(TConsensusGroupId regionGroupId) {
        this.priorityMapLock.writeLock().lock();
        try {
            this.regionPriorityMap.remove(regionGroupId);
        }
        finally {
            this.priorityMapLock.writeLock().unlock();
        }
    }

    public void clearRegionPriority() {
        this.priorityMapLock.writeLock().lock();
        try {
            this.regionPriorityMap.clear();
        }
        finally {
            this.priorityMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPriorityUpdate(List<TConsensusGroupId> regionGroupIds) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("[RegionPriority] Wait for Region priority update of RegionGroups: {}", regionGroupIds);
        while (System.currentTimeMillis() - startTime <= REGION_PRIORITY_WAITING_TIMEOUT) {
            AtomicBoolean allRegionPriorityCalculated = new AtomicBoolean(true);
            this.priorityMapLock.readLock().lock();
            try {
                regionGroupIds.forEach(regionGroupId -> {
                    if (!this.regionPriorityMap.containsKey(regionGroupId)) {
                        allRegionPriorityCalculated.set(false);
                    }
                });
            }
            finally {
                this.priorityMapLock.readLock().unlock();
            }
            if (allRegionPriorityCalculated.get()) {
                LOGGER.info("[RegionPriority] The routing priority of RegionGroups: {} is calculated.", regionGroupIds);
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupt when wait for calculating Region priority", (Throwable)e);
                return;
            }
        }
        LOGGER.warn("[RegionPriority] The routing priority of RegionGroups: {} is not determined after 10 heartbeat interval. Some function might fail.", regionGroupIds);
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    @Override
    public void onNodeStatisticsChanged(NodeStatisticsChangeEvent event) {
        this.balanceRegionLeader();
    }

    @Override
    public void onRegionGroupStatisticsChanged(RegionGroupStatisticsChangeEvent event) {
        this.balanceRegionLeader();
    }

    @Override
    public void onConsensusGroupStatisticsChanged(ConsensusGroupStatisticsChangeEvent event) {
        this.balanceRegionLeader();
        this.balanceRegionPriority();
        this.handleBalanceAction();
    }
}

