/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class FindServersOnNetworkRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12190");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12208");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12196");
    private final RequestHeader requestHeader;
    private final UInteger startingRecordId;
    private final UInteger maxRecordsToReturn;
    private final String[] serverCapabilityFilter;

    public FindServersOnNetworkRequest(RequestHeader requestHeader, UInteger startingRecordId, UInteger maxRecordsToReturn, String[] serverCapabilityFilter) {
        this.requestHeader = requestHeader;
        this.startingRecordId = startingRecordId;
        this.maxRecordsToReturn = maxRecordsToReturn;
        this.serverCapabilityFilter = serverCapabilityFilter;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getStartingRecordId() {
        return this.startingRecordId;
    }

    public UInteger getMaxRecordsToReturn() {
        return this.maxRecordsToReturn;
    }

    public String[] getServerCapabilityFilter() {
        return this.serverCapabilityFilter;
    }

    protected FindServersOnNetworkRequest(FindServersOnNetworkRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((FindServersOnNetworkRequestBuilder)b).requestHeader;
        this.startingRecordId = ((FindServersOnNetworkRequestBuilder)b).startingRecordId;
        this.maxRecordsToReturn = ((FindServersOnNetworkRequestBuilder)b).maxRecordsToReturn;
        this.serverCapabilityFilter = ((FindServersOnNetworkRequestBuilder)b).serverCapabilityFilter;
    }

    public static FindServersOnNetworkRequestBuilder<?, ?> builder() {
        return new FindServersOnNetworkRequestBuilderImpl();
    }

    public FindServersOnNetworkRequestBuilder<?, ?> toBuilder() {
        return new FindServersOnNetworkRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServersOnNetworkRequest)) {
            return false;
        }
        FindServersOnNetworkRequest other = (FindServersOnNetworkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$startingRecordId = this.getStartingRecordId();
        UInteger other$startingRecordId = other.getStartingRecordId();
        if (this$startingRecordId == null ? other$startingRecordId != null : !((Object)this$startingRecordId).equals(other$startingRecordId)) {
            return false;
        }
        UInteger this$maxRecordsToReturn = this.getMaxRecordsToReturn();
        UInteger other$maxRecordsToReturn = other.getMaxRecordsToReturn();
        if (this$maxRecordsToReturn == null ? other$maxRecordsToReturn != null : !((Object)this$maxRecordsToReturn).equals(other$maxRecordsToReturn)) {
            return false;
        }
        return Arrays.deepEquals(this.getServerCapabilityFilter(), other.getServerCapabilityFilter());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindServersOnNetworkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $startingRecordId = this.getStartingRecordId();
        result = result * 59 + ($startingRecordId == null ? 43 : ((Object)$startingRecordId).hashCode());
        UInteger $maxRecordsToReturn = this.getMaxRecordsToReturn();
        result = result * 59 + ($maxRecordsToReturn == null ? 43 : ((Object)$maxRecordsToReturn).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServerCapabilityFilter());
        return result;
    }

    @Override
    public String toString() {
        return "FindServersOnNetworkRequest(requestHeader=" + this.getRequestHeader() + ", startingRecordId=" + this.getStartingRecordId() + ", maxRecordsToReturn=" + this.getMaxRecordsToReturn() + ", serverCapabilityFilter=" + Arrays.deepToString(this.getServerCapabilityFilter()) + ")";
    }

    private static final class FindServersOnNetworkRequestBuilderImpl
    extends FindServersOnNetworkRequestBuilder<FindServersOnNetworkRequest, FindServersOnNetworkRequestBuilderImpl> {
        private FindServersOnNetworkRequestBuilderImpl() {
        }

        @Override
        protected FindServersOnNetworkRequestBuilderImpl self() {
            return this;
        }

        @Override
        public FindServersOnNetworkRequest build() {
            return new FindServersOnNetworkRequest(this);
        }
    }

    public static abstract class FindServersOnNetworkRequestBuilder<C extends FindServersOnNetworkRequest, B extends FindServersOnNetworkRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger startingRecordId;
        private UInteger maxRecordsToReturn;
        private String[] serverCapabilityFilter;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FindServersOnNetworkRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FindServersOnNetworkRequest instance, FindServersOnNetworkRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.startingRecordId(instance.startingRecordId);
            b.maxRecordsToReturn(instance.maxRecordsToReturn);
            b.serverCapabilityFilter(instance.serverCapabilityFilter);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B startingRecordId(UInteger startingRecordId) {
            this.startingRecordId = startingRecordId;
            return (B)this.self();
        }

        public B maxRecordsToReturn(UInteger maxRecordsToReturn) {
            this.maxRecordsToReturn = maxRecordsToReturn;
            return (B)this.self();
        }

        public B serverCapabilityFilter(String[] serverCapabilityFilter) {
            this.serverCapabilityFilter = serverCapabilityFilter;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FindServersOnNetworkRequest.FindServersOnNetworkRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", startingRecordId=" + this.startingRecordId + ", maxRecordsToReturn=" + this.maxRecordsToReturn + ", serverCapabilityFilter=" + Arrays.deepToString(this.serverCapabilityFilter) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<FindServersOnNetworkRequest> {
        @Override
        public Class<FindServersOnNetworkRequest> getType() {
            return FindServersOnNetworkRequest.class;
        }

        @Override
        public FindServersOnNetworkRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger startingRecordId = decoder.readUInt32("StartingRecordId");
            UInteger maxRecordsToReturn = decoder.readUInt32("MaxRecordsToReturn");
            String[] serverCapabilityFilter = decoder.readStringArray("ServerCapabilityFilter");
            return new FindServersOnNetworkRequest(requestHeader, startingRecordId, maxRecordsToReturn, serverCapabilityFilter);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, FindServersOnNetworkRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("StartingRecordId", value.getStartingRecordId());
            encoder.writeUInt32("MaxRecordsToReturn", value.getMaxRecordsToReturn());
            encoder.writeStringArray("ServerCapabilityFilter", value.getServerCapabilityFilter());
        }
    }
}

