/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.connector.base.source.hybrid.HybridSourceEnumeratorState;
import org.apache.flink.connector.base.source.hybrid.HybridSourceEnumeratorStateSerializer;
import org.apache.flink.connector.base.source.hybrid.HybridSourceReader;
import org.apache.flink.connector.base.source.hybrid.HybridSourceSplit;
import org.apache.flink.connector.base.source.hybrid.HybridSourceSplitEnumerator;
import org.apache.flink.connector.base.source.hybrid.HybridSourceSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class HybridSource<T>
implements Source<T, HybridSourceSplit, HybridSourceEnumeratorState> {
    private final List<SourceListEntry> sources;

    protected HybridSource(List<SourceListEntry> sources) {
        Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0);
        this.sources = sources;
    }

    public static <T, EnumT extends SplitEnumerator> HybridSourceBuilder<T, EnumT> builder(Source<T, ?, ?> firstSource) {
        HybridSourceBuilder builder = new HybridSourceBuilder();
        return builder.addSource(firstSource);
    }

    public Boundedness getBoundedness() {
        return this.sources.get((int)(this.sources.size() - 1)).boundedness;
    }

    public SourceReader<T, HybridSourceSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return new HybridSourceReader(readerContext);
    }

    public SplitEnumerator<HybridSourceSplit, HybridSourceEnumeratorState> createEnumerator(SplitEnumeratorContext<HybridSourceSplit> enumContext) {
        return new HybridSourceSplitEnumerator(enumContext, this.sources, 0, null);
    }

    public SplitEnumerator<HybridSourceSplit, HybridSourceEnumeratorState> restoreEnumerator(SplitEnumeratorContext<HybridSourceSplit> enumContext, HybridSourceEnumeratorState checkpoint) throws Exception {
        return new HybridSourceSplitEnumerator(enumContext, this.sources, checkpoint.getCurrentSourceIndex(), checkpoint);
    }

    public SimpleVersionedSerializer<HybridSourceSplit> getSplitSerializer() {
        return new HybridSourceSplitSerializer();
    }

    public SimpleVersionedSerializer<HybridSourceEnumeratorState> getEnumeratorCheckpointSerializer() {
        return new HybridSourceEnumeratorStateSerializer();
    }

    public static class HybridSourceBuilder<T, EnumT extends SplitEnumerator>
    implements Serializable {
        private final List<SourceListEntry> sources = new ArrayList<SourceListEntry>();

        public <ToEnumT extends SplitEnumerator, NextSourceT extends Source<T, ?, ?>> HybridSourceBuilder<T, ToEnumT> addSource(NextSourceT source) {
            return this.addSource(new PassthroughSourceFactory(source, null), source.getBoundedness());
        }

        public <ToEnumT extends SplitEnumerator, NextSourceT extends Source<T, ?, ?>> HybridSourceBuilder<T, ToEnumT> addSource(SourceFactory<T, NextSourceT, ? super EnumT> sourceFactory, Boundedness boundedness) {
            if (!this.sources.isEmpty()) {
                Preconditions.checkArgument((boolean)Boundedness.BOUNDED.equals((Object)this.sources.get((int)(this.sources.size() - 1)).boundedness), (Object)"All sources except the final source need to be bounded.");
            }
            ClosureCleaner.clean(sourceFactory, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
            this.sources.add(SourceListEntry.of(sourceFactory, boundedness));
            return this;
        }

        public HybridSource<T> build() {
            return new HybridSource(this.sources);
        }
    }

    static class SourceListEntry
    implements Serializable {
        protected final SourceFactory factory;
        protected final Boundedness boundedness;

        private SourceListEntry(SourceFactory factory, Boundedness boundedness) {
            this.factory = (SourceFactory)Preconditions.checkNotNull((Object)factory);
            this.boundedness = (Boundedness)Preconditions.checkNotNull((Object)boundedness);
        }

        static SourceListEntry of(SourceFactory configurer, Boundedness boundedness) {
            return new SourceListEntry(configurer, boundedness);
        }
    }

    private static class PassthroughSourceFactory<T, SourceT extends Source<T, ?, ?>, FromEnumT extends SplitEnumerator>
    implements SourceFactory<T, SourceT, FromEnumT> {
        private final SourceT source;

        private PassthroughSourceFactory(SourceT source) {
            this.source = source;
        }

        @Override
        public SourceT create(SourceSwitchContext<FromEnumT> context) {
            return this.source;
        }

        /* synthetic */ PassthroughSourceFactory(Source x0, 1 x1) {
            this(x0);
        }
    }

    @FunctionalInterface
    public static interface SourceFactory<T, SourceT extends Source<T, ?, ?>, FromEnumT extends SplitEnumerator>
    extends Serializable {
        public SourceT create(SourceSwitchContext<FromEnumT> var1);
    }

    public static interface SourceSwitchContext<EnumT> {
        public EnumT getPreviousEnumerator();
    }
}

