/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.definition;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.Preconditions;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="class")
public abstract class Element
implements Cloneable {
    private String name;
    private String displayName;

    public void validate() {
        Preconditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)this.name), (String)"process name cannot be empty");
        Preconditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)this.displayName), (String)"process display name cannot be empty");
    }

    public Element clone() throws CloneNotSupportedException {
        return (Element)super.clone();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        Element other = (Element)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Element;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String toString() {
        return "Element(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ")";
    }
}

