/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.util.Preconditions;

class DeclarativeTaskManagerSlot
implements TaskManagerSlotInformation {
    private final SlotID slotId;
    private final ResourceProfile resourceProfile;
    private final TaskExecutorConnection taskManagerConnection;
    @Nullable
    private JobID jobId;
    private SlotState state = SlotState.FREE;
    private long allocationStartTimeStamp;

    public DeclarativeTaskManagerSlot(SlotID slotId, ResourceProfile resourceProfile, TaskExecutorConnection taskManagerConnection) {
        this.slotId = slotId;
        this.resourceProfile = resourceProfile;
        this.taskManagerConnection = taskManagerConnection;
    }

    @Override
    public SlotState getState() {
        return this.state;
    }

    @Override
    public SlotID getSlotId() {
        return this.slotId;
    }

    @Override
    public AllocationID getAllocationId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Override
    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskManagerConnection;
    }

    @Override
    @Nullable
    public JobID getJobId() {
        return this.jobId;
    }

    @Override
    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    public long getAllocationStartTimestamp() {
        return this.allocationStartTimeStamp;
    }

    public void startAllocation(JobID jobId) {
        Preconditions.checkState((this.state == SlotState.FREE ? 1 : 0) != 0, (Object)"Slot must be free to be assigned a slot request.");
        this.jobId = jobId;
        this.state = SlotState.PENDING;
        this.allocationStartTimeStamp = System.currentTimeMillis();
    }

    public void completeAllocation() {
        Preconditions.checkState((this.state == SlotState.PENDING ? 1 : 0) != 0, (Object)"In order to complete an allocation, the slot has to be allocated.");
        this.state = SlotState.ALLOCATED;
    }

    public void freeSlot() {
        Preconditions.checkState((this.state == SlotState.PENDING || this.state == SlotState.ALLOCATED ? 1 : 0) != 0, (Object)"Slot must be allocated or pending before freeing it.");
        this.jobId = null;
        this.state = SlotState.FREE;
        this.allocationStartTimeStamp = 0L;
    }

    public String toString() {
        return "DeclarativeTaskManagerSlot{slotId=" + this.slotId + ", resourceProfile=" + this.resourceProfile + ", taskManagerConnection=" + this.taskManagerConnection + ", jobId=" + this.jobId + ", state=" + (Object)((Object)this.state) + ", allocationStartTimeStamp=" + this.allocationStartTimeStamp + '}';
    }
}

