/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc.impl;

import javax.sql.DataSource;
import org.apache.flume.channel.jdbc.DatabaseType;
import org.apache.flume.channel.jdbc.JdbcChannelException;
import org.apache.flume.channel.jdbc.impl.DerbySchemaHandler;
import org.apache.flume.channel.jdbc.impl.MySQLSchemaHandler;
import org.apache.flume.channel.jdbc.impl.SchemaHandler;

public final class SchemaHandlerFactory {
    public static SchemaHandler getHandler(DatabaseType dbType, DataSource dataSource) {
        SchemaHandler handler = null;
        switch (dbType) {
            case DERBY: {
                handler = new DerbySchemaHandler(dataSource);
                break;
            }
            case MYSQL: {
                handler = new MySQLSchemaHandler(dataSource);
                break;
            }
            default: {
                throw new JdbcChannelException("Database " + (Object)((Object)dbType) + " not supported yet");
            }
        }
        return handler;
    }

    private SchemaHandlerFactory() {
    }
}

