/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.channel;

import java.util.Set;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.channel.ChannelSelectorType;

public class ChannelSelectorConfiguration
extends ComponentConfiguration {
    protected Set<String> channelNames;

    protected ChannelSelectorConfiguration(String componentName) {
        super(componentName);
        this.setType(ChannelSelectorType.REPLICATING.toString());
        this.channelNames = null;
    }

    public Set<String> getChannels() {
        return this.channelNames;
    }

    public void setChannels(Set<String> channelNames) {
        this.channelNames = channelNames;
    }

    public static enum ChannelSelectorConfigurationType {
        OTHER(null),
        REPLICATING(null),
        MULTIPLEXING("org.apache.flume.conf.channel.MultiplexingChannelSelectorConfiguration");

        private String selectorType;

        private ChannelSelectorConfigurationType(String type) {
            this.selectorType = type;
        }

        public String getChannelSelectorConfigurationType() {
            return this.selectorType;
        }

        public ChannelSelectorConfiguration getConfiguration(String name) throws ConfigurationException {
            if (this == OTHER) {
                return new ChannelSelectorConfiguration(name);
            }
            ChannelSelectorConfiguration instance = null;
            try {
                if (this.selectorType == null) {
                    return new ChannelSelectorConfiguration(name);
                }
                Class<?> clazz = Class.forName(this.selectorType);
                instance = (ChannelSelectorConfiguration)clazz.getConstructor(String.class).newInstance(name);
            }
            catch (ClassNotFoundException e) {
                instance = new ChannelSelectorConfiguration(name);
                instance.setNotFoundConfigClass();
            }
            catch (Exception e) {
                throw new ConfigurationException("Configuration error!", e);
            }
            return instance;
        }
    }
}

