/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.FunctionCommand;
import com.moilioncircle.redis.replicator.cmd.impl.FunctionDeleteCommand;
import com.moilioncircle.redis.replicator.cmd.impl.FunctionFlushCommand;
import com.moilioncircle.redis.replicator.cmd.impl.FunctionLoadCommand;
import com.moilioncircle.redis.replicator.cmd.impl.FunctionRestoreCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class FunctionParser
implements CommandParser<FunctionCommand> {
    @Override
    public FunctionCommand parse(Object[] command) {
        String keyword;
        int idx = 1;
        if (Strings.isEquals(keyword = CommandParsers.toRune(command[idx++]), "LOAD")) {
            boolean replace = false;
            byte[] engineName = null;
            byte[] description = null;
            byte[] libraryName = null;
            byte[] functionCode = null;
            if (command.length > 4) {
                engineName = CommandParsers.toBytes(command[idx]);
                libraryName = CommandParsers.toBytes(command[++idx]);
                for (int i = ++idx; i < command.length; ++i) {
                    String token = CommandParsers.toRune(command[i]);
                    if (Strings.isEquals(token, "REPLACE")) {
                        replace = true;
                        continue;
                    }
                    if (Strings.isEquals(token, "DESCRIPTION")) {
                        description = CommandParsers.toBytes(command[++i]);
                        continue;
                    }
                    functionCode = CommandParsers.toBytes(command[i]);
                }
            } else {
                for (int i = idx; i < command.length; ++i) {
                    String token = CommandParsers.toRune(command[i]);
                    if (Strings.isEquals(token, "REPLACE")) {
                        replace = true;
                        continue;
                    }
                    functionCode = CommandParsers.toBytes(command[i]);
                }
            }
            return new FunctionLoadCommand(engineName, libraryName, replace, description, functionCode);
        }
        if (Strings.isEquals(keyword, "FLUSH")) {
            boolean isAsync = false;
            boolean isSync = false;
            if (idx >= command.length) {
                return new FunctionFlushCommand(false, false);
            }
            String value = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(value, "ASYNC")) {
                isAsync = true;
            } else if (Strings.isEquals(value, "SYNC")) {
                isSync = true;
            }
            return new FunctionFlushCommand(isAsync, isSync);
        }
        if (Strings.isEquals(keyword, "DELETE")) {
            byte[] libraryName = CommandParsers.toBytes(command[idx]);
            return new FunctionDeleteCommand(libraryName);
        }
        if (Strings.isEquals(keyword, "RESTORE")) {
            byte[] serializedValue = CommandParsers.toBytes(command[idx++]);
            boolean replace = false;
            boolean flush = false;
            boolean append = false;
            if (idx < command.length) {
                String value = CommandParsers.toRune(command[idx]);
                if (Strings.isEquals(value, "REPLACE")) {
                    replace = true;
                } else if (Strings.isEquals(value, "APPEND")) {
                    append = true;
                } else if (Strings.isEquals(value, "FLUSH")) {
                    flush = true;
                }
            }
            return new FunctionRestoreCommand(serializedValue, replace, flush, append);
        }
        throw new AssertionError((Object)("FUNCTION " + keyword));
    }
}

