/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AsyncReplicator;
import com.moilioncircle.redis.replicator.CloseListener;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.ExceptionListener;
import com.moilioncircle.redis.replicator.FileType;
import com.moilioncircle.redis.replicator.RedisReplicator;
import com.moilioncircle.redis.replicator.RedisURI;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.Replicators;
import com.moilioncircle.redis.replicator.SslConfiguration;
import com.moilioncircle.redis.replicator.Status;
import com.moilioncircle.redis.replicator.StatusListener;
import com.moilioncircle.redis.replicator.cmd.Command;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class AsyncRedisReplicator
implements AsyncReplicator {
    protected final Replicator replicator;

    public AsyncRedisReplicator(File file, FileType fileType, Configuration configuration) throws FileNotFoundException {
        this.replicator = new RedisReplicator(file, fileType, configuration);
    }

    public AsyncRedisReplicator(InputStream in, FileType fileType, Configuration configuration) {
        this.replicator = new RedisReplicator(in, fileType, configuration);
    }

    public AsyncRedisReplicator(String host, int port, Configuration configuration) {
        this.replicator = new RedisReplicator(host, port, configuration);
    }

    public AsyncRedisReplicator(String uri) throws URISyntaxException, IOException {
        this.replicator = new RedisReplicator(uri);
    }

    public AsyncRedisReplicator(RedisURI uri) throws IOException {
        this.replicator = new RedisReplicator(uri);
    }

    public AsyncRedisReplicator(String uri, SslConfiguration sslConfiguration) throws URISyntaxException, IOException {
        this.replicator = new RedisReplicator(uri, sslConfiguration);
    }

    public AsyncRedisReplicator(RedisURI uri, SslConfiguration sslConfiguration) throws IOException {
        this.replicator = new RedisReplicator(uri, sslConfiguration);
    }

    public <T extends Replicator> T getReplicator() {
        return (T)this.replicator;
    }

    @Override
    public boolean addRawByteListener(RawByteListener listener) {
        return this.replicator.addRawByteListener(listener);
    }

    @Override
    public boolean removeRawByteListener(RawByteListener listener) {
        return this.replicator.removeRawByteListener(listener);
    }

    @Override
    public void builtInCommandParserRegister() {
        this.replicator.builtInCommandParserRegister();
    }

    @Override
    public CommandParser<? extends Command> getCommandParser(CommandName command) {
        return this.replicator.getCommandParser(command);
    }

    @Override
    public <T extends Command> void addCommandParser(CommandName command, CommandParser<T> parser) {
        this.replicator.addCommandParser(command, parser);
    }

    @Override
    public CommandParser<? extends Command> removeCommandParser(CommandName command) {
        return this.replicator.removeCommandParser(command);
    }

    @Override
    public ModuleParser<? extends Module> getModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.getModuleParser(moduleName, moduleVersion);
    }

    @Override
    public <T extends Module> void addModuleParser(String moduleName, int moduleVersion, ModuleParser<T> parser) {
        this.replicator.addModuleParser(moduleName, moduleVersion, parser);
    }

    @Override
    public ModuleParser<? extends Module> removeModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.removeModuleParser(moduleName, moduleVersion);
    }

    @Override
    public void setRdbVisitor(RdbVisitor rdbVisitor) {
        this.replicator.setRdbVisitor(rdbVisitor);
    }

    @Override
    public RdbVisitor getRdbVisitor() {
        return this.replicator.getRdbVisitor();
    }

    @Override
    public boolean addEventListener(EventListener listener) {
        return this.replicator.addEventListener(listener);
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        return this.replicator.removeEventListener(listener);
    }

    @Override
    public boolean addCloseListener(CloseListener listener) {
        return this.replicator.addCloseListener(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        return this.replicator.removeCloseListener(listener);
    }

    @Override
    public boolean addExceptionListener(ExceptionListener listener) {
        return this.replicator.addExceptionListener(listener);
    }

    @Override
    public boolean removeExceptionListener(ExceptionListener listener) {
        return this.replicator.removeExceptionListener(listener);
    }

    @Override
    public boolean addStatusListener(StatusListener listener) {
        return this.replicator.addStatusListener(listener);
    }

    @Override
    public boolean removeStatusListener(StatusListener listener) {
        return this.replicator.removeStatusListener(listener);
    }

    @Override
    public boolean verbose() {
        return this.replicator.verbose();
    }

    @Override
    public Status getStatus() {
        return this.replicator.getStatus();
    }

    @Override
    public Configuration getConfiguration() {
        return this.replicator.getConfiguration();
    }

    @Override
    public CompletableFuture<Void> open(Executor executor) {
        Runnable runnable = () -> Replicators.open(this.replicator);
        if (executor == null) {
            return CompletableFuture.runAsync(runnable);
        }
        return CompletableFuture.runAsync(runnable, executor);
    }

    @Override
    public CompletableFuture<Void> close(Executor executor) {
        Runnable runnable = () -> Replicators.close(this.replicator);
        if (executor == null) {
            return CompletableFuture.runAsync(runnable);
        }
        return CompletableFuture.runAsync(runnable, executor);
    }
}

