/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.delegation.StreamPlanner;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.calcite.LegacySink;
import org.apache.flink.table.planner.plan.nodes.calcite.Sink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.optimize.CommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlock;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.schema.IntermediateRelTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.trait.ModifyKindSet;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.trait.UpdateKind;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001E\u0011!e\u0015;sK\u0006l7i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014(BA\u0002\u0005\u0003!y\u0007\u000f^5nSj,'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta2i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014\b\u0002C\u0004\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0011\u0005aYR\"A\r\u000b\u0005i1\u0011A\u00033fY\u0016<\u0017\r^5p]&\u0011A$\u0007\u0002\u000e'R\u0014X-Y7QY\u0006tg.\u001a:\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u0014\u0001!)q!\ba\u0001/!)1\u0005\u0001C)I\u0005QAm\\(qi&l\u0017N_3\u0015\u0005\u00152\u0004c\u0001\u00141g9\u0011q%\f\b\u0003Q-j\u0011!\u000b\u0006\u0003UA\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059z\u0013a\u00029bG.\fw-\u001a\u0006\u0002Y%\u0011\u0011G\r\u0002\u0004'\u0016\f(B\u0001\u00180!\t\u0019B'\u0003\u00026\u0005\ta!+\u001a7O_\u0012,'\t\\8dW\")qG\ta\u0001q\u0005)!o\\8ugB\u0019a\u0005M\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014a\u0001:fY*\u0011a\bD\u0001\bG\u0006d7-\u001b;f\u0013\t\u00015HA\u0004SK2tu\u000eZ3\t\u000b\t\u0003A\u0011B\"\u0002\u001b=\u0004H/[7ju\u0016\u0014En\\2l)\r!\u0005J\u0013\t\u0003\u000b\u001ak\u0011aL\u0005\u0003\u000f>\u0012A!\u00168ji\")\u0011*\u0011a\u0001g\u0005)!\r\\8dW\")1*\u0011a\u0001\u0019\u0006Y\u0011n]*j].\u0014En\\2l!\t)U*\u0003\u0002O_\t9!i\\8mK\u0006t\u0007\"\u0002)\u0001\t\u0013\t\u0016\u0001D8qi&l\u0017N_3Ue\u0016,G#B\u001dS)Zs\u0006\"B*P\u0001\u0004I\u0014a\u0002:fY:{G-\u001a\u0005\u0006+>\u0003\r\u0001T\u0001\u0015kB$\u0017\r^3CK\u001a|'/\u001a*fcVL'/\u001a3\t\u000b]{\u0005\u0019\u0001-\u0002#5Lg.\u001b\"bi\u000eD\u0017J\u001c;feZ\fG\u000e\u0005\u0002Z96\t!L\u0003\u0002\\\t\u0005)AO]1ji&\u0011QL\u0017\u0002\u0012\u001b&t\u0017NQ1uG\"Le\u000e^3sm\u0006d\u0007\"B&P\u0001\u0004a\u0005\"\u00021\u0001\t\u0013\t\u0017a\n9s_B\fw-\u0019;f+B$\u0017\r^3LS:$\u0017I\u001c3NS:L')\u0019;dQ&sG/\u001a:wC2$R\u0001\u00122dI\u0016DQ!S0A\u0002MBQ!V0A\u00021CQaV0A\u0002aCQaS0A\u00021CQa\u001a\u0001\u0005\n!\fqC]3tKRLe\u000e^3s[\u0016$\u0017.\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\u0005\u0011K\u0007\"B%g\u0001\u0004\u0019\u0004\"B6\u0001\t\u0013a\u0017AG2sK\u0006$X-\u00138uKJlW\rZ5bi\u0016\u0014V\r\u001c+bE2,GCB7t{z\f9\u0001\u0005\u0002oc6\tqN\u0003\u0002q\t\u000511o\u00195f[\u0006L!A]8\u0003)%sG/\u001a:nK\u0012L\u0017\r^3SK2$\u0016M\u00197f\u0011\u0015!(\u000e1\u0001v\u0003\u0011q\u0017-\\3\u0011\u0005YThBA<y!\tAs&\u0003\u0002z_\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tIx\u0006C\u0003TU\u0002\u0007\u0011\b\u0003\u0004\u0000U\u0002\u0007\u0011\u0011A\u0001\u000e[>$\u0017NZ=LS:$7+\u001a;\u0011\u0007e\u000b\u0019!C\u0002\u0002\u0006i\u0013Q\"T8eS\u001aL8*\u001b8e'\u0016$\bBBA\u0005U\u0002\u0007A*\u0001\fjgV\u0003H-\u0019;f\u0005\u00164wN]3SKF,\u0018N]3e\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\tQbZ3u+:L\u0017/^3LKf\u001cH\u0003BA\t\u0003k\u0001D!a\u0005\u0002(A1\u0011QCA\u0010\u0003Gi!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0005kRLGN\u0003\u0002\u0002\u001e\u0005!!.\u0019<b\u0013\u0011\t\t#a\u0006\u0003\u0007M+G\u000f\u0005\u0003\u0002&\u0005\u001dB\u0002\u0001\u0003\r\u0003S\tY!!A\u0001\u0002\u000b\u0005\u00111\u0006\u0002\u0004?\u0012\n\u0014\u0003BA\u0017\u0003g\u00012!RA\u0018\u0013\r\t\td\f\u0002\b\u001d>$\b.\u001b8h!\u0015\t)\"a\bv\u0011\u0019\u0019\u00161\u0002a\u0001s\u0001")
public class StreamCommonSubGraphBasedOptimizer
extends CommonSubGraphBasedOptimizer {
    public final StreamPlanner org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner;

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<RelNodeBlock> doOptimize(Seq<RelNode> roots) {
        void var3_3;
        TableConfig tableConfig = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        Seq<RelNodeBlock> sinkBlocks = RelNodeBlockPlanBuilder$.MODULE$.buildRelNodeBlockPlan(roots, (ReadableConfig)tableConfig);
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)sinkBlock -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$doOptimize$1(tableConfig, sinkBlock);
            return BoxedUnit.UNIT;
        });
        if (sinkBlocks.size() == 1) {
            RelNodeBlock block2 = (RelNodeBlock)sinkBlocks.head();
            RelNode optimizedTree = this.optimizeTree(block2.getPlan(), block2.isUpdateBeforeRequired(), block2.getMiniBatchInterval(), true);
            block2.setOptimizedPlan(optimizedTree);
            return sinkBlocks;
        }
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.optimizeBlock(b, true);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.propagateUpdateKindAndMiniBatchInterval(b, b.isUpdateBeforeRequired(), b.getMiniBatchInterval(), true);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)block -> {
            this.resetIntermediateResult(block);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.optimizeBlock(b, true);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private void optimizeBlock(RelNodeBlock block, boolean isSinkBlock) {
        RelNode blockLogicalPlan;
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$optimizeBlock$1(this, child);
            return BoxedUnit.UNIT;
        });
        RelNode relNode = blockLogicalPlan = block.getPlan();
        boolean bl = relNode instanceof LegacySink ? true : relNode instanceof Sink;
        if (bl) {
            Predef$.MODULE$.require(isSinkBlock);
            RelNode optimizedTree = this.optimizeTree(blockLogicalPlan, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), true);
            block.setOptimizedPlan(optimizedTree);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            RelNode optimizedPlan = this.optimizeTree(relNode, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), isSinkBlock);
            ModifyKindSetTrait modifyKindSetTrait = optimizedPlan.getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
            String name = this.createUniqueIntermediateRelTableName();
            IntermediateRelTable intermediateRelTable = this.createIntermediateRelTable(name, optimizedPlan, modifyKindSetTrait.modifyKindSet(), block.isUpdateBeforeRequired());
            TableScan newTableScan = this.wrapIntermediateRelTableToTableScan(intermediateRelTable, name);
            block.setNewOutputNode(newTableScan);
            block.setOutputTableName(name);
            block.setOptimizedPlan(optimizedPlan);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RelNode optimizeTree(RelNode relNode, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean isSinkBlock) {
        TableConfig config = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig(config);
        FlinkChainedProgram programs = (FlinkChainedProgram)calciteConfig.getStreamProgram().getOrElse((Function0 & Serializable & scala.Serializable)() -> FlinkStreamProgram$.MODULE$.buildProgram((ReadableConfig)config));
        Preconditions.checkNotNull((Object)programs);
        FlinkContext context = relNode.getCluster().getPlanner().getContext().unwrap(FlinkContext.class);
        return programs.optimize(relNode, new StreamOptimizeContext(this, updateBeforeRequired, miniBatchInterval, isSinkBlock, config, context){
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;
            private final boolean updateBeforeRequired$1;
            private final MiniBatchInterval miniBatchInterval$1;
            private final boolean isSinkBlock$1;
            private final TableConfig config$1;
            private final FlinkContext context$1;

            public ClassLoader getClassLoader() {
                return FlinkContext.getClassLoader$(this);
            }

            public <C> C unwrap(Class<C> clazz) {
                return (C)FlinkContext.unwrap$(this, clazz);
            }

            public boolean isBatchMode() {
                return false;
            }

            public TableConfig getTableConfig() {
                return this.config$1;
            }

            public FunctionCatalog getFunctionCatalog() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.functionCatalog();
            }

            public CatalogManager getCatalogManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.catalogManager();
            }

            public ModuleManager getModuleManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.moduleManager();
            }

            public SqlExprToRexConverterFactory getSqlExprToRexConverterFactory() {
                return this.context$1.getSqlExprToRexConverterFactory();
            }

            public FlinkRelBuilder getFlinkRelBuilder() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getRelBuilder();
            }

            public boolean isUpdateBeforeRequired() {
                return this.updateBeforeRequired$1;
            }

            public MiniBatchInterval getMiniBatchInterval() {
                return this.miniBatchInterval$1;
            }

            public boolean needFinalTimeIndicatorConversion() {
                return this.isSinkBlock$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.updateBeforeRequired$1 = updateBeforeRequired$1;
                this.miniBatchInterval$1 = miniBatchInterval$1;
                this.isSinkBlock$1 = isSinkBlock$1;
                this.config$1 = config$1;
                this.context$1 = context$1;
                FlinkContext.$init$(this);
            }
        });
    }

    private void propagateUpdateKindAndMiniBatchInterval(RelNodeBlock block, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean isSinkBlock) {
        RelNode blockLogicalPlan = block.getPlan();
        RelNode optimizedPlan = this.optimizeTree(blockLogicalPlan, updateBeforeRequired, miniBatchInterval, isSinkBlock);
        StreamCommonSubGraphBasedOptimizer.propagateTraits$1(optimizedPlan, block);
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            this.propagateUpdateKindAndMiniBatchInterval(child, child.isUpdateBeforeRequired(), child.getMiniBatchInterval(), false);
            return BoxedUnit.UNIT;
        });
    }

    private void resetIntermediateResult(RelNodeBlock block) {
        block.setNewOutputNode(null);
        block.setOutputTableName(null);
        block.setOptimizedPlan(null);
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$resetIntermediateResult$1(this, child);
            return BoxedUnit.UNIT;
        });
    }

    private IntermediateRelTable createIntermediateRelTable(String name, RelNode relNode, ModifyKindSet modifyKindSet, boolean isUpdateBeforeRequired) {
        Set<? extends Set<String>> uniqueKeys = this.getUniqueKeys(relNode);
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getRelBuilder().getCluster().getMetadataQuery());
        RelModifiedMonotonicity monotonicity = fmq.getRelModifiedMonotonicity(relNode);
        RelWindowProperties windowProperties = fmq.getRelWindowProperties(relNode);
        FlinkStatistic statistic = FlinkStatistic$.MODULE$.builder().uniqueKeys(uniqueKeys).relModifiedMonotonicity(monotonicity).relWindowProperties(windowProperties).build();
        return new IntermediateRelTable(Collections.singletonList(name), relNode, modifyKindSet, isUpdateBeforeRequired, fmq.getUpsertKeys(relNode), statistic);
    }

    private Set<? extends Set<String>> getUniqueKeys(RelNode relNode) {
        RelDataType rowType = relNode.getRowType();
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getRelBuilder().getCluster().getMetadataQuery());
        Set<ImmutableBitSet> uniqueKeys = fmq.getUniqueKeys(relNode);
        return uniqueKeys != null ? JavaConversions$.MODULE$.deprecated$u0020mutableSetAsJavaSet((scala.collection.mutable.Set)((SetLike)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(uniqueKeys).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamCommonSubGraphBasedOptimizer.$anonfun$getUniqueKeys$1(x$1)))).map((Function1 & Serializable & scala.Serializable)uniqueKey -> {
            void var2_2;
            HashSet keys = new HashSet();
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(uniqueKey.asList()).foreach((Function1 & Serializable & scala.Serializable)idx -> BoxesRunTime.boxToBoolean((boolean)keys.add(rowType.getFieldNames().get(Predef$.MODULE$.Integer2int(idx)))));
            return var2_2;
        }, Set$.MODULE$.canBuildFrom())) : null;
    }

    public static final /* synthetic */ void $anonfun$doOptimize$1(TableConfig tableConfig$1, RelNodeBlock sinkBlock) {
        MiniBatchInterval miniBatchInterval;
        sinkBlock.setUpdateBeforeRequired(false);
        if (Predef$.MODULE$.Boolean2boolean((Boolean)tableConfig$1.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED))) {
            long miniBatchLatency = ((Duration)tableConfig$1.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY)).toMillis();
            Preconditions.checkArgument((miniBatchLatency > 0L ? 1 : 0) != 0, (String)"MiniBatch Latency must be greater than 0 ms.", (Object[])new Object[]{null});
            miniBatchInterval = new MiniBatchInterval(miniBatchLatency, MiniBatchMode.ProcTime);
        } else {
            miniBatchInterval = MiniBatchIntervalTrait$.MODULE$.NONE().getMiniBatchInterval();
        }
        MiniBatchInterval miniBatchInterval2 = miniBatchInterval;
        sinkBlock.setMiniBatchInterval(miniBatchInterval2);
    }

    public static final /* synthetic */ void $anonfun$optimizeBlock$1(StreamCommonSubGraphBasedOptimizer $this, RelNodeBlock child) {
        block0: {
            if (!child.getNewOutputNode().isEmpty()) break block0;
            $this.optimizeBlock(child, false);
        }
    }

    private static final void propagateTraits$1(RelNode rel, RelNodeBlock block$1) {
        RelNode relNode = rel;
        boolean bl = relNode instanceof StreamPhysicalDataStreamScan ? true : (relNode instanceof StreamPhysicalIntermediateTableScan ? true : (relNode instanceof StreamPhysicalLegacyTableSourceScan ? true : relNode instanceof StreamPhysicalTableSourceScan));
        if (bl) {
            BoxedUnit boxedUnit;
            TableScan scan = (TableScan)rel;
            UpdateKindTrait updateKindTrait = scan.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE());
            MiniBatchIntervalTrait miniBatchIntervalTrait = scan.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE());
            String tableName = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(scan.getTable().getQualifiedName()).mkString(".");
            Seq inputBlocks = (Seq)block$1.children().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)tableName.equals(b.getOutputTableName())));
            Preconditions.checkArgument((inputBlocks.size() <= 1 ? 1 : 0) != 0);
            if (inputBlocks.size() == 1) {
                RelNodeBlock childBlock = (RelNodeBlock)inputBlocks.head();
                childBlock.setMiniBatchInterval(miniBatchIntervalTrait.getMiniBatchInterval());
                UpdateKind updateKind = updateKindTrait.updateKind();
                UpdateKind updateKind2 = UpdateKind.BEFORE_AND_AFTER;
                boolean requireUB = !(updateKind != null ? !((Object)((Object)updateKind)).equals((Object)updateKind2) : updateKind2 != null);
                childBlock.setUpdateBeforeRequired(requireUB || childBlock.isUpdateBeforeRequired());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (relNode instanceof StreamPhysicalRel) {
            StreamPhysicalRel streamPhysicalRel = (StreamPhysicalRel)relNode;
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(streamPhysicalRel.getInputs()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                StreamCommonSubGraphBasedOptimizer.propagateTraits$1(e, block$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$resetIntermediateResult$1(StreamCommonSubGraphBasedOptimizer $this, RelNodeBlock child) {
        block0: {
            if (!child.getNewOutputNode().nonEmpty()) break block0;
            $this.resetIntermediateResult(child);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getUniqueKeys$1(ImmutableBitSet x$1) {
        return JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)x$1).nonEmpty();
    }

    public StreamCommonSubGraphBasedOptimizer(StreamPlanner planner) {
        this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner = planner;
    }
}

