/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.GroupAggFunction;
import org.apache.flink.table.runtime.operators.aggregate.MiniBatchGroupAggFunction;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-group-aggregate", version=1, consumedOptions={"table.exec.mini-batch.enabled", "table.exec.mini-batch.size"}, producedTransformations={"group-aggregate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecGroupAggregate
extends StreamExecAggregateBase {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecGroupAggregate.class);
    public static final String GROUP_AGGREGATE_TRANSFORMATION = "group-aggregate";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="aggCallNeedRetractions")
    private final boolean[] aggCallNeedRetractions;
    @JsonProperty(value="generateUpdateBefore")
    private final boolean generateUpdateBefore;
    @JsonProperty(value="needRetraction")
    private final boolean needRetraction;

    public StreamExecGroupAggregate(ReadableConfig tableConfig, int[] grouping, AggregateCall[] aggCalls, boolean[] aggCallNeedRetractions, boolean generateUpdateBefore, boolean needRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecGroupAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecGroupAggregate.class, tableConfig), grouping, aggCalls, aggCallNeedRetractions, generateUpdateBefore, needRetraction, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecGroupAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="aggCallNeedRetractions") boolean[] aggCallNeedRetractions, @JsonProperty(value="generateUpdateBefore") boolean generateUpdateBefore, @JsonProperty(value="needRetraction") boolean needRetraction, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.aggCallNeedRetractions = (boolean[])Preconditions.checkNotNull((Object)aggCallNeedRetractions);
        Preconditions.checkArgument((aggCalls.length == aggCallNeedRetractions.length ? 1 : 0) != 0);
        this.generateUpdateBefore = generateUpdateBefore;
        this.needRetraction = needRetraction;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        KeyedProcessOperator operator;
        GroupAggFunction aggFunction;
        if (this.grouping.length > 0 && config.getStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config.getTableConfig()), planner.getRelBuilder(), JavaScalaConversionUtil.toScala(inputRowType.getChildren()), true).needAccumulate();
        if (this.needRetraction) {
            generator.needRetract();
        }
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.aggCallNeedRetractions, this.needRetraction, true, true);
        GeneratedAggsHandleFunction aggsHandler = generator.generateAggsHandler("GroupAggsHandler", aggInfoList);
        LogicalType[] accTypes = (LogicalType[])Arrays.stream(aggInfoList.getAccTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        LogicalType[] aggValueTypes = (LogicalType[])Arrays.stream(aggInfoList.getActualValueTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        GeneratedRecordEqualiser recordEqualiser = new EqualiserCodeGenerator(aggValueTypes).generateRecordEqualiser("GroupAggValueEqualiser");
        int inputCountIndex = aggInfoList.getIndexOfCountStar();
        boolean isMiniBatchEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        if (isMiniBatchEnabled) {
            aggFunction = new MiniBatchGroupAggFunction(aggsHandler, recordEqualiser, accTypes, inputRowType, inputCountIndex, this.generateUpdateBefore, config.getStateRetentionTime());
            operator = new KeyedMapBundleOperator((MapBundleFunction)aggFunction, AggregateUtil.createMiniBatchTrigger(config));
        } else {
            aggFunction = new GroupAggFunction(aggsHandler, recordEqualiser, accTypes, inputCountIndex, this.generateUpdateBefore, config.getStateRetentionTime());
            operator = new KeyedProcessOperator((KeyedProcessFunction)aggFunction);
        }
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(GROUP_AGGREGATE_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(this.grouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }
}

