/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.util.Preconditions;

public class ExecNodeGraph {
    private final FlinkVersion flinkVersion;
    private final List<ExecNode<?>> rootNodes;

    public ExecNodeGraph(List<ExecNode<?>> rootNodes) {
        this(FlinkVersion.current(), rootNodes);
    }

    public ExecNodeGraph(FlinkVersion flinkVersion, List<ExecNode<?>> rootNodes) {
        this.flinkVersion = (FlinkVersion)Preconditions.checkNotNull((Object)flinkVersion, (String)"The flinkVersion should not be null.");
        this.rootNodes = (List)Preconditions.checkNotNull(rootNodes, (String)"The rootNodes should not be null.");
        Preconditions.checkArgument((!rootNodes.isEmpty() ? 1 : 0) != 0, (Object)"The rootNodes should not be empty.");
    }

    public List<ExecNode<?>> getRootNodes() {
        return this.rootNodes;
    }

    public FlinkVersion getFlinkVersion() {
        return this.flinkVersion;
    }
}

