/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;

@JsonTypeName(value="LimitPushDown")
public final class LimitPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_LIMIT = "limit";
    @JsonProperty(value="limit")
    private final long limit;

    @JsonCreator
    public LimitPushDownSpec(@JsonProperty(value="limit") long limit) {
        this.limit = limit;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        if (!(tableSource instanceof SupportsLimitPushDown)) {
            throw new TableException(String.format("%s does not support SupportsLimitPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsLimitPushDown)tableSource).applyLimit(this.limit);
    }

    @Override
    public String getDigests(SourceAbilityContext context) {
        return "limit=[" + this.limit + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitPushDownSpec that = (LimitPushDownSpec)o;
        return this.limit == that.limit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit);
    }
}

