/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlDescriptorOperator
extends SqlOperator {
    public SqlDescriptorOperator() {
        super("DESCRIPTOR", SqlKind.DESCRIPTOR, 100, 100, SqlDescriptorOperator::inferRowType, null, null);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder().kind(StructKind.PEEK_FIELDS_NO_EXPAND);
        for (SqlNode node : call.getOperandList()) {
            if (node instanceof SqlIdentifier) {
                ((RelDataTypeFactory.Builder)builder).add(((SqlIdentifier)node).getSimple(), typeFactory.createUnknownType());
                continue;
            }
            throw new IllegalArgumentException("DESCRIPTOR operator only supports accepting a list of identifiers that represent a list of names.");
        }
        return builder.build();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        for (SqlNode operand : callBinding.getCall().getOperandList()) {
            if (operand instanceof SqlIdentifier && !((SqlIdentifier)operand).isSimple() || !throwOnFailure) continue;
            throw SqlUtil.newContextException(operand.getParserPosition(), Static.RESOURCE.aliasMustBeSimpleIdentifier());
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory.FieldInfoBuilder builder = opBinding.getTypeFactory().builder().kind(StructKind.PEEK_FIELDS_NO_EXPAND);
        for (int i = 0; i < opBinding.getOperandCount(); ++i) {
            ((RelDataTypeFactory.Builder)builder).add("$" + i, opBinding.getOperandType(i));
        }
        return builder.build();
    }
}

