/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class BooleanToNumericCastRule
extends AbstractExpressionCodeGeneratorCastRule<Boolean, Number> {
    static final BooleanToNumericCastRule INSTANCE = new BooleanToNumericCastRule();

    private BooleanToNumericCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.BOOLEAN).target(LogicalTypeFamily.NUMERIC).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return CastRuleUtils.ternaryOperator(inputTerm, this.trueValue(targetLogicalType), this.falseValue(targetLogicalType));
    }

    private String trueValue(LogicalType target) {
        switch (target.getTypeRoot()) {
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)target;
                return CastRuleUtils.staticCall(BuiltInMethods.INTEGRAL_TO_DECIMAL(), 1, decimalType.getPrecision(), decimalType.getScale());
            }
            case TINYINT: {
                return CodeGenUtils.primitiveLiteralForType((byte)1);
            }
            case SMALLINT: {
                return CodeGenUtils.primitiveLiteralForType((short)1);
            }
            case INTEGER: {
                return CodeGenUtils.primitiveLiteralForType(1);
            }
            case BIGINT: {
                return CodeGenUtils.primitiveLiteralForType(1L);
            }
            case FLOAT: {
                return CodeGenUtils.primitiveLiteralForType(Float.valueOf(1.0f));
            }
            case DOUBLE: {
                return CodeGenUtils.primitiveLiteralForType(1.0);
            }
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }

    private String falseValue(LogicalType target) {
        switch (target.getTypeRoot()) {
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)target;
                return CastRuleUtils.staticCall(BuiltInMethods.DECIMAL_ZERO(), decimalType.getPrecision(), decimalType.getScale());
            }
            case TINYINT: {
                return CodeGenUtils.primitiveLiteralForType((byte)0);
            }
            case SMALLINT: {
                return CodeGenUtils.primitiveLiteralForType((short)0);
            }
            case INTEGER: {
                return CodeGenUtils.primitiveLiteralForType(0);
            }
            case BIGINT: {
                return CodeGenUtils.primitiveLiteralForType(0L);
            }
            case FLOAT: {
                return CodeGenUtils.primitiveLiteralForType(Float.valueOf(0.0f));
            }
            case DOUBLE: {
                return CodeGenUtils.primitiveLiteralForType(0.0);
            }
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }
}

