/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.List;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.plan.schema.ExpandingPreparingTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

public class QueryOperationCatalogViewTable
extends ExpandingPreparingTable {
    private final QueryOperationCatalogView catalogView;

    private QueryOperationCatalogViewTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, QueryOperationCatalogView catalogView) {
        super(relOptSchema, rowType, names, FlinkStatistic.UNKNOWN());
        this.catalogView = catalogView;
    }

    public static QueryOperationCatalogViewTable create(RelOptSchema schema, List<String> names, RelDataType rowType, QueryOperationCatalogView view) {
        return new QueryOperationCatalogViewTable(schema, names, rowType, view);
    }

    @Override
    public List<String> getQualifiedName() {
        QueryOperation queryOperation = this.catalogView.getQueryOperation();
        if (queryOperation instanceof TableSourceQueryOperation) {
            TableSourceQueryOperation tsqo = (TableSourceQueryOperation)queryOperation;
            return this.explainSourceAsString(tsqo.getTableSource());
        }
        return super.getQualifiedName();
    }

    @Override
    public RelNode convertToRel(RelOptTable.ToRelContext context) {
        RelOptCluster cluster = context.getCluster();
        Context chain = Contexts.of(context, cluster.getPlanner().getContext());
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(chain, cluster, this.getRelOptSchema());
        return relBuilder.queryOperation(this.catalogView.getQueryOperation()).build();
    }
}

