/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dml;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.dml.RichSqlInsert;

public class SqlStatementSet
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("Statement Set", SqlKind.OTHER);
    private final ArrayList<RichSqlInsert> inserts = new ArrayList();

    public SqlStatementSet(List<RichSqlInsert> inserts, SqlParserPos pos) {
        super(pos);
        this.inserts.addAll(inserts);
    }

    public List<RichSqlInsert> getInserts() {
        return this.inserts;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return new ArrayList<SqlNode>(this.inserts);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("STATEMENT SET BEGIN");
        writer.newlineAndIndent();
        this.inserts.forEach(insert -> {
            insert.unparse(writer, insert.getOperator().getLeftPrec(), insert.getOperator().getRightPrec());
            writer.sep(";");
            writer.newlineAndIndent();
        });
        writer.keyword("END");
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        if (!(operand instanceof RichSqlInsert)) {
            throw new UnsupportedOperationException("SqlStatementSet SqlNode only support RichSqlInsert as operand");
        }
        this.inserts.set(i, (RichSqlInsert)operand);
    }
}

