/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl.constraint;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.constraint.SqlConstraintEnforcement;
import org.apache.flink.sql.parser.ddl.constraint.SqlUniqueSpec;

public class SqlTableConstraint
extends SqlCall {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("SqlTableConstraint", SqlKind.OTHER);
    private final SqlIdentifier constraintName;
    private final SqlLiteral uniqueSpec;
    private final SqlNodeList columns;
    private final SqlLiteral enforcement;
    private final boolean isTableConstraint;

    public SqlTableConstraint(@Nullable SqlIdentifier constraintName, SqlLiteral uniqueSpec, SqlNodeList columns, @Nullable SqlLiteral enforcement, boolean isTableConstraint, SqlParserPos pos) {
        super(pos);
        this.constraintName = constraintName;
        this.uniqueSpec = uniqueSpec;
        this.columns = columns;
        this.enforcement = enforcement;
        this.isTableConstraint = isTableConstraint;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public boolean isUnique() {
        return this.uniqueSpec.getValueAs(SqlUniqueSpec.class) == SqlUniqueSpec.UNIQUE;
    }

    public boolean isPrimaryKey() {
        return this.uniqueSpec.getValueAs(SqlUniqueSpec.class) == SqlUniqueSpec.PRIMARY_KEY;
    }

    public boolean isEnforced() {
        return this.enforcement == null || this.enforcement.getValueAs(SqlConstraintEnforcement.class) == SqlConstraintEnforcement.ENFORCED;
    }

    public Optional<String> getConstraintName() {
        String ret = this.constraintName != null ? this.constraintName.getSimple() : null;
        return Optional.ofNullable(ret);
    }

    public Optional<SqlIdentifier> getConstraintNameIdentifier() {
        return Optional.ofNullable(this.constraintName);
    }

    public SqlNodeList getColumns() {
        return this.columns;
    }

    public boolean isTableConstraint() {
        return this.isTableConstraint;
    }

    public String[] getColumnNames() {
        return (String[])this.columns.getList().stream().map(col -> ((SqlIdentifier)col).getSimple()).toArray(String[]::new);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.constraintName, this.uniqueSpec, this.columns, this.enforcement);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.constraintName != null) {
            writer.keyword("CONSTRAINT");
            this.constraintName.unparse(writer, leftPrec, rightPrec);
        }
        this.uniqueSpec.unparse(writer, leftPrec, rightPrec);
        if (this.isTableConstraint) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode column : this.columns) {
                writer.sep(",", false);
                column.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
        if (this.enforcement != null) {
            this.enforcement.unparse(writer, leftPrec, rightPrec);
        }
    }
}

