/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.hint;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.hint.HintPredicate;
import org.apache.calcite.rel.hint.HintStrategy;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;

public class HintStrategyTable {
    public static final HintStrategyTable EMPTY = new HintStrategyTable(Collections.emptyMap(), HintErrorLogger.INSTANCE);
    private final Map<Key, HintStrategy> strategies;
    private final Litmus errorHandler;

    private HintStrategyTable(Map<Key, HintStrategy> strategies, Litmus litmus) {
        this.strategies = strategies;
        this.errorHandler = litmus;
    }

    public List<RelHint> apply(List<RelHint> hints, RelNode rel) {
        return hints.stream().filter(relHint -> this.canApply((RelHint)relHint, rel)).collect(Collectors.toList());
    }

    private boolean canApply(RelHint hint, RelNode rel) {
        Key key = Key.of(hint.hintName);
        assert (this.strategies.containsKey(key));
        return this.strategies.get((Object)key).predicate.apply(hint, rel);
    }

    public boolean validateHint(RelHint hint) {
        Key key = Key.of(hint.hintName);
        boolean hintExists = this.errorHandler.check(this.strategies.containsKey(key), "Hint: {} should be registered in the {}", hint.hintName, this.getClass().getSimpleName());
        if (!hintExists) {
            return false;
        }
        HintStrategy strategy = this.strategies.get(key);
        if (strategy.hintOptionChecker != null) {
            return strategy.hintOptionChecker.checkOptions(hint, this.errorHandler);
        }
        return true;
    }

    public boolean isRuleExcluded(Hintable hintable, RelOptRule rule) {
        ImmutableList<RelHint> hints = hintable.getHints();
        if (hints.size() == 0) {
            return false;
        }
        for (RelHint hint : hints) {
            Key key = Key.of(hint.hintName);
            assert (this.strategies.containsKey(key));
            HintStrategy strategy = this.strategies.get(key);
            if (!strategy.excludedRules.contains(rule)) continue;
            return HintStrategyTable.isDesiredConversionPossible(strategy.converterRules, hintable);
        }
        return false;
    }

    private static boolean isDesiredConversionPossible(Set<ConverterRule> converterRules, Hintable hintable) {
        return converterRules.size() == 0 || converterRules.stream().anyMatch(converterRule -> converterRule.convert((RelNode)((Object)hintable)) != null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class HintErrorLogger
    implements Litmus {
        private static final Logger LOGGER = CalciteTrace.PARSER_LOGGER;
        public static final HintErrorLogger INSTANCE = new HintErrorLogger();

        @Override
        public boolean fail(String message, Object ... args) {
            LOGGER.warn(message, args);
            return false;
        }

        @Override
        public boolean succeed() {
            return true;
        }

        @Override
        public boolean check(boolean condition, String message, Object ... args) {
            if (condition) {
                return this.succeed();
            }
            return this.fail(message, args);
        }
    }

    public static class Builder {
        private Map<Key, HintStrategy> strategies = new HashMap<Key, HintStrategy>();
        private Litmus errorHandler = HintErrorLogger.INSTANCE;

        private Builder() {
        }

        public Builder hintStrategy(String hintName, HintPredicate strategy) {
            this.strategies.put(Key.of(hintName), HintStrategy.builder(Objects.requireNonNull(strategy)).build());
            return this;
        }

        public Builder hintStrategy(String hintName, HintStrategy entry) {
            this.strategies.put(Key.of(hintName), Objects.requireNonNull(entry));
            return this;
        }

        public Builder errorHandler(Litmus errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public HintStrategyTable build() {
            return new HintStrategyTable(this.strategies, this.errorHandler);
        }
    }

    private static class Key {
        private String name;

        private Key(String name) {
            this.name = name;
        }

        static Key of(String name) {
            return new Key(name.toLowerCase(Locale.ROOT));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

