/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.message.BatchProxyMessage;
import org.apache.inlong.agent.message.ProxyMessage;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackProxyMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackProxyMessage.class);
    private final String groupId;
    private final String streamId;
    private final String jobId;
    private final int maxPackSize;
    private final int maxQueueNumber;
    private final int cacheTimeout;
    private final LinkedBlockingQueue<ProxyMessage> messageQueue;
    private final AtomicLong queueSize = new AtomicLong(0L);
    private int currentSize;
    private Map<String, String> extraMap = new HashMap<String, String>();
    private volatile long currentCacheTime = System.currentTimeMillis();

    public PackProxyMessage(String jobId, JobProfile jobConf, String groupId, String streamId) {
        this.jobId = jobId;
        this.maxPackSize = jobConf.getInt("proxy.package.maxSize", 512000);
        this.maxQueueNumber = jobConf.getInt("proxy.group.queue.maxNumber", 10000);
        this.cacheTimeout = jobConf.getInt("proxy.package.maxTimeout.ms", 4000);
        this.messageQueue = new LinkedBlockingQueue(this.maxQueueNumber);
        this.groupId = groupId;
        this.streamId = streamId;
        this.extraMap.put("syncSend", "false");
    }

    public void generateExtraMap(String dataKey) {
        this.extraMap.put("partitionKey", dataKey);
    }

    public void addTopicAndDataTime(String topic, long dataTime) {
        this.extraMap.put("streamId", this.streamId);
        this.extraMap.put("topic", topic);
        this.extraMap.put("dt", String.valueOf(dataTime));
    }

    private boolean queueIsFull() {
        return this.messageQueue.size() >= this.maxQueueNumber - 1;
    }

    public boolean addProxyMessage(ProxyMessage message) {
        assert (this.streamId.equals(message.getInlongStreamId()));
        try {
            if (this.queueIsFull()) {
                LOGGER.warn("message queue is greater than {}, stop adding message, maybe proxy get stuck", (Object)this.maxQueueNumber);
                return false;
            }
            this.messageQueue.put(message);
            this.queueSize.addAndGet(message.getBody().length);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("exception caught", (Throwable)ex);
            return false;
        }
    }

    public boolean isEmpty() {
        return this.messageQueue.isEmpty();
    }

    public BatchProxyMessage fetchBatch() {
        long currentTime = System.currentTimeMillis();
        if (this.queueSize.get() > (long)this.maxPackSize || this.queueIsFull() || currentTime - this.currentCacheTime > (long)this.cacheTimeout) {
            ProxyMessage peekMessage;
            int peekMessageLength;
            this.currentCacheTime = currentTime;
            long resultBatchSize = 0L;
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            while (!this.messageQueue.isEmpty() && resultBatchSize + (long)(peekMessageLength = (peekMessage = this.messageQueue.peek()).getBody().length) <= (long)this.maxPackSize) {
                ProxyMessage message = (ProxyMessage)this.messageQueue.remove();
                int bodySize = message.getBody().length;
                if (peekMessageLength > this.maxPackSize) {
                    LOGGER.warn("message size is {}, greater than max pack size {}, drop it!", (Object)peekMessage.getBody().length, (Object)this.maxPackSize);
                    this.queueSize.addAndGet(-bodySize);
                    this.messageQueue.remove();
                    break;
                }
                resultBatchSize += (long)bodySize;
                this.queueSize.addAndGet(-bodySize);
                result.add(message.getBody());
            }
            if (!result.isEmpty()) {
                return new BatchProxyMessage(this.jobId, this.groupId, this.streamId, result, AgentUtils.getCurrentTime(), this.extraMap);
            }
        }
        return null;
    }

    public Map<String, String> getExtraMap() {
        return this.extraMap;
    }
}

