/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.openapi;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.apache.inlong.manager.common.enums.InlongUserTypeEnum;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.inlong.manager.web.auth.openapi.SecretToken;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIAuthenticatingRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIAuthenticatingRealm.class);
    private final UserService userService;
    private final boolean openAPIAuthEnabled;

    public OpenAPIAuthenticatingRealm(UserService userService, boolean openAPIAuthEnabled) {
        this.userService = userService;
        this.openAPIAuthEnabled = openAPIAuthEnabled;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        if (this.openAPIAuthEnabled) {
            return this.doRealAuth(authenticationToken);
        }
        return this.doDefaultAuth(authenticationToken);
    }

    private AuthenticationInfo doDefaultAuth(AuthenticationToken authenticationToken) {
        try {
            UserInfo userInfo = this.userService.getByName("admin");
            userInfo.setRoles((Set)Sets.newHashSet((Object[])new String[]{InlongUserTypeEnum.INLONG_ADMIN.name(), InlongUserTypeEnum.INLONG_OPERATOR.name(), TenantUserTypeEnum.TENANT_ADMIN.name(), TenantUserTypeEnum.TENANT_OPERATOR.name()}));
            return new SimpleAuthenticationInfo((Object)userInfo, authenticationToken.getCredentials(), this.getName());
        }
        catch (Exception e) {
            log.error("got some exception when do default openapi auth", (Throwable)e);
            throw new AuthenticationException("internal error: " + e.getMessage());
        }
    }

    private AuthenticationInfo doRealAuth(AuthenticationToken authenticationToken) {
        SecretToken upToken = (SecretToken)authenticationToken;
        String username = upToken.getSecretId();
        UserInfo userInfo = this.userService.getByName(username);
        Preconditions.expectNotNull((Object)userInfo, (String)"User doesn't exist");
        Preconditions.expectTrue((boolean)userInfo.getDueDate().after(new Date()), (String)"user has expired");
        try {
            String secretKey = new String(AESUtils.decryptAsString((String)userInfo.getSecretKey(), (Integer)userInfo.getEncryptVersion()));
            userInfo.setRoles((Set)Sets.newHashSet((Object[])new String[]{userInfo.getAccountType() == 0 ? TenantUserTypeEnum.TENANT_ADMIN.name() : TenantUserTypeEnum.TENANT_OPERATOR.name()}));
            return new SimpleAuthenticationInfo((Object)userInfo, (Object)secretKey, this.getName());
        }
        catch (Exception e) {
            log.error("when do real openapi auth, decrypt secret key fail: ", (Throwable)e);
            throw new AuthenticationException("internal error: " + e.getMessage());
        }
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof SecretToken;
    }
}

