/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.impl.WriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrcCodecPool {
    private static final Logger LOG = LoggerFactory.getLogger(OrcCodecPool.class);
    private static final ConcurrentHashMap<CompressionKind, List<CompressionCodec>> POOL = new ConcurrentHashMap();
    private static final int MAX_PER_KIND = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionCodec getCodec(CompressionKind kind) {
        if (kind == CompressionKind.NONE) {
            return null;
        }
        CompressionCodec codec = null;
        List<CompressionCodec> codecList = POOL.get((Object)kind);
        if (codecList != null) {
            List<CompressionCodec> list = codecList;
            synchronized (list) {
                if (!codecList.isEmpty()) {
                    codec = codecList.remove(codecList.size() - 1);
                }
            }
        }
        if (codec == null) {
            codec = WriterImpl.createCodec(kind);
            LOG.info("Got brand-new codec " + (Object)((Object)kind));
        } else {
            LOG.debug("Got recycled codec");
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnCodec(CompressionKind kind, CompressionCodec codec) {
        if (codec == null) {
            return;
        }
        assert (kind != CompressionKind.NONE);
        try {
            codec.reset();
            List<CompressionCodec> list = POOL.get((Object)kind);
            if (list == null) {
                ArrayList newList = new ArrayList();
                List oldList = POOL.putIfAbsent(kind, newList);
                list = oldList == null ? newList : oldList;
            }
            List<CompressionCodec> list2 = list;
            synchronized (list2) {
                if (list.size() < 32) {
                    list.add(codec);
                    return;
                }
            }
            codec.close();
        }
        catch (Exception ex) {
            LOG.error("Ignoring codec cleanup error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPoolSize(CompressionKind kind) {
        if (kind == CompressionKind.NONE) {
            return 0;
        }
        List<CompressionCodec> codecList = POOL.get((Object)kind);
        if (codecList == null) {
            return 0;
        }
        List<CompressionCodec> list = codecList;
        synchronized (list) {
            return codecList.size();
        }
    }

    public static void clear() {
        POOL.clear();
    }

    private OrcCodecPool() {
    }
}

