/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.CascadeFunction;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;

@JsonTypeName(value="cascadeFunctionWrapper")
public class CascadeFunctionWrapper
implements Function,
Serializable {
    private static final long serialVersionUID = 8197348412858988257L;
    @JsonProperty(value="functions")
    private final List<CascadeFunction> functions;

    @JsonCreator
    public CascadeFunctionWrapper(@JsonProperty(value="functions") List<CascadeFunction> functions) {
        this.functions = Preconditions.checkNotNull(functions, "functions is null");
        Preconditions.checkState(!functions.isEmpty(), "functions is empty");
    }

    @Override
    public List<FunctionParam> getParams() {
        return new ArrayList<FunctionParam>(this.functions);
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("The method of getName is not support of CascadeFunction");
    }

    @Override
    public String format() {
        ConstantParam s2 = new ConstantParam(this.functions.get(0).format());
        for (int i = 1; i < this.functions.size(); ++i) {
            s2 = this.functions.get(i).apply(s2);
        }
        return s2.format();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CascadeFunctionWrapper)) {
            return false;
        }
        CascadeFunctionWrapper other = (CascadeFunctionWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CascadeFunction> this$functions = this.getFunctions();
        List<CascadeFunction> other$functions = other.getFunctions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CascadeFunctionWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CascadeFunction> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    public List<CascadeFunction> getFunctions() {
        return this.functions;
    }

    public String toString() {
        return "CascadeFunctionWrapper(functions=" + this.getFunctions() + ")";
    }
}

