/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="postgresExtract")
public class PostgresExtractNode
extends ExtractNode
implements Metadata,
InlongMetric,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="tableNames")
    private List<String> tableNames;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="schema")
    private String schema;
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="decodingPluginName")
    private String decodingPluginName;
    @JsonProperty(value="serverTimeZone")
    private String serverTimeZone;
    @JsonProperty(value="scanStartupMode")
    private String scanStartupMode;

    @JsonCreator
    public PostgresExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="watermark_field") WatermarkField watermarkField, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="tableNames") List<String> tableNames, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="database") String database, @JsonProperty(value="schema") String schema, @JsonProperty(value="port") Integer port, @JsonProperty(value="decodingPluginName") String decodingPluginName, @JsonProperty(value="serverTimeZone") String serverTimeZone, @JsonProperty(value="scanStartupMode") String scanStartupMode) {
        super(id, name, fields, watermarkField, properties);
        this.primaryKey = primaryKey;
        this.tableNames = Preconditions.checkNotNull(tableNames, "tableNames is null");
        this.hostname = Preconditions.checkNotNull(hostname, "hostname is null");
        this.username = Preconditions.checkNotNull(username, "username is null");
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.database = Preconditions.checkNotNull(database, "database is null");
        this.schema = Preconditions.checkNotNull(schema, "schema is null");
        this.port = Preconditions.checkNotNull(port, "port is null");
        this.decodingPluginName = decodingPluginName;
        this.serverTimeZone = serverTimeZone;
        this.scanStartupMode = scanStartupMode;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        if (this.getProperties() != null && !this.getProperties().isEmpty()) {
            options.putAll(this.getProperties());
        }
        options.put("connector", "postgres-cdc-inlong");
        options.put("hostname", this.hostname);
        options.put("username", this.username);
        options.put("password", this.password);
        options.put("database-name", this.database);
        options.put("schema-name", this.schema);
        options.put("port", this.port.toString());
        String formatTable = this.tableNames.size() == 1 ? this.tableNames.get(0) : String.format("(%s)", StringUtils.join(this.tableNames, "|"));
        options.put("table-name", String.format("%s", formatTable));
        String decodingPluginNameOption = StringUtils.isNotEmpty(this.decodingPluginName) ? this.decodingPluginName : "pgoutput";
        options.put("decoding.plugin.name", decodingPluginNameOption);
        options.put("slot.name", UUID.randomUUID().toString().toLowerCase(Locale.ROOT).replaceAll("[\\-\\d]", ""));
        if (StringUtils.isNotBlank(this.serverTimeZone)) {
            options.put("server-time-zone", this.serverTimeZone);
        }
        if (StringUtils.isNotBlank(this.scanStartupMode)) {
            options.put("debezium.snapshot.mode", this.scanStartupMode);
        }
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, new MetaField[]{MetaField.TABLE_NAME, MetaField.DATABASE_NAME, MetaField.SCHEMA_NAME, MetaField.OP_TS, MetaField.OP_TYPE, MetaField.DATA, MetaField.DATA_BYTES, MetaField.DATA_CANAL, MetaField.DATA_BYTES_CANAL, MetaField.DATA_DEBEZIUM, MetaField.DATA_BYTES_DEBEZIUM, MetaField.IS_DDL, MetaField.TS, MetaField.SQL_TYPE, MetaField.PK_NAMES});
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "meta.table_name";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "meta.database_name";
                break;
            }
            case SCHEMA_NAME: {
                metadataKey = "meta.schema_name";
                break;
            }
            case OP_TS: {
                metadataKey = "meta.op_ts";
                break;
            }
            case OP_TYPE: {
                metadataKey = "meta.op_type";
                break;
            }
            case DATA: 
            case DATA_BYTES: {
                metadataKey = "meta.data";
                break;
            }
            case DATA_CANAL: 
            case DATA_BYTES_CANAL: {
                metadataKey = "meta.data_canal";
                break;
            }
            case DATA_DEBEZIUM: 
            case DATA_BYTES_DEBEZIUM: {
                metadataKey = "meta.data_debezium";
                break;
            }
            case IS_DDL: {
                metadataKey = "meta.is_ddl";
                break;
            }
            case TS: {
                metadataKey = "meta.ts";
                break;
            }
            case SQL_TYPE: {
                metadataKey = "meta.sql_type";
                break;
            }
            case PK_NAMES: {
                metadataKey = "meta.pk_names";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", new Object[]{this.getClass().getSimpleName(), metaField}));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgresExtractNode)) {
            return false;
        }
        PostgresExtractNode other = (PostgresExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        List<String> this$tableNames = this.getTableNames();
        List<String> other$tableNames = other.getTableNames();
        if (this$tableNames == null ? other$tableNames != null : !((Object)this$tableNames).equals(other$tableNames)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$decodingPluginName = this.getDecodingPluginName();
        String other$decodingPluginName = other.getDecodingPluginName();
        if (this$decodingPluginName == null ? other$decodingPluginName != null : !this$decodingPluginName.equals(other$decodingPluginName)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        return !(this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PostgresExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        List<String> $tableNames = this.getTableNames();
        result = result * 59 + ($tableNames == null ? 43 : ((Object)$tableNames).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $decodingPluginName = this.getDecodingPluginName();
        result = result * 59 + ($decodingPluginName == null ? 43 : $decodingPluginName.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        return result;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDecodingPluginName() {
        return this.decodingPluginName;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setDecodingPluginName(String decodingPluginName) {
        this.decodingPluginName = decodingPluginName;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    @Override
    public String toString() {
        return "PostgresExtractNode(primaryKey=" + this.getPrimaryKey() + ", tableNames=" + this.getTableNames() + ", hostname=" + this.getHostname() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", port=" + this.getPort() + ", decodingPluginName=" + this.getDecodingPluginName() + ", serverTimeZone=" + this.getServerTimeZone() + ", scanStartupMode=" + this.getScanStartupMode() + ")";
    }
}

