/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.enums.KafkaScanStartupMode;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.format.AvroFormat;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.InLongMsgFormat;
import org.apache.inlong.sort.protocol.node.format.JsonFormat;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="kafkaExtract")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaExtractNode
extends ExtractNode
implements InlongMetric,
Metadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    @JsonProperty(value="topic")
    private String topic;
    @Nonnull
    @JsonProperty(value="bootstrapServers")
    private String bootstrapServers;
    @Nonnull
    @JsonProperty(value="format")
    private Format format;
    @JsonProperty(value="scanStartupMode")
    private KafkaScanStartupMode kafkaScanStartupMode;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="scanSpecificOffsets")
    private String scanSpecificOffsets;
    @JsonProperty(value="scanTimestampMillis")
    private String scanTimestampMillis;

    public KafkaExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="topic") String topic, @Nonnull @JsonProperty(value="bootstrapServers") String bootstrapServers, @Nonnull @JsonProperty(value="format") Format format, @JsonProperty(value="scanStartupMode") KafkaScanStartupMode kafkaScanStartupMode, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="groupId") String groupId) {
        this(id, name, fields, watermarkField, properties, topic, bootstrapServers, format, kafkaScanStartupMode, primaryKey, groupId, null, null);
    }

    @JsonCreator
    public KafkaExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="topic") String topic, @Nonnull @JsonProperty(value="bootstrapServers") String bootstrapServers, @Nonnull @JsonProperty(value="format") Format format, @JsonProperty(value="scanStartupMode") KafkaScanStartupMode kafkaScanStartupMode, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="scanSpecificOffsets") String scanSpecificOffsets, @JsonProperty(value="scanTimestampMillis") String scanTimestampMillis) {
        super(id, name, fields, watermarkField, properties);
        this.topic = Preconditions.checkNotNull(topic, "kafka topic is empty");
        this.bootstrapServers = Preconditions.checkNotNull(bootstrapServers, "kafka bootstrapServers is empty");
        this.format = Preconditions.checkNotNull(format, "kafka format is empty");
        this.kafkaScanStartupMode = kafkaScanStartupMode;
        this.primaryKey = primaryKey;
        this.groupId = groupId;
        if (kafkaScanStartupMode == KafkaScanStartupMode.SPECIFIC_OFFSETS) {
            Preconditions.checkArgument(StringUtils.isNotEmpty(scanSpecificOffsets), "scanSpecificOffsets is empty");
            this.scanSpecificOffsets = scanSpecificOffsets;
        }
        if (KafkaScanStartupMode.TIMESTAMP_MILLIS == kafkaScanStartupMode) {
            Preconditions.checkArgument(StringUtils.isNotBlank(scanTimestampMillis), "scanTimestampMillis is empty");
            this.scanTimestampMillis = scanTimestampMillis;
        }
        if (KafkaScanStartupMode.GROUP_OFFSETS == kafkaScanStartupMode) {
            Preconditions.checkArgument(StringUtils.isNotBlank(groupId), "group is empty when enable group offsets");
        }
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("topic", this.topic);
        options.put("properties.bootstrap.servers", this.bootstrapServers);
        if (this.isUpsertKafkaConnector(this.format, !StringUtils.isEmpty(this.primaryKey))) {
            options.put("connector", "upsert-kafka-inlong");
            options.putAll(this.format.generateOptions(true));
        } else {
            options.put("connector", "kafka-inlong");
            options.putAll(this.format.generateOptions(false));
            options.put("scan.startup.mode", this.kafkaScanStartupMode.getValue());
            if (StringUtils.isNotEmpty(this.scanSpecificOffsets)) {
                options.put("scan.startup.specific-offsets", this.scanSpecificOffsets);
            }
            if (StringUtils.isNotBlank(this.scanTimestampMillis)) {
                options.put("scan.startup.timestamp-millis", this.scanTimestampMillis);
            }
        }
        if (StringUtils.isNotEmpty(this.groupId)) {
            options.put("properties.group.id", this.groupId);
        }
        return options;
    }

    private boolean isUpsertKafkaConnector(Format format, boolean hasPrimaryKey) {
        if (format instanceof JsonFormat && hasPrimaryKey) {
            return true;
        }
        if (format instanceof CsvFormat && hasPrimaryKey) {
            return true;
        }
        return format instanceof AvroFormat && hasPrimaryKey;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "value.table";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "value.database";
                break;
            }
            case SQL_TYPE: {
                metadataKey = "value.sql-type";
                break;
            }
            case PK_NAMES: {
                metadataKey = "value.pk-names";
                break;
            }
            case TS: {
                metadataKey = "value.ingestion-timestamp";
                break;
            }
            case OP_TS: {
                metadataKey = "value.event-timestamp";
                break;
            }
            case OP_TYPE: {
                metadataKey = "value.type";
                break;
            }
            case IS_DDL: {
                metadataKey = "value.is-ddl";
                break;
            }
            case MYSQL_TYPE: {
                metadataKey = "value.mysql-type";
                break;
            }
            case BATCH_ID: {
                metadataKey = "value.batch-id";
                break;
            }
            case UPDATE_BEFORE: {
                metadataKey = "value.update-before";
                break;
            }
            case KEY: {
                metadataKey = "key";
                break;
            }
            case VALUE: {
                metadataKey = "value";
                break;
            }
            case HEADERS: {
                metadataKey = "headers";
                break;
            }
            case HEADERS_TO_JSON_STR: {
                metadataKey = "headers_to_json_str";
                break;
            }
            case PARTITION: {
                metadataKey = "partition";
                break;
            }
            case OFFSET: {
                metadataKey = "offset";
                break;
            }
            case TIMESTAMP: {
                metadataKey = "timestamp";
                break;
            }
            case AUDIT_DATA_TIME: {
                if (this.format instanceof InLongMsgFormat) {
                    metadataKey = "value.data-time";
                    break;
                }
                metadataKey = "consume_time";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", new Object[]{this.getClass().getSimpleName(), metaField}));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        switch (metaField) {
            case KEY: 
            case VALUE: 
            case HEADERS: 
            case HEADERS_TO_JSON_STR: 
            case PARTITION: 
            case OFFSET: 
            case TIMESTAMP: 
            case AUDIT_DATA_TIME: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, new MetaField[]{MetaField.TABLE_NAME, MetaField.OP_TYPE, MetaField.DATABASE_NAME, MetaField.SQL_TYPE, MetaField.PK_NAMES, MetaField.TS, MetaField.OP_TS, MetaField.IS_DDL, MetaField.MYSQL_TYPE, MetaField.BATCH_ID, MetaField.UPDATE_BEFORE, MetaField.KEY, MetaField.VALUE, MetaField.PARTITION, MetaField.HEADERS, MetaField.HEADERS_TO_JSON_STR, MetaField.OFFSET, MetaField.TIMESTAMP, MetaField.AUDIT_DATA_TIME});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaExtractNode)) {
            return false;
        }
        KafkaExtractNode other = (KafkaExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        KafkaScanStartupMode this$kafkaScanStartupMode = this.getKafkaScanStartupMode();
        KafkaScanStartupMode other$kafkaScanStartupMode = other.getKafkaScanStartupMode();
        if (this$kafkaScanStartupMode == null ? other$kafkaScanStartupMode != null : !((Object)((Object)this$kafkaScanStartupMode)).equals((Object)other$kafkaScanStartupMode)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$scanSpecificOffsets = this.getScanSpecificOffsets();
        String other$scanSpecificOffsets = other.getScanSpecificOffsets();
        if (this$scanSpecificOffsets == null ? other$scanSpecificOffsets != null : !this$scanSpecificOffsets.equals(other$scanSpecificOffsets)) {
            return false;
        }
        String this$scanTimestampMillis = this.getScanTimestampMillis();
        String other$scanTimestampMillis = other.getScanTimestampMillis();
        return !(this$scanTimestampMillis == null ? other$scanTimestampMillis != null : !this$scanTimestampMillis.equals(other$scanTimestampMillis));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        KafkaScanStartupMode $kafkaScanStartupMode = this.getKafkaScanStartupMode();
        result = result * 59 + ($kafkaScanStartupMode == null ? 43 : ((Object)((Object)$kafkaScanStartupMode)).hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $scanSpecificOffsets = this.getScanSpecificOffsets();
        result = result * 59 + ($scanSpecificOffsets == null ? 43 : $scanSpecificOffsets.hashCode());
        String $scanTimestampMillis = this.getScanTimestampMillis();
        result = result * 59 + ($scanTimestampMillis == null ? 43 : $scanTimestampMillis.hashCode());
        return result;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    public KafkaScanStartupMode getKafkaScanStartupMode() {
        return this.kafkaScanStartupMode;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getScanSpecificOffsets() {
        return this.scanSpecificOffsets;
    }

    public String getScanTimestampMillis() {
        return this.scanTimestampMillis;
    }

    public void setTopic(@Nonnull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.topic = topic;
    }

    public void setBootstrapServers(@Nonnull String bootstrapServers) {
        if (bootstrapServers == null) {
            throw new NullPointerException("bootstrapServers is marked non-null but is null");
        }
        this.bootstrapServers = bootstrapServers;
    }

    public void setFormat(@Nonnull Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setKafkaScanStartupMode(KafkaScanStartupMode kafkaScanStartupMode) {
        this.kafkaScanStartupMode = kafkaScanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setScanSpecificOffsets(String scanSpecificOffsets) {
        this.scanSpecificOffsets = scanSpecificOffsets;
    }

    public void setScanTimestampMillis(String scanTimestampMillis) {
        this.scanTimestampMillis = scanTimestampMillis;
    }

    @Override
    public String toString() {
        return "KafkaExtractNode(topic=" + this.getTopic() + ", bootstrapServers=" + this.getBootstrapServers() + ", format=" + this.getFormat() + ", kafkaScanStartupMode=" + (Object)((Object)this.getKafkaScanStartupMode()) + ", primaryKey=" + this.getPrimaryKey() + ", groupId=" + this.getGroupId() + ", scanSpecificOffsets=" + this.getScanSpecificOffsets() + ", scanTimestampMillis=" + this.getScanTimestampMillis() + ")";
    }
}

