/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg.row;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInLongMsgFormatDeserializer
extends TableFormatDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInLongMsgFormatDeserializer.class);
    @Nonnull
    protected FailureHandler failureHandler;

    @Deprecated
    public AbstractInLongMsgFormatDeserializer(@Nonnull Boolean ignoreErrors) {
        this(InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
    }

    public AbstractInLongMsgFormatDeserializer(@Nonnull FailureHandler failureHandler) {
        this.failureHandler = (FailureHandler)Preconditions.checkNotNull((Object)failureHandler);
    }

    protected abstract InLongMsgHead parseHead(String var1) throws Exception;

    protected abstract List<InLongMsgBody> parseBodyList(byte[] var1) throws Exception;

    protected abstract List<Row> convertRows(InLongMsgHead var1, InLongMsgBody var2) throws Exception;

    public void flatMap(byte[] bytes, Collector<Row> collector) throws Exception {
        InLongMsg inLongMsg = InLongMsg.parseFrom(bytes);
        for (String attr : inLongMsg.getAttrs()) {
            InLongMsgHead head;
            Iterator<byte[]> iterator = inLongMsg.getIterator(attr);
            if (iterator == null) continue;
            try {
                head = this.parseHead(attr);
            }
            catch (Exception e) {
                this.failureHandler.onParsingHeadFailure(attr, e);
                continue;
            }
            while (iterator.hasNext()) {
                List<InLongMsgBody> bodyList;
                byte[] bodyBytes = iterator.next();
                if (bodyBytes == null || bodyBytes.length == 0) continue;
                try {
                    bodyList = this.parseBodyList(bodyBytes);
                }
                catch (Exception e) {
                    this.failureHandler.onParsingBodyFailure(head, bodyBytes, e);
                    continue;
                }
                for (InLongMsgBody body : bodyList) {
                    List<Row> rows;
                    try {
                        rows = this.convertRows(head, body);
                    }
                    catch (Exception e) {
                        this.failureHandler.onConvertingRowFailure(head, body, e);
                        continue;
                    }
                    if (rows == null) continue;
                    for (Row row : rows) {
                        collector.collect((Object)row);
                    }
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractInLongMsgFormatDeserializer that = (AbstractInLongMsgFormatDeserializer)((Object)o);
        return Objects.equals(this.failureHandler, that.failureHandler);
    }

    public int hashCode() {
        return Objects.hash(this.failureHandler);
    }
}

