/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.listener.GroupTaskListenerFactory;
import org.apache.inlong.manager.service.listener.group.InitGroupCompleteListener;
import org.apache.inlong.manager.service.listener.group.InitGroupFailedListener;
import org.apache.inlong.manager.service.listener.group.InitGroupListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateGroupWorkflowDefinition.class);
    @Autowired
    private InitGroupListener initGroupListener;
    @Autowired
    private InitGroupCompleteListener initGroupCompleteListener;
    @Autowired
    private InitGroupFailedListener initGroupFailedListener;
    @Autowired
    private GroupTaskListenerFactory groupTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(GroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        process.addListener((ProcessEventListener)this.initGroupListener);
        process.addListener((ProcessEventListener)this.initGroupCompleteListener);
        process.addListener((ProcessEventListener)this.initGroupFailedListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initMQTask = new ServiceTask();
        initMQTask.setName("InitMQ");
        initMQTask.setDisplayName("Group-InitMQ");
        initMQTask.setServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQTask.setListenerFactory((TaskListenerFactory)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initMQTask);
        ServiceTask initSortTask = new ServiceTask();
        initSortTask.setName("InitSort");
        initSortTask.setDisplayName("Group-InitSort");
        initSortTask.setServiceTaskType(ServiceTaskType.INIT_SORT);
        initSortTask.setListenerFactory((TaskListenerFactory)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initSortTask);
        ServiceTask initScheduleTask = new ServiceTask();
        initScheduleTask.setName("InitSchedule");
        initScheduleTask.setDisplayName("Group-InitSchedule");
        initScheduleTask.setServiceTaskType(ServiceTaskType.INIT_SCHEDULE);
        initScheduleTask.setListenerFactory((TaskListenerFactory)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initScheduleTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initMQTask);
        initMQTask.addNext((Element)initSortTask);
        initSortTask.addNext((Element)initScheduleTask);
        initScheduleTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_GROUP_RESOURCE;
    }
}

