/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.schedule;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.common.bounded.Boundaries;
import org.apache.inlong.manager.common.enums.ScheduleStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupExtEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupExtEntityMapper;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfoRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.schedule.ScheduleClientFactory;
import org.apache.inlong.manager.schedule.ScheduleEngineClient;
import org.apache.inlong.manager.service.schedule.OfflineJobOperatorFactory;
import org.apache.inlong.manager.service.schedule.ScheduleOperator;
import org.apache.inlong.manager.service.schedule.ScheduleService;
import org.apache.inlong.manager.workflow.processor.OfflineJobOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleOperatorImpl
implements ScheduleOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleOperatorImpl.class);
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private InlongGroupExtEntityMapper groupExtMapper;
    @Autowired
    private ScheduleClientFactory scheduleClientFactory;
    private OfflineJobOperator offlineJobOperator;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public int saveOpt(ScheduleInfoRequest request, String operator) {
        int scheduleInfoId = this.scheduleService.save(request, operator);
        LOGGER.info("Save schedule info success for group {}", (Object)request.getInlongGroupId());
        this.registerScheduleInfoForApprovedGroup((ScheduleInfo)CommonBeanUtils.copyProperties((Object)request, ScheduleInfo::new), operator);
        return scheduleInfoId;
    }

    private void registerScheduleInfoForApprovedGroup(ScheduleInfo scheduleInfo, String operator) {
        String groupId = scheduleInfo.getInlongGroupId();
        InlongGroupExtEntity scheduleStatusExt = this.groupExtMapper.selectByUniqueKey(groupId, "register.schedule.status");
        if (scheduleStatusExt != null && "registered".equalsIgnoreCase(scheduleStatusExt.getKeyValue())) {
            this.scheduleService.updateStatus(scheduleInfo.getInlongGroupId(), ScheduleStatus.APPROVED, operator);
            this.registerToScheduleEngine(scheduleInfo, operator, false);
            LOGGER.info("Register schedule info success for group {}", (Object)groupId);
        }
    }

    private ScheduleEngineClient getScheduleEngineClient(String scheduleEngine) {
        return this.scheduleClientFactory.getInstance(scheduleEngine);
    }

    @Override
    public Boolean scheduleInfoExist(String groupId) {
        return this.scheduleService.exist(groupId);
    }

    @Override
    public ScheduleInfo getScheduleInfo(String groupId) {
        return this.scheduleService.get(groupId);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean updateOpt(ScheduleInfoRequest request, String operator) {
        if (!this.scheduleInfoExist(request.getInlongGroupId()).booleanValue()) {
            this.saveOpt(request, operator);
            return true;
        }
        ScheduleInfo scheduleInfo = (ScheduleInfo)CommonBeanUtils.copyProperties((Object)request, ScheduleInfo::new);
        if (!this.needUpdate(scheduleInfo)) {
            LOGGER.info("schedule info not changed for group {}", (Object)request.getInlongGroupId());
            return false;
        }
        boolean res = this.scheduleService.update(request, operator);
        this.scheduleService.updateStatus(request.getInlongGroupId(), ScheduleStatus.UPDATED, operator);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean updateAndRegister(ScheduleInfoRequest request, String operator) {
        if (this.updateOpt(request, operator).booleanValue()) {
            return this.registerToScheduleEngine((ScheduleInfo)CommonBeanUtils.copyProperties((Object)request, ScheduleInfo::new), operator, true);
        }
        return false;
    }

    private Boolean registerToScheduleEngine(ScheduleInfo scheduleInfo, String operator, boolean isUpdate) {
        boolean res = isUpdate ? this.getScheduleEngineClient(scheduleInfo.getScheduleEngine()).update(scheduleInfo) : this.getScheduleEngineClient(scheduleInfo.getScheduleEngine()).register(scheduleInfo);
        this.scheduleService.updateStatus(scheduleInfo.getInlongGroupId(), ScheduleStatus.REGISTERED, operator);
        LOGGER.info("{} schedule info success for group {}", (Object)(isUpdate ? "Update" : "Register"), (Object)scheduleInfo.getInlongGroupId());
        return res;
    }

    private boolean needUpdate(ScheduleInfo scheduleInfo) {
        if (scheduleInfo == null) {
            return false;
        }
        ScheduleInfo existedSchedule = this.getScheduleInfo(scheduleInfo.getInlongGroupId());
        return !scheduleInfo.equals((Object)existedSchedule);
    }

    @Override
    public Boolean deleteByGroupIdOpt(String groupId, String operator) {
        return this.scheduleService.deleteByGroupId(groupId, operator);
    }

    @Override
    public Boolean handleGroupApprove(String groupId) {
        if (!this.scheduleInfoExist(groupId).booleanValue()) {
            LOGGER.warn("schedule info not exist for group {}", (Object)groupId);
            return false;
        }
        this.scheduleService.updateStatus(groupId, ScheduleStatus.APPROVED, null);
        return this.registerToScheduleEngine(this.getScheduleInfo(groupId), null, false);
    }

    @Override
    public Boolean submitOfflineJob(String groupId, List<InlongStreamInfo> streamInfoList, Boundaries boundaries) {
        if (this.offlineJobOperator == null) {
            this.offlineJobOperator = OfflineJobOperatorFactory.getOfflineJobOperator();
        }
        try {
            this.offlineJobOperator.submitOfflineJob(groupId, streamInfoList, boundaries);
            LOGGER.info("Submit offline job for group {} and stream list {} success.", (Object)groupId, streamInfoList.stream().map(InlongStreamInfo::getName).collect(Collectors.toList()));
        }
        catch (Exception e) {
            String errorMsg = String.format("Submit offline job failed for groupId=%s", groupId);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new BusinessException(errorMsg);
        }
        return true;
    }
}

