/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hudi;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.inlong.manager.pojo.sink.hudi.HudiColumnInfo;
import org.apache.inlong.manager.pojo.sink.hudi.HudiTableInfo;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiFileFormat;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiTypeConverter;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudiCatalogClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HudiCatalogClient.class);
    private String dbName;
    private final String warehouse;
    private IMetaStoreClient client;
    private final HiveConf hiveConf;

    public HudiCatalogClient(String uri, String warehouse, String dbName) throws MetaException {
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.hiveConf = new HiveConf();
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, uri);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, false);
    }

    public HudiCatalogClient(String uri, String warehouse) throws MetaException {
        this.warehouse = warehouse;
        this.hiveConf = new HiveConf();
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, uri);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, false);
    }

    public void open() {
        if (this.client == null) {
            try {
                this.client = new HiveMetaStoreClient((Configuration)this.hiveConf);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create hive metastore client", e);
            }
            LOG.info("Connected to Hive metastore");
        }
    }

    private void createDatabase(String warehouse, Map<String, String> meta, boolean ignoreIfExists) {
        Database database = new Database();
        HashMap parameter = Maps.newHashMap();
        database.setName(this.dbName);
        database.setLocationUri(new Path(warehouse, this.dbName) + ".db");
        meta.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
            database.setParameters(parameter);
        });
        try {
            this.client.createDatabase(database);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new RuntimeException("Database '" + this.dbName + "' already exist!");
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create database '" + this.dbName + "'", e);
        }
    }

    public void createDatabase(String warehouse, boolean ignoreIfExists) {
        this.createDatabase(warehouse, Maps.newHashMap(), ignoreIfExists);
    }

    public boolean tableExist(String tableName) throws TException {
        return this.client.tableExists(this.dbName, tableName);
    }

    public List<HudiColumnInfo> getColumns(String dbName, String tableName) throws TException {
        Table hiveTable = this.client.getTable(dbName, tableName);
        List allCols = hiveTable.getSd().getCols().stream().filter(s -> !HudiUtils.isMetadataFile(s.getName())).collect(Collectors.toList());
        return allCols.stream().map(s -> {
            HudiColumnInfo info = new HudiColumnInfo();
            info.setName(s.getName());
            info.setType(s.getType());
            return info;
        }).collect(Collectors.toList());
    }

    public void addColumns(String tableName, List<HudiColumnInfo> columns) throws TException {
        Table hiveTable = this.client.getTable(this.dbName, tableName);
        Table newHiveTable = hiveTable.deepCopy();
        List cols = newHiveTable.getSd().getCols();
        for (HudiColumnInfo column : columns) {
            FieldSchema fieldSchema = new FieldSchema();
            fieldSchema.setName(column.getName());
            fieldSchema.setType(column.getType());
            fieldSchema.setComment(column.getDesc());
            cols.add(fieldSchema);
        }
        newHiveTable.getSd().setCols(cols);
        this.client.alter_table(this.dbName, tableName, newHiveTable);
    }

    public void createTable(String tableName, HudiTableInfo tableInfo, boolean useRealTimeInputFormat) throws TException, IOException {
        Table hiveTable = this.getEmptyTable(this.dbName, tableName);
        hiveTable.setOwner(UserGroupInformation.getCurrentUser().getUserName());
        hiveTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        HashMap<String, String> properties = new HashMap<String, String>();
        String location = this.warehouse + "/" + this.dbName + ".db/" + tableName;
        properties.put("path", location);
        List cols = tableInfo.getColumns().stream().map(column -> {
            FieldSchema fieldSchema = new FieldSchema();
            fieldSchema.setName(column.getName());
            fieldSchema.setType(HudiTypeConverter.convert(column));
            fieldSchema.setComment(column.getDesc());
            return fieldSchema;
        }).collect(Collectors.toList());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(cols);
        hiveTable.setDbName(this.dbName);
        hiveTable.setTableName(tableName);
        HudiFileFormat baseFileFormat = HudiFileFormat.PARQUET;
        String inputFormatClassName = HudiUtils.getInputFormatClassName(baseFileFormat, useRealTimeInputFormat);
        String outputFormatClassName = HudiUtils.getOutputFormatClassName(baseFileFormat);
        String serDeClassName = HudiUtils.getSerDeClassName(baseFileFormat);
        sd.setInputFormat(inputFormatClassName);
        sd.setOutputFormat(outputFormatClassName);
        HashMap<String, String> serdeProperties = new HashMap<String, String>();
        serdeProperties.put("path", location);
        serdeProperties.put("Hudi.query.as.ro.table", String.valueOf(!useRealTimeInputFormat));
        sd.setSerdeInfo(new SerDeInfo(null, serDeClassName, serdeProperties));
        sd.setLocation(location);
        hiveTable.setSd(sd);
        hiveTable.setParameters(properties);
        this.client.createTable(hiveTable);
    }

    public List<String> listAllDatabases() throws TException {
        return this.client.getAllDatabases();
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            LOG.info("Disconnect to hive metastore");
        }
    }

    public Table getEmptyTable(String databaseName, String tableName) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList());
        sd.setCols(new ArrayList());
        sd.setParameters(new HashMap());
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().setSerializationLib(MetadataTypedColumnsetSerDe.class.getName());
        sd.getSerdeInfo().getParameters().put("serialization.format", "1");
        sd.setInputFormat(SequenceFileInputFormat.class.getName());
        SkewedInfo skewInfo = new SkewedInfo();
        skewInfo.setSkewedColNames(new ArrayList());
        skewInfo.setSkewedColValues(new ArrayList());
        skewInfo.setSkewedColValueLocationMaps(new HashMap());
        sd.setSkewedInfo(skewInfo);
        Table t = new Table();
        t.setSd(sd);
        t.setPartitionKeys(new ArrayList());
        t.setParameters(new HashMap());
        t.setTableType(TableType.MANAGED_TABLE.toString());
        t.setDbName(databaseName);
        t.setTableName(tableName);
        t.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        t.getParameters().put("bucketing_version", "2");
        return t;
    }
}

