/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue.pulsar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.HttpUtils;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarBrokerEntryMetadata;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarLookupTopicInfo;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarMessageInfo;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarMessageMetadata;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarNamespacePolicies;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarTenantInfo;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarTopicMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class PulsarUtils {
    private static final Logger log = LoggerFactory.getLogger(PulsarUtils.class);
    public static final String QUERY_CLUSTERS_PATH = "/admin/v2/clusters";
    public static final String QUERY_BROKERS_PATH = "/admin/v2/brokers";
    public static final String QUERY_TENANTS_PATH = "/admin/v2/tenants";
    public static final String QUERY_NAMESPACE_PATH = "/admin/v2/namespaces";
    public static final String QUERY_PERSISTENT_PATH = "/admin/v2/persistent";
    public static final String LOOKUP_TOPIC_PATH = "/lookup/v2/topic";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final Gson GSON = new GsonBuilder().create();

    private PulsarUtils() {
    }

    private static HttpHeaders getHttpHeaders(String token) {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add("Authorization", "Bearer " + token);
        }
        return headers;
    }

    public static List<String> getClusters(RestTemplate restTemplate, PulsarClusterInfo clusterInfo) throws Exception {
        return (List)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls(QUERY_CLUSTERS_PATH), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class);
    }

    public static List<String> getBrokers(RestTemplate restTemplate, PulsarClusterInfo clusterInfo) throws Exception {
        List<String> clusters = PulsarUtils.getClusters(restTemplate, clusterInfo);
        ArrayList<String> brokers = new ArrayList<String>();
        for (String brokerName : clusters) {
            brokers.addAll((Collection)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/brokers/" + brokerName), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class));
        }
        return brokers;
    }

    public static List<String> getTenants(RestTemplate restTemplate, PulsarClusterInfo clusterInfo) throws Exception {
        return (List)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls(QUERY_TENANTS_PATH), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class);
    }

    public static List<String> getNamespaces(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String tenant) throws Exception {
        return (List)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/namespaces/" + tenant), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class);
    }

    public static void createTenant(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String tenant, PulsarTenantInfo tenantInfo) throws Exception {
        HttpHeaders headers = PulsarUtils.getHttpHeaders(clusterInfo.getToken());
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        String param = GSON.toJson((Object)tenantInfo);
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/tenants/" + tenant), (HttpMethod)HttpMethod.PUT, (Object)param, (HttpHeaders)headers);
    }

    public static void createNamespace(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String tenant, String namespaceName, PulsarNamespacePolicies policies) throws Exception {
        HttpHeaders headers = PulsarUtils.getHttpHeaders(clusterInfo.getToken());
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        String param = GSON.toJson((Object)policies);
        param = param.replaceAll("messageTtlInSeconds", "message_ttl_in_seconds").replaceAll("retentionPolicies", "retention_policies");
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/namespaces/" + tenant + "/" + namespaceName), (HttpMethod)HttpMethod.PUT, (Object)param, (HttpHeaders)headers);
    }

    public static List<String> getTopics(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String tenant, String namespace) throws Exception {
        return (List)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + tenant + "/" + namespace), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class);
    }

    public static List<String> getPartitionedTopics(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String tenant, String namespace) throws Exception {
        return (List)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + tenant + "/" + namespace + "/partitioned"), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class);
    }

    public static void createNonPartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath), (HttpMethod)HttpMethod.PUT, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    public static void createPartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath, Integer numPartitions) throws Exception {
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/partitions"), (HttpMethod)HttpMethod.PUT, (Object)numPartitions.toString(), (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    public static JsonObject getInternalStatsPartitionedTopics(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        return (JsonObject)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/partitioned-internalStats"), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), JsonObject.class);
    }

    public static PulsarTopicMetadata getPartitionedTopicMetadata(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        return (PulsarTopicMetadata)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/partitions"), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), PulsarTopicMetadata.class);
    }

    public static void deleteNonPartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath), (HttpMethod)HttpMethod.DELETE, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    public static void forceDeleteNonPartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        HashMap<String, Boolean> uriVariables = new HashMap<String, Boolean>();
        uriVariables.put("force", true);
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath), (HttpMethod)HttpMethod.DELETE, uriVariables, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    public static void deletePartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/partitions"), (HttpMethod)HttpMethod.DELETE, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    public static void forceDeletePartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        HashMap<String, Boolean> uriVariables = new HashMap<String, Boolean>();
        uriVariables.put("force", true);
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/partitions"), (HttpMethod)HttpMethod.DELETE, uriVariables, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    public static void deleteTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath, boolean isPartitioned) throws Exception {
        if (isPartitioned) {
            PulsarUtils.deletePartitionedTopic(restTemplate, clusterInfo, topicPath);
        } else {
            PulsarUtils.deleteNonPartitionedTopic(restTemplate, clusterInfo, topicPath);
        }
    }

    public static void forceDeleteTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath, boolean isPartitioned) throws Exception {
        if (isPartitioned) {
            PulsarUtils.forceDeletePartitionedTopic(restTemplate, clusterInfo, topicPath);
        } else {
            PulsarUtils.forceDeleteNonPartitionedTopic(restTemplate, clusterInfo, topicPath);
        }
    }

    public static String lookupTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        PulsarLookupTopicInfo topicInfo = (PulsarLookupTopicInfo)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/lookup/v2/topic/persistent/" + topicPath), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), PulsarLookupTopicInfo.class);
        return topicInfo.getBrokerUrl();
    }

    public static Map<String, String> lookupPartitionedTopic(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        PulsarTopicMetadata metadata = PulsarUtils.getPartitionedTopicMetadata(restTemplate, clusterInfo, topicPath);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < metadata.getPartitions(); ++i) {
            String partitionTopicName = topicPath + "-partition-" + i;
            PulsarLookupTopicInfo topicInfo = (PulsarLookupTopicInfo)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/lookup/v2/topic/persistent/" + partitionTopicName), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), PulsarLookupTopicInfo.class);
            map.put(partitionTopicName, topicInfo.getBrokerUrl());
        }
        return map;
    }

    public static List<String> getSubscriptions(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath) throws Exception {
        return (List)HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/subscriptions"), (HttpMethod)HttpMethod.GET, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()), ArrayList.class);
    }

    public static void createSubscription(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath, String subscription) throws Exception {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("entryId", (Number)Long.MAX_VALUE);
        jsonObject.addProperty("ledgerId", (Number)Long.MAX_VALUE);
        jsonObject.addProperty("partitionIndex", (Number)-1);
        HttpHeaders headers = PulsarUtils.getHttpHeaders(clusterInfo.getToken());
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/subscription/" + subscription), (HttpMethod)HttpMethod.PUT, (Object)jsonObject.toString(), (HttpHeaders)headers);
    }

    public static ResponseEntity<byte[]> examineMessage(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPartition, String messageType, int messagePosition) throws Exception {
        String adminUrl = clusterInfo.getAdminUrl();
        String[] adminUrls = adminUrl.replace("http://", "").split(",");
        for (int i = 0; i < adminUrls.length; ++i) {
            try {
                StringBuilder urlBuilder = new StringBuilder().append("http://" + adminUrls[i]).append(QUERY_PERSISTENT_PATH).append("/").append(topicPartition).append("/examinemessage").append("?initialPosition=").append(messageType).append("&messagePosition=").append(messagePosition);
                ResponseEntity response = restTemplate.exchange(urlBuilder.toString(), HttpMethod.GET, new HttpEntity((MultiValueMap)PulsarUtils.getHttpHeaders(clusterInfo.getToken())), byte[].class, new Object[0]);
                if (!response.getStatusCode().is2xxSuccessful()) {
                    log.error("request error for {}, status code {}, body {}", new Object[]{urlBuilder.toString(), response.getStatusCode(), response.getBody()});
                }
                return response;
            }
            catch (Exception e) {
                log.error("examine message for topic partition={} error, begin retry", (Object)topicPartition, (Object)e);
                if (i < adminUrls.length - 1) continue;
                log.error("after retry, examine message for topic partition={} still error", (Object)topicPartition, (Object)e);
                throw e;
            }
        }
        throw new Exception(String.format("examine message failed for topic partition=%s", topicPartition));
    }

    public static PulsarMessageInfo getMessageFromHttpResponse(ResponseEntity<byte[]> response, String topic) throws Exception {
        List<PulsarMessageInfo> messages = PulsarUtils.getMessagesFromHttpResponse(response, topic);
        if (messages.size() > 0) {
            return messages.get(0);
        }
        return null;
    }

    public static List<PulsarMessageInfo> getMessagesFromHttpResponse(ResponseEntity<byte[]> response, String topic) throws Exception {
        List tmpList;
        PulsarBrokerEntryMetadata brokerEntryMetadata;
        HttpHeaders headers = response.getHeaders();
        String msgId = headers.getFirst("X-Pulsar-Message-ID");
        String brokerEntryTimestamp = headers.getFirst("X-Pulsar-Broker-Entry-METADATA-timestamp");
        String brokerEntryIndex = headers.getFirst("X-Pulsar-Broker-Entry-METADATA-index");
        if (brokerEntryTimestamp == null && brokerEntryIndex == null) {
            brokerEntryMetadata = null;
        } else {
            brokerEntryMetadata = new PulsarBrokerEntryMetadata();
            if (brokerEntryTimestamp != null) {
                brokerEntryMetadata.setBrokerTimestamp(PulsarUtils.parse(brokerEntryTimestamp.toString()));
            }
            if (brokerEntryIndex != null) {
                brokerEntryMetadata.setIndex(Long.parseLong(brokerEntryIndex));
            }
        }
        PulsarMessageMetadata messageMetadata = new PulsarMessageMetadata();
        TreeMap properties = Maps.newTreeMap();
        String tmp = headers.getFirst("X-Pulsar-publish-time");
        if (tmp != null) {
            messageMetadata.setPublishTime(PulsarUtils.parse(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-event-time")) != null) {
            messageMetadata.setEventTime(PulsarUtils.parse(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-deliver-at-time")) != null) {
            messageMetadata.setDeliverAtTime(PulsarUtils.parse(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-null-value")) != null) {
            messageMetadata.setNullValue(Boolean.parseBoolean(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-producer-name")) != null) {
            messageMetadata.setProducerName(tmp.toString());
        }
        if ((tmp = headers.getFirst("X-Pulsar-sequence-id")) != null) {
            messageMetadata.setSequenceId(Long.parseLong(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-replicated-from")) != null) {
            messageMetadata.setReplicatedFrom(tmp.toString());
        }
        if ((tmp = headers.getFirst("X-Pulsar-partition-key")) != null) {
            messageMetadata.setPartitionKey(tmp.toString());
        }
        if ((tmp = headers.getFirst("X-Pulsar-compression")) != null) {
            messageMetadata.setCompression(tmp.toString());
        }
        if ((tmp = headers.getFirst("X-Pulsar-uncompressed-size")) != null) {
            messageMetadata.setUncompressedSize(Integer.parseInt(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-encryption-algo")) != null) {
            messageMetadata.setEncryptionAlgo(tmp.toString());
        }
        if ((tmp = headers.getFirst("X-Pulsar-partition-key-b64-encoded")) != null) {
            messageMetadata.setPartitionKeyB64Encoded(Boolean.parseBoolean(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-marker-type")) != null) {
            messageMetadata.setMarkerType(Integer.parseInt(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-txnid-least-bits")) != null) {
            messageMetadata.setTxnidLeastBits(Long.parseLong(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-txnid-most-bits")) != null) {
            messageMetadata.setTxnidMostBits(Long.parseLong(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-highest-sequence-id")) != null) {
            messageMetadata.setHighestSequenceId(Long.parseLong(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-uuid")) != null) {
            messageMetadata.setUuid(tmp.toString());
        }
        if ((tmp = headers.getFirst("X-Pulsar-num-chunks-from-msg")) != null) {
            messageMetadata.setNumChunksFromMsg(Integer.parseInt(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-total-chunk-msg-size")) != null) {
            messageMetadata.setTotalChunkMsgSize(Integer.parseInt(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-chunk-id")) != null) {
            messageMetadata.setChunkId(Integer.parseInt(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-null-partition-key")) != null) {
            messageMetadata.setNullPartitionKey(Boolean.parseBoolean(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-Base64-encryption-param")) != null) {
            messageMetadata.setEncryptionParam(Base64.getDecoder().decode(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-Base64-ordering-key")) != null) {
            messageMetadata.setOrderingKey(Base64.getDecoder().decode(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-Base64-schema-version-b64encoded")) != null) {
            messageMetadata.setSchemaVersion(Base64.getDecoder().decode(tmp.toString()));
        }
        if ((tmp = headers.getFirst("X-Pulsar-Base64-encryption-param")) != null) {
            messageMetadata.setEncryptionParam(Base64.getDecoder().decode(tmp.toString()));
        }
        if (ObjectUtils.isNotEmpty((Object)(tmpList = headers.get((Object)"X-Pulsar-replicated-to")))) {
            if (ObjectUtils.isEmpty((Object)messageMetadata.getReplicateTos())) {
                messageMetadata.setReplicateTos((List)Lists.newArrayList((Iterable)tmpList));
            } else {
                messageMetadata.getReplicateTos().addAll(tmpList);
            }
        }
        if ((tmp = headers.getFirst("X-Pulsar-batch-size")) != null) {
            properties.put("X-Pulsar-batch-size", tmp);
        }
        for (Map.Entry entry : headers.entrySet()) {
            if (!((String)entry.getKey()).contains("X-Pulsar-PROPERTY-")) continue;
            String keyName = ((String)entry.getKey()).substring("X-Pulsar-PROPERTY-".length());
            properties.put(keyName, (String)((List)entry.getValue()).get(0));
        }
        tmp = headers.getFirst("X-Pulsar-num-batch-message");
        if (tmp != null) {
            properties.put("X-Pulsar-num-batch-message", tmp);
        }
        boolean isEncrypted = false;
        tmp = headers.getFirst("X-Pulsar-Is-Encrypted");
        if (tmp != null) {
            isEncrypted = Boolean.parseBoolean(tmp.toString());
        }
        if (!isEncrypted && headers.get((Object)"X-Pulsar-num-batch-message") != null) {
            return PulsarUtils.getIndividualMsgsFromBatch(topic, msgId, (byte[])response.getBody(), properties, messageMetadata, brokerEntryMetadata);
        }
        PulsarMessageInfo messageInfo = new PulsarMessageInfo();
        messageInfo.setTopic(topic);
        messageInfo.setMessageId(msgId);
        messageInfo.setProperties(messageMetadata.getProperties());
        messageInfo.setBody((byte[])response.getBody());
        messageInfo.setPulsarMessageMetadata(messageMetadata);
        if (brokerEntryMetadata != null) {
            messageInfo.setPulsarBrokerEntryMetadata(brokerEntryMetadata);
        }
        return Collections.singletonList(messageInfo);
    }

    private static long parse(String datetime) throws DateTimeParseException {
        Instant instant = Instant.from(DATE_FORMAT.parse(datetime));
        return instant.toEpochMilli();
    }

    private static List<PulsarMessageInfo> getIndividualMsgsFromBatch(String topic, String msgId, byte[] data, Map<String, String> properties, PulsarMessageMetadata metadata, PulsarBrokerEntryMetadata brokerMetadata) {
        ArrayList<PulsarMessageInfo> ret = new ArrayList<PulsarMessageInfo>();
        int batchSize = Integer.parseInt(properties.get("X-Pulsar-num-batch-message"));
        ByteBuffer buffer = ByteBuffer.wrap(data);
        for (int i = 0; i < batchSize; ++i) {
            String batchMsgId = msgId + ":" + i;
            PulsarMessageMetadata singleMetadata = new PulsarMessageMetadata();
            singleMetadata.setProperties(properties);
            ByteBuffer singleMessagePayload = PulsarUtils.deSerializeSingleMessageInBatch(buffer, singleMetadata, i, batchSize);
            PulsarMessageInfo messageInfo = new PulsarMessageInfo();
            messageInfo.setTopic(topic);
            messageInfo.setMessageId(batchMsgId);
            messageInfo.setProperties(singleMetadata.getProperties());
            messageInfo.setPulsarMessageMetadata(metadata);
            messageInfo.setBody(singleMessagePayload.array());
            if (brokerMetadata != null) {
                messageInfo.setPulsarBrokerEntryMetadata(brokerMetadata);
            }
            ret.add(messageInfo);
        }
        buffer.clear();
        return ret;
    }

    public static void resetCursor(RestTemplate restTemplate, PulsarClusterInfo clusterInfo, String topicPath, String subscription, Long resetTime) throws Exception {
        HttpUtils.request((RestTemplate)restTemplate, (String[])clusterInfo.getAdminUrls("/admin/v2/persistent/" + topicPath + "/subscription/" + subscription + "/resetcursor/" + resetTime), (HttpMethod)HttpMethod.POST, null, (HttpHeaders)PulsarUtils.getHttpHeaders(clusterInfo.getToken()));
    }

    private static ByteBuffer deSerializeSingleMessageInBatch(ByteBuffer uncompressedPayload, PulsarMessageMetadata metadata, int index, int batchSize) {
        int singleMetaSize = uncompressedPayload.getInt();
        PulsarUtils.metaDataParseFrom(metadata, uncompressedPayload, singleMetaSize);
        int singleMessagePayloadSize = metadata.getPayloadSize();
        int readerIndex = uncompressedPayload.position();
        byte[] singleMessagePayload = new byte[singleMessagePayloadSize];
        uncompressedPayload.get(singleMessagePayload);
        if (index < batchSize) {
            uncompressedPayload.position(readerIndex + singleMessagePayloadSize);
        }
        return ByteBuffer.wrap(singleMessagePayload);
    }

    private static void metaDataParseFrom(PulsarMessageMetadata metadata, ByteBuffer buffer, int size) {
        int endIdx = size + buffer.position();
        block12: while (buffer.position() < endIdx) {
            int tag = PulsarUtils.readVarInt(buffer);
            switch (tag) {
                case 10: {
                    int _propertiesSize = PulsarUtils.readVarInt(buffer);
                    PulsarUtils.parseFrom(metadata, buffer, _propertiesSize);
                    continue block12;
                }
                case 18: {
                    int _partitionKeyBufferLen = PulsarUtils.readVarInt(buffer);
                    byte[] partitionKeyArray = new byte[_partitionKeyBufferLen];
                    buffer.get(partitionKeyArray);
                    metadata.setPartitionKey(new String(partitionKeyArray));
                    continue block12;
                }
                case 24: {
                    int payloadSize = PulsarUtils.readVarInt(buffer);
                    metadata.setPayloadSize(payloadSize);
                    continue block12;
                }
                case 32: {
                    boolean compactedOut = PulsarUtils.readVarInt(buffer) == 1;
                    metadata.setCompactedOut(compactedOut);
                    continue block12;
                }
                case 40: {
                    long eventTime = PulsarUtils.readVarInt64(buffer);
                    metadata.setEventTime(eventTime);
                    continue block12;
                }
                case 48: {
                    boolean partitionKeyB64Encoded = PulsarUtils.readVarInt(buffer) == 1;
                    metadata.setPartitionKeyB64Encoded(partitionKeyB64Encoded);
                    continue block12;
                }
                case 58: {
                    int _orderingKeyLen = PulsarUtils.readVarInt(buffer);
                    byte[] orderingKeyArray = new byte[_orderingKeyLen];
                    metadata.setOrderingKey(orderingKeyArray);
                    continue block12;
                }
                case 64: {
                    long sequenceId = PulsarUtils.readVarInt64(buffer);
                    metadata.setSequenceId(sequenceId);
                    continue block12;
                }
                case 72: {
                    boolean nullValue = PulsarUtils.readVarInt(buffer) == 1;
                    metadata.setNullValue(nullValue);
                    continue block12;
                }
                case 80: {
                    boolean nullPartitionKey = PulsarUtils.readVarInt(buffer) == 1;
                    metadata.setNullPartitionKey(nullPartitionKey);
                    continue block12;
                }
            }
            PulsarUtils.skipUnknownField(tag, buffer);
        }
    }

    private static int readVarInt(ByteBuffer buf) {
        byte tmp = buf.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = buf.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = buf.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = buf.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = buf.get();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (buf.get() < 0) continue;
                            return result;
                        }
                        throw new IllegalArgumentException("Encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    private static long readVarInt64(ByteBuffer buf) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buf.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalArgumentException("Encountered a malformed varint.");
    }

    private static int getTagType(int tag) {
        return tag & 7;
    }

    private static void skipUnknownField(int tag, ByteBuffer buffer) {
        int tagType = PulsarUtils.getTagType(tag);
        switch (tagType) {
            case 0: {
                PulsarUtils.readVarInt(buffer);
                break;
            }
            case 1: {
                buffer.get(new byte[8]);
                break;
            }
            case 2: {
                int len = PulsarUtils.readVarInt(buffer);
                buffer.get(new byte[len]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unknonwn tag type: " + tagType);
            }
            case 5: {
                buffer.get(new byte[4]);
            }
        }
    }

    private static void parseFrom(PulsarMessageMetadata metadata, ByteBuffer buffer, int size) {
        if (ObjectUtils.isEmpty((Object)metadata.getProperties())) {
            metadata.setProperties(new HashMap());
        }
        Map properties = metadata.getProperties();
        int endIdx = buffer.position() + size;
        String key = null;
        String value = null;
        block4: while (buffer.position() < endIdx) {
            int tag = PulsarUtils.readVarInt(buffer);
            if (StringUtils.isNotEmpty(key) && StringUtils.isNotEmpty(value)) {
                properties.put(key, value);
                key = null;
                value = null;
            }
            switch (tag) {
                case 10: {
                    int keyBufferLen = PulsarUtils.readVarInt(buffer);
                    byte[] keyArray = new byte[keyBufferLen];
                    buffer.get(keyArray);
                    key = new String(keyArray);
                    continue block4;
                }
                case 18: {
                    int valueBufferLen = PulsarUtils.readVarInt(buffer);
                    byte[] valueArray = new byte[valueBufferLen];
                    buffer.get(valueArray);
                    value = new String(valueArray);
                    continue block4;
                }
            }
            PulsarUtils.skipUnknownField(tag, buffer);
        }
        if (StringUtils.isNotEmpty(key) && StringUtils.isNotEmpty(value)) {
            properties.put(key, value);
        }
    }
}

